/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.excel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.MetaModelHelper;
import org.eobjects.metamodel.data.DataSetHeader;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.data.SimpleDataSetHeader;
import org.eobjects.metamodel.delete.AbstractRowDeletionBuilder;
import org.eobjects.metamodel.excel.ExcelUpdateCallback;
import org.eobjects.metamodel.excel.ExcelUtils;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;

final class ExcelDeleteBuilder
extends AbstractRowDeletionBuilder {
    private final ExcelUpdateCallback _updateCallback;

    public ExcelDeleteBuilder(ExcelUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        this._updateCallback.close();
        Workbook workbook = this._updateCallback.getWorkbook(false);
        String tableName = this.getTable().getName();
        SelectItem[] selectItems = MetaModelHelper.createSelectItems((Column[])this.getTable().getColumns());
        SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
        Sheet sheet = workbook.getSheet(tableName);
        Iterator<org.apache.poi.ss.usermodel.Row> rowIterator = ExcelUtils.getRowIterator(sheet, this._updateCallback.getConfiguration(), true);
        ArrayList<org.apache.poi.ss.usermodel.Row> rowsToDelete = new ArrayList<org.apache.poi.ss.usermodel.Row>();
        while (rowIterator.hasNext()) {
            org.apache.poi.ss.usermodel.Row excelRow = rowIterator.next();
            DefaultRow defaultRow = ExcelUtils.createRow(workbook, excelRow, (DataSetHeader)header);
            boolean deleteRow = this.deleteRow((Row)defaultRow);
            if (!deleteRow) continue;
            rowsToDelete.add(excelRow);
        }
        Collections.reverse(rowsToDelete);
        for (org.apache.poi.ss.usermodel.Row row : rowsToDelete) {
            sheet.removeRow(row);
        }
    }
}

