/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.excel;

import java.util.Iterator;
import org.apache.poi.ss.usermodel.Workbook;
import org.eobjects.metamodel.data.AbstractDataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.excel.ExcelUtils;
import org.eobjects.metamodel.query.SelectItem;

final class XlsDataSet
extends AbstractDataSet {
    private final Iterator<org.apache.poi.ss.usermodel.Row> _rowIterator;
    private final Workbook _workbook;
    private volatile org.apache.poi.ss.usermodel.Row _row;
    private volatile boolean _closed;

    public XlsDataSet(SelectItem[] selectItems, Workbook workbook, Iterator<org.apache.poi.ss.usermodel.Row> rowIterator) {
        super(selectItems);
        this._workbook = workbook;
        this._rowIterator = rowIterator;
        this._closed = false;
    }

    public boolean next() {
        if (this._rowIterator.hasNext()) {
            this._row = this._rowIterator.next();
            return true;
        }
        this._row = null;
        this._closed = true;
        return false;
    }

    public Row getRow() {
        if (this._closed) {
            return null;
        }
        return ExcelUtils.createRow(this._workbook, this._row, this.getHeader());
    }
}

