/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.excel;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.RowPublisherDataSet;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.excel.ExcelConfiguration;
import org.eobjects.metamodel.excel.ExcelUtils;
import org.eobjects.metamodel.excel.SpreadsheetReaderDelegate;
import org.eobjects.metamodel.excel.XlsxRowCallback;
import org.eobjects.metamodel.excel.XlsxRowPublisherAction;
import org.eobjects.metamodel.excel.XlsxSheetToRowsHandler;
import org.eobjects.metamodel.excel.XlsxStopParsingException;
import org.eobjects.metamodel.excel.XlsxWorkbookToTablesHandler;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.AlphabeticSequence;
import org.eobjects.metamodel.util.FileHelper;
import org.eobjects.metamodel.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

final class XlsxSpreadsheetReaderDelegate
implements SpreadsheetReaderDelegate {
    private static final Logger logger = LoggerFactory.getLogger(XlsxSpreadsheetReaderDelegate.class);
    private final ExcelConfiguration _configuration;
    private final Map<String, String> _tableNamesToInternalIds;

    public XlsxSpreadsheetReaderDelegate(ExcelConfiguration configuration) {
        this._configuration = configuration;
        this._tableNamesToInternalIds = new HashMap<String, String>();
    }

    @Override
    public DataSet executeQuery(InputStream inputStream, Table table, Column[] columns, int maxRows) throws Exception {
        OPCPackage pkg = OPCPackage.open((InputStream)inputStream);
        XSSFReader xssfReader = new XSSFReader(pkg);
        String relationshipId = this._tableNamesToInternalIds.get(table.getName());
        return this.buildDataSet(columns, maxRows, relationshipId, xssfReader);
    }

    @Override
    public Schema createSchema(InputStream inputStream, String schemaName) throws Exception {
        MutableSchema schema = new MutableSchema(schemaName);
        OPCPackage pkg = OPCPackage.open((InputStream)inputStream);
        XSSFReader xssfReader = new XSSFReader(pkg);
        XlsxWorkbookToTablesHandler workbookToTables = new XlsxWorkbookToTablesHandler(schema, this._tableNamesToInternalIds);
        this.buildTables(xssfReader, workbookToTables);
        for (Map.Entry<String, String> entry : this._tableNamesToInternalIds.entrySet()) {
            String tableName = entry.getKey();
            String relationshipId = entry.getValue();
            MutableTable table = (MutableTable)schema.getTableByName(tableName);
            this.buildColumns(table, relationshipId, xssfReader);
        }
        return schema;
    }

    @Override
    public void notifyTablesModified(Ref<InputStream> inputStreamRef) {
        InputStream inputStream = (InputStream)inputStreamRef.get();
        XlsxWorkbookToTablesHandler workbookToTables = new XlsxWorkbookToTablesHandler(null, this._tableNamesToInternalIds);
        try {
            OPCPackage pkg = OPCPackage.open((InputStream)inputStream);
            XSSFReader xssfReader = new XSSFReader(pkg);
            this.buildTables(xssfReader, workbookToTables);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
    }

    private DataSet buildDataSet(Column[] columns, int maxRows, String relationshipId, XSSFReader xssfReader) throws Exception {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>(columns.length);
        for (Column column : columns) {
            selectItems.add(new SelectItem(column));
        }
        XlsxRowPublisherAction publishAction = new XlsxRowPublisherAction(this._configuration, columns, relationshipId, xssfReader);
        return new RowPublisherDataSet(selectItems.toArray(new SelectItem[selectItems.size()]), maxRows, (Action)publishAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildColumns(final MutableTable table, String relationshipId, XSSFReader xssfReader) throws Exception {
        InputStream sheetData = xssfReader.getSheet(relationshipId);
        XlsxRowCallback rowCallback = new XlsxRowCallback(){

            @Override
            public boolean row(int rowNumber, List<String> values, List<Style> styles) {
                int columnNameLineNumber = XlsxSpreadsheetReaderDelegate.this._configuration.getColumnNameLineNumber();
                if (columnNameLineNumber == 0) {
                    AlphabeticSequence alphabeticSequence = new AlphabeticSequence();
                    ArrayList<String> generatedColumnNames = new ArrayList<String>(values.size());
                    for (String originalColumnName : values) {
                        String columnName = alphabeticSequence.next();
                        if (originalColumnName == null) {
                            columnName = null;
                        }
                        generatedColumnNames.add(columnName);
                    }
                    XlsxSpreadsheetReaderDelegate.this.buildColumns(table, generatedColumnNames);
                    return false;
                }
                int zeroBasedLineNumber = columnNameLineNumber - 1;
                if (rowNumber >= zeroBasedLineNumber) {
                    XlsxSpreadsheetReaderDelegate.this.buildColumns(table, values);
                    return false;
                }
                return true;
            }
        };
        XlsxSheetToRowsHandler handler = new XlsxSheetToRowsHandler(rowCallback, xssfReader, this._configuration);
        XMLReader sheetParser = ExcelUtils.createXmlReader();
        sheetParser.setContentHandler(handler);
        try {
            sheetParser.parse(new InputSource(sheetData));
        }
        catch (XlsxStopParsingException e) {
            try {
                logger.debug("Parsing stop signal thrown");
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{sheetData});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{sheetData});
        }
        FileHelper.safeClose((Object[])new Object[]{sheetData});
    }

    protected void buildColumns(MutableTable table, List<String> columnNames) {
        int columnNumber = 0;
        for (String columnName : columnNames) {
            if (columnName != null || !this._configuration.isSkipEmptyColumns()) {
                if (columnName == null) {
                    columnName = "[Column " + (columnNumber + 1) + "]";
                }
                table.addColumn((Column)new MutableColumn(columnName, ColumnType.VARCHAR, (Table)table, columnNumber, Boolean.valueOf(true)));
            }
            ++columnNumber;
        }
    }

    private void buildTables(XSSFReader xssfReader, XlsxWorkbookToTablesHandler workbookToTables) throws Exception {
        InputStream workbookData = xssfReader.getWorkbookData();
        XMLReader workbookParser = ExcelUtils.createXmlReader();
        workbookParser.setContentHandler(workbookToTables);
        workbookParser.parse(new InputSource(workbookData));
        FileHelper.safeClose((Object[])new Object[]{workbookData});
    }
}

