/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.fixedwidth;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.QueryPostprocessDataContext;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.fixedwidth.FixedWidthConfiguration;
import org.eobjects.metamodel.fixedwidth.FixedWidthDataSet;
import org.eobjects.metamodel.fixedwidth.FixedWidthReader;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.schema.TableType;
import org.eobjects.metamodel.util.AlphabeticSequence;
import org.eobjects.metamodel.util.FileHelper;
import org.eobjects.metamodel.util.FileResource;
import org.eobjects.metamodel.util.Resource;

public class FixedWidthDataContext
extends QueryPostprocessDataContext {
    private final Resource _resource;
    private final FixedWidthConfiguration _configuration;

    @Deprecated
    public FixedWidthDataContext(String filename, String fileEncoding, int fixedValueWidth) {
        this((Resource)new FileResource(filename), new FixedWidthConfiguration(fixedValueWidth));
    }

    @Deprecated
    public FixedWidthDataContext(File file, String fileEncoding, int fixedValueWidth, int headerLineNumber) {
        this(file, new FixedWidthConfiguration(headerLineNumber, fileEncoding, fixedValueWidth));
    }

    public FixedWidthDataContext(File file, FixedWidthConfiguration configuration) {
        this._resource = new FileResource(file);
        this._configuration = configuration;
    }

    public FixedWidthDataContext(Resource resource, FixedWidthConfiguration configuration) {
        this._resource = resource;
        this._configuration = configuration;
    }

    public FixedWidthConfiguration getConfiguration() {
        return this._configuration;
    }

    @Deprecated
    public File getFile() {
        if (this._resource instanceof FileResource) {
            return ((FileResource)this._resource).getFile();
        }
        return null;
    }

    public Resource getResource() {
        return this._resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schema getMainSchema() throws MetaModelException {
        String[] columnNames;
        int i;
        String schemaName = this.getDefaultSchemaName();
        MutableSchema schema = new MutableSchema(schemaName);
        String tableName = schemaName.substring(0, schemaName.length() - 4);
        MutableTable table = new MutableTable(tableName, TableType.TABLE, (Schema)schema);
        schema.addTable(table);
        FixedWidthReader reader = this.createReader();
        try {
            if (this._configuration.getColumnNameLineNumber() != 0) {
                for (i = 1; i < this._configuration.getColumnNameLineNumber(); ++i) {
                    reader.readLine();
                }
                columnNames = reader.readLine();
            } else {
                columnNames = reader.readLine();
                if (columnNames != null) {
                    AlphabeticSequence sequence = new AlphabeticSequence();
                    for (int i2 = 0; i2 < columnNames.length; ++i2) {
                        columnNames[i2] = sequence.next();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            FileHelper.safeClose((Object[])new Object[]{reader});
            throw throwable;
        }
        FileHelper.safeClose((Object[])new Object[]{reader});
        if (columnNames != null) {
            for (i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                MutableColumn column = new MutableColumn(columnName, ColumnType.VARCHAR, (Table)table, i, Boolean.valueOf(true));
                column.setColumnSize(Integer.valueOf(this._configuration.getValueWidth(i)));
                table.addColumn((Column)column);
            }
        }
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._resource.getName();
    }

    public DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        FixedWidthReader reader = this.createReader();
        try {
            for (int i = 1; i <= this._configuration.getColumnNameLineNumber(); ++i) {
                reader.readLine();
            }
        }
        catch (IllegalStateException e) {
            FileHelper.safeClose((Object[])new Object[]{reader});
            throw e;
        }
        if (maxRows > 0) {
            return new FixedWidthDataSet(reader, columns, maxRows);
        }
        return new FixedWidthDataSet(reader, columns, null);
    }

    private FixedWidthReader createReader() {
        InputStream inputStream = this._resource.read();
        Reader fileReader = FileHelper.getReader((InputStream)inputStream, (String)this._configuration.getEncoding());
        FixedWidthReader reader = this._configuration.isConstantValueWidth() ? new FixedWidthReader(fileReader, this._configuration.getFixedValueWidth(), this._configuration.isFailOnInconsistentLineWidth()) : new FixedWidthReader(fileReader, this._configuration.getValueWidths(), this._configuration.isFailOnInconsistentLineWidth());
        return reader;
    }
}

