/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel;

import com.mongodb.DB;
import com.mongodb.Mongo;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.Collection;
import javax.sql.DataSource;
import org.ektorp.http.StdHttpClient;
import org.eobjects.metamodel.CompositeDataContext;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.UpdateableDataContext;
import org.eobjects.metamodel.access.AccessDataContext;
import org.eobjects.metamodel.couchdb.CouchDbDataContext;
import org.eobjects.metamodel.csv.CsvConfiguration;
import org.eobjects.metamodel.csv.CsvDataContext;
import org.eobjects.metamodel.dbase.DbaseDataContext;
import org.eobjects.metamodel.excel.ExcelConfiguration;
import org.eobjects.metamodel.excel.ExcelDataContext;
import org.eobjects.metamodel.fixedwidth.FixedWidthConfiguration;
import org.eobjects.metamodel.fixedwidth.FixedWidthDataContext;
import org.eobjects.metamodel.jdbc.JdbcDataContext;
import org.eobjects.metamodel.mongodb.MongoDbDataContext;
import org.eobjects.metamodel.openoffice.OpenOfficeDataContext;
import org.eobjects.metamodel.salesforce.SalesforceDataContext;
import org.eobjects.metamodel.schema.TableType;
import org.eobjects.metamodel.sugarcrm.SugarCrmDataContext;
import org.eobjects.metamodel.xml.XmlDomDataContext;
import org.xml.sax.InputSource;

public class DataContextFactory {
    public static final char DEFAULT_CSV_SEPARATOR_CHAR = ',';
    public static final char DEFAULT_CSV_QUOTE_CHAR = '\"';

    private DataContextFactory() {
    }

    public static DataContext createCompositeDataContext(DataContext ... delegates) {
        return new CompositeDataContext(delegates);
    }

    public static DataContext createCompositeDataContext(Collection<DataContext> delegates) {
        return new CompositeDataContext(delegates);
    }

    public static DataContext createAccessDataContext(String filename) {
        return new AccessDataContext(filename);
    }

    public static DataContext createAccessDataContext(File file) {
        return new AccessDataContext(file);
    }

    public static DataContext createDbaseDataContext(File file) {
        return new DbaseDataContext(file);
    }

    public static DataContext createDbaseDataContext(String filename) {
        return new DbaseDataContext(filename);
    }

    public static DataContext createSalesforceDataContext(String username, String password, String securityToken) {
        return new SalesforceDataContext(username, password, securityToken);
    }

    public static DataContext createSugarCrmDataContext(String baseUrl, String username, String password, String applicationName) {
        return new SugarCrmDataContext(baseUrl, username, password, applicationName);
    }

    public static UpdateableDataContext createCsvDataContext(File file) {
        return DataContextFactory.createCsvDataContext(file, ',', '\"');
    }

    public static UpdateableDataContext createCsvDataContext(File file, char separatorChar, char quoteChar) {
        return DataContextFactory.createCsvDataContext(file, separatorChar, quoteChar, "UTF-8");
    }

    public static UpdateableDataContext createCsvDataContext(File file, char separatorChar, char quoteChar, String encoding) {
        CsvConfiguration configuration = new CsvConfiguration(1, encoding, separatorChar, quoteChar, '\\');
        CsvDataContext dc = new CsvDataContext(file, configuration);
        return dc;
    }

    public static UpdateableDataContext createCsvDataContext(File file, CsvConfiguration configuration) {
        CsvDataContext dc = new CsvDataContext(file, configuration);
        return dc;
    }

    public static DataContext createCsvDataContext(InputStream inputStream, char separatorChar, char quoteChar) {
        return DataContextFactory.createCsvDataContext(inputStream, separatorChar, quoteChar, "UTF-8");
    }

    public static DataContext createCsvDataContext(InputStream inputStream, char separatorChar, char quoteChar, String encoding) {
        CsvConfiguration configuration = new CsvConfiguration(1, encoding, separatorChar, quoteChar, '\\');
        CsvDataContext dc = new CsvDataContext(inputStream, configuration);
        return dc;
    }

    public static DataContext createCsvDataContext(InputStream inputStream, CsvConfiguration configuration) {
        CsvDataContext dc = new CsvDataContext(inputStream, configuration);
        return dc;
    }

    public static DataContext createFixedWidthDataContext(File file, String fileEncoding, int fixedValueWidth) {
        return DataContextFactory.createFixedWidthDataContext(file, new FixedWidthConfiguration(1, fileEncoding, fixedValueWidth));
    }

    public static DataContext createFixedWidthDataContext(File file, FixedWidthConfiguration configuration) {
        FixedWidthDataContext dc = new FixedWidthDataContext(file, configuration);
        return dc;
    }

    public static DataContext createFixedWidthDataContext(File file, String fileEncoding, int fixedValueWidth, int headerLineNumber) {
        return DataContextFactory.createFixedWidthDataContext(file, new FixedWidthConfiguration(1, fileEncoding, fixedValueWidth));
    }

    public static UpdateableDataContext createExcelDataContext(File file, ExcelConfiguration configuration) {
        return new ExcelDataContext(file, configuration);
    }

    public static UpdateableDataContext createExcelDataContext(File file) {
        return DataContextFactory.createExcelDataContext(file, new ExcelConfiguration());
    }

    public static DataContext createXmlDataContext(InputSource inputSource, String schemaName, boolean autoFlattenTables) {
        XmlDomDataContext dc = new XmlDomDataContext(inputSource, schemaName, autoFlattenTables);
        return dc;
    }

    public static DataContext createXmlDataContext(File file, boolean autoFlattenTables) {
        XmlDomDataContext dc = new XmlDomDataContext(file, autoFlattenTables);
        return dc;
    }

    public static DataContext createXmlDataContext(URL url, boolean autoFlattenTables) {
        XmlDomDataContext dc = new XmlDomDataContext(url, autoFlattenTables);
        return dc;
    }

    public static DataContext createOpenOfficeDataContext(File file) {
        return new OpenOfficeDataContext(file);
    }

    public static UpdateableDataContext createJdbcDataContext(Connection connection) {
        return new JdbcDataContext(connection);
    }

    public static UpdateableDataContext createJdbcDataContext(DataSource ds) {
        return new JdbcDataContext(ds);
    }

    public static UpdateableDataContext createJdbcDataContext(Connection connection, String catalogName) {
        return new JdbcDataContext(connection, TableType.DEFAULT_TABLE_TYPES, catalogName);
    }

    public static UpdateableDataContext createJdbcDataContext(Connection connection, TableType ... tableTypes) {
        return new JdbcDataContext(connection, tableTypes, null);
    }

    public static UpdateableDataContext createJdbcDataContext(Connection connection, String catalogName, TableType[] tableTypes) {
        return new JdbcDataContext(connection, tableTypes, catalogName);
    }

    public static UpdateableDataContext createJdbcDataContext(DataSource ds, TableType ... tableTypes) {
        return new JdbcDataContext(ds, tableTypes, null);
    }

    public static UpdateableDataContext createJdbcDataContext(DataSource ds, String catalogName, TableType[] tableTypes) {
        return new JdbcDataContext(ds, tableTypes, catalogName);
    }

    public static UpdateableDataContext createJdbcDataContext(DataSource ds, String catalogName) {
        return new JdbcDataContext(ds, TableType.DEFAULT_TABLE_TYPES, catalogName);
    }

    public static UpdateableDataContext createMongoDbDataContext(String hostname, Integer port, String databaseName, String username, char[] password) {
        try {
            DB mongoDb = port == null ? new Mongo(hostname).getDB(databaseName) : new Mongo(hostname, port.intValue()).getDB(databaseName);
            if (username != null) {
                mongoDb.authenticate(username, password);
            }
            return new MongoDbDataContext(mongoDb);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    public static UpdateableDataContext createCouchDbDataContext(String hostname, Integer port, String username, String password) {
        StdHttpClient.Builder httpClientBuilder = new StdHttpClient.Builder();
        httpClientBuilder.host(hostname);
        if (port != null) {
            httpClientBuilder.port(port.intValue());
        }
        if (username != null) {
            httpClientBuilder.username(username);
        }
        if (password != null) {
            httpClientBuilder.password(password);
        }
        httpClientBuilder.connectionTimeout(20000);
        httpClientBuilder.socketTimeout(20000);
        return new CouchDbDataContext(httpClientBuilder);
    }
}

