/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.jdbc;

import java.util.List;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FetchSizeCalculator {
    private static final int DEFAULT_COLUMN_SIZE = 30;
    private static final int KB = 1024;
    private static final Logger logger = LoggerFactory.getLogger(FetchSizeCalculator.class);
    private static final int MIN_FETCH_SIZE = 1;
    private static final int MAX_FETCH_SIZE = 25000;
    private final int _bytesInMemory;

    public FetchSizeCalculator(int bytesInMemory) {
        this._bytesInMemory = bytesInMemory;
    }

    public int getFetchSize(Query query) {
        if (this.isSingleRowQuery(query)) {
            return 1;
        }
        int bytesPerRow = this.getRowSize(query);
        int result = this.getFetchSize(bytesPerRow);
        Integer maxRows = query.getMaxRows();
        if (maxRows != null && result > maxRows) {
            logger.debug("Result ({}) was below max rows ({}), adjusting.", (Object)result, (Object)maxRows);
            result = maxRows;
        }
        return result;
    }

    private boolean isSingleRowQuery(Query query) {
        if (!query.getGroupByClause().isEmpty()) {
            return false;
        }
        List items = query.getSelectClause().getItems();
        for (SelectItem item : items) {
            if (item.getFunction() != null) continue;
            return false;
        }
        return true;
    }

    public int getFetchSize(Column ... columns) {
        int bytesPerRow = this.getRowSize(columns);
        return this.getFetchSize(bytesPerRow);
    }

    protected int getRowSize(Query query) {
        List items = query.getSelectClause().getItems();
        int bytesPerRow = 0;
        for (SelectItem selectItem : items) {
            bytesPerRow += this.getValueSize(selectItem);
        }
        return bytesPerRow;
    }

    protected int getRowSize(Column ... columns) {
        int bytesPerRow = 0;
        for (Column column : columns) {
            bytesPerRow += this.getValueSize(column);
        }
        return bytesPerRow;
    }

    protected int getFetchSize(int bytesPerRow) {
        if (bytesPerRow == 0) {
            return 25000;
        }
        int result = this._bytesInMemory / bytesPerRow;
        if (result < 1) {
            logger.debug("Result ({}) was below minimum fetch size ({}), adjusting.", (Object)result, (Object)1);
            result = 1;
        } else if (result > 25000) {
            logger.debug("Result ({}) was above maximum fetch size ({}), adjusting.", (Object)result, (Object)25000);
            result = 25000;
        }
        return result;
    }

    protected int getValueSize(SelectItem selectItem) {
        Column column = selectItem.getColumn();
        if (column == null) {
            return 30;
        }
        return this.getValueSize(column);
    }

    protected int getValueSize(Column column) {
        ColumnType type = column.getType();
        if (type == null) {
            return 30;
        }
        Integer columnSize = column.getColumnSize();
        if (columnSize == null) {
            return this.getSize(type);
        }
        if (columnSize > 10000 && !type.isLargeObject()) {
            return this.getSize(type);
        }
        return this.getSize(type, columnSize);
    }

    private int getSize(ColumnType type, int columnSize) {
        int baseSize = type.isBinary() ? 1 : (type.isBoolean() ? 1 : (type.isLiteral() ? 2 : (type.isNumber() ? 16 : 30)));
        int result = baseSize * columnSize;
        if (type.isLargeObject()) {
            result = Math.max(result, 4096);
        }
        return result;
    }

    private int getSize(ColumnType type) {
        if (type.isBinary()) {
            return 4096;
        }
        if (type.isBoolean()) {
            return 2;
        }
        if (type.isLargeObject()) {
            return 4096;
        }
        if (type.isLiteral()) {
            return 1024;
        }
        if (type.isNumber()) {
            return 16;
        }
        return 30;
    }
}

