/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.eobjects.metamodel.jdbc.JdbcCompiledQueryLease;
import org.eobjects.metamodel.jdbc.JdbcDataContext;
import org.eobjects.metamodel.jdbc.JdbcUtils;

final class JdbcCompiledQueryLeaseFactory
implements PoolableObjectFactory<JdbcCompiledQueryLease> {
    private final JdbcDataContext _dataContext;
    private final Connection _connection;
    private final String _sql;

    public JdbcCompiledQueryLeaseFactory(JdbcDataContext dataContext, Connection connection, String sql) {
        this._dataContext = dataContext;
        this._connection = connection;
        this._sql = sql;
    }

    public JdbcCompiledQueryLease makeObject() throws Exception {
        try {
            PreparedStatement statement = this._connection.prepareStatement(this._sql);
            JdbcCompiledQueryLease lease = new JdbcCompiledQueryLease(this._connection, statement);
            return lease;
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "preparing statement");
        }
    }

    public void destroyObject(JdbcCompiledQueryLease lease) throws Exception {
        this._dataContext.close(null, null, lease.getStatement());
    }

    public boolean validateObject(JdbcCompiledQueryLease lease) {
        return true;
    }

    public void activateObject(JdbcCompiledQueryLease obj) throws Exception {
    }

    public void passivateObject(JdbcCompiledQueryLease obj) throws Exception {
    }
}

