/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.create.AbstractTableCreationBuilder;
import org.eobjects.metamodel.jdbc.JdbcSchema;
import org.eobjects.metamodel.jdbc.JdbcUpdateCallback;
import org.eobjects.metamodel.jdbc.JdbcUtils;
import org.eobjects.metamodel.jdbc.dialects.IQueryRewriter;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdbcCreateTableBuilder
extends AbstractTableCreationBuilder<JdbcUpdateCallback> {
    private static final Logger logger = LoggerFactory.getLogger(JdbcCreateTableBuilder.class);

    public JdbcCreateTableBuilder(JdbcUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
        if (!(schema instanceof JdbcSchema)) {
            throw new IllegalArgumentException("Not a valid JDBC schema: " + schema);
        }
    }

    public Table execute() {
        String sql = this.createSqlStatement();
        logger.info("Create table statement created: {}", (Object)sql);
        Connection connection = ((JdbcUpdateCallback)this.getUpdateCallback()).getConnection();
        Statement st = null;
        try {
            st = connection.createStatement();
            int rowsAffected = st.executeUpdate(sql);
            logger.debug("Create table statement executed, {} rows affected", (Object)rowsAffected);
        }
        catch (SQLException e) {
            try {
                throw JdbcUtils.wrapException(e, "execute create table statement: " + sql);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{st});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{st});
        JdbcSchema schema = (JdbcSchema)this.getSchema();
        schema.refreshTables();
        return schema.getTableByName(this.getTable().getName());
    }

    protected String createSqlStatement() {
        return this.createSqlStatement((Table)this.getTable());
    }

    private String createSqlStatement(Table table) {
        IQueryRewriter queryRewriter = ((JdbcUpdateCallback)this.getUpdateCallback()).getDataContext().getQueryRewriter();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        Schema schema = this.getSchema();
        if (schema != null && schema.getName() != null) {
            sb.append(schema.getQualifiedLabel());
            sb.append(".");
        }
        sb.append(((JdbcUpdateCallback)this.getUpdateCallback()).quoteIfNescesary(table.getName()));
        sb.append(" (");
        Column[] columns = table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(((JdbcUpdateCallback)this.getUpdateCallback()).quoteIfNescesary(column.getName()));
            sb.append(' ');
            String nativeType = column.getNativeType();
            if (nativeType == null) {
                ColumnType columnType = column.getType();
                if (columnType == null) {
                    columnType = ColumnType.VARCHAR;
                }
                String columnTypeString = queryRewriter.rewriteColumnType(columnType);
                sb.append(columnTypeString);
            } else {
                sb.append(nativeType);
            }
            Integer columnSize = column.getColumnSize();
            if (columnSize != null) {
                sb.append('(');
                sb.append(columnSize);
                sb.append(')');
            }
            if (column.isNullable() != null && !column.isNullable().booleanValue()) {
                sb.append(" NOT NULL");
            }
            if (!column.isPrimaryKey()) continue;
            sb.append(" PRIMARY KEY");
        }
        sb.append(")");
        return sb.toString();
    }
}

