/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.data.AbstractDataSet;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.jdbc.JdbcCompiledQuery;
import org.eobjects.metamodel.jdbc.JdbcCompiledQueryLease;
import org.eobjects.metamodel.jdbc.JdbcDataContext;
import org.eobjects.metamodel.jdbc.JdbcUtils;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdbcDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(JdbcDataSet.class);
    private final JdbcCompiledQuery _compiledQuery;
    private final JdbcCompiledQueryLease _lease;
    private final Statement _statement;
    private final ResultSet _resultSet;
    private final JdbcDataContext _jdbcDataContext;
    private final Connection _connection;
    private Row _row;
    private boolean _closed;

    public JdbcDataSet(Query query, JdbcDataContext jdbcDataContext, Connection connection, Statement statement, ResultSet resultSet) {
        super(query.getSelectClause().getItems());
        if (query == null || statement == null || resultSet == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this._jdbcDataContext = jdbcDataContext;
        this._connection = connection;
        this._statement = statement;
        this._resultSet = resultSet;
        this._closed = false;
        this._compiledQuery = null;
        this._lease = null;
    }

    public JdbcDataSet(JdbcCompiledQuery compiledQuery, JdbcCompiledQueryLease lease, ResultSet resultSet) {
        super(compiledQuery.getSelectItems());
        if (compiledQuery == null || lease == null || resultSet == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this._compiledQuery = compiledQuery;
        this._lease = lease;
        this._jdbcDataContext = null;
        this._connection = null;
        this._statement = null;
        this._resultSet = resultSet;
        this._closed = false;
    }

    public Row getRow() {
        return this._row;
    }

    public boolean next() throws MetaModelException {
        try {
            boolean result = this._resultSet.next();
            if (result) {
                Object[] values = new Object[this.getHeader().size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.getValue(this._resultSet, i);
                    try {
                        if (!this._resultSet.wasNull()) continue;
                        values[i] = null;
                        continue;
                    }
                    catch (Exception e) {
                        logger.debug("Could not invoke wasNull() method on resultset, error message: {}", (Object)e.getMessage());
                    }
                }
                this._row = new DefaultRow(this.getHeader(), values);
            } else {
                this._row = null;
            }
            return result;
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "get next record in resultset");
        }
    }

    private Object getValue(ResultSet resultSet, int i) throws SQLException {
        Column column;
        SelectItem selectItem = this.getHeader().getSelectItem(i);
        int columnIndex = i + 1;
        if (selectItem.getFunction() == null && (column = selectItem.getColumn()) != null) {
            ColumnType type = column.getType();
            try {
                switch (type) {
                    case TIME: {
                        return this._resultSet.getTime(columnIndex);
                    }
                    case DATE: {
                        return this._resultSet.getDate(columnIndex);
                    }
                    case TIMESTAMP: {
                        return this._resultSet.getTimestamp(columnIndex);
                    }
                    case BLOB: {
                        Blob blob = this._resultSet.getBlob(columnIndex);
                        if (this.isLobConversionEnabled()) {
                            InputStream inputStream = blob.getBinaryStream();
                            byte[] bytes = FileHelper.readAsBytes((InputStream)inputStream);
                            return bytes;
                        }
                        return blob;
                    }
                    case BINARY: 
                    case VARBINARY: 
                    case LONGVARBINARY: {
                        return this._resultSet.getBytes(columnIndex);
                    }
                    case CLOB: 
                    case NCLOB: {
                        Clob clob = this._resultSet.getClob(columnIndex);
                        if (this.isLobConversionEnabled()) {
                            Reader reader = clob.getCharacterStream();
                            String result = FileHelper.readAsString((Reader)reader);
                            return result;
                        }
                        return clob;
                    }
                    case BIT: 
                    case BOOLEAN: {
                        return this._resultSet.getBoolean(columnIndex);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Failed to retrieve " + type + " value using type-specific getter, retrying with generic getObject(...) method", (Throwable)e);
            }
        }
        return this._resultSet.getObject(columnIndex);
    }

    private boolean isLobConversionEnabled() {
        String systemProperty = System.getProperty("metamodel.jdbc.convert.lobs");
        return "true".equals(systemProperty);
    }

    public void close() {
        if (this._closed) {
            return;
        }
        if (this._jdbcDataContext != null) {
            this._jdbcDataContext.close(this._connection, this._resultSet, this._statement);
        }
        if (this._compiledQuery != null) {
            this._compiledQuery.returnLease(this._lease);
        }
        this._closed = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this._closed) {
            logger.warn("finalize() invoked, but DataSet is not closed. Invoking close() on {}", (Object)this);
            this.close();
        }
    }
}

