/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eobjects.metamodel.drop.AbstractTableDropBuilder;
import org.eobjects.metamodel.drop.TableDropBuilder;
import org.eobjects.metamodel.jdbc.JdbcSchema;
import org.eobjects.metamodel.jdbc.JdbcUpdateCallback;
import org.eobjects.metamodel.jdbc.JdbcUtils;
import org.eobjects.metamodel.jdbc.dialects.IQueryRewriter;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;

final class JdbcDropTableBuilder
extends AbstractTableDropBuilder
implements TableDropBuilder {
    private final JdbcUpdateCallback _updateCallback;
    private final IQueryRewriter _queryRewriter;

    public JdbcDropTableBuilder(JdbcUpdateCallback updateCallback, Table table, IQueryRewriter queryRewriter) {
        super(table);
        this._updateCallback = updateCallback;
        this._queryRewriter = queryRewriter;
    }

    public void execute() {
        String sql = this.createSqlStatement();
        PreparedStatement statement = this._updateCallback.getPreparedStatement(sql, false);
        try {
            this._updateCallback.executePreparedStatement(statement, false);
            Schema schema = this.getTable().getSchema();
            if (schema instanceof JdbcSchema) {
                ((JdbcSchema)schema).refreshTables();
            }
        }
        catch (SQLException e) {
            throw JdbcUtils.wrapException(e, "execute drop table statement: " + sql);
        }
    }

    protected String createSqlStatement() {
        FromItem fromItem = new FromItem(this.getTable());
        String tableLabel = this._queryRewriter.rewriteFromItem(fromItem);
        return "DROP TABLE " + tableLabel;
    }
}

