/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.insert.AbstractRowInsertionBuilder;
import org.eobjects.metamodel.jdbc.JdbcTable;
import org.eobjects.metamodel.jdbc.JdbcUpdateCallback;
import org.eobjects.metamodel.jdbc.JdbcUtils;
import org.eobjects.metamodel.jdbc.dialects.IQueryRewriter;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdbcInsertBuilder
extends AbstractRowInsertionBuilder<JdbcUpdateCallback> {
    private static final Logger logger = LoggerFactory.getLogger(JdbcInsertBuilder.class);
    private final boolean _inlineValues;
    private final IQueryRewriter _queryRewriter;

    public JdbcInsertBuilder(JdbcUpdateCallback updateCallback, Table table, IQueryRewriter queryRewriter) {
        this(updateCallback, table, false, queryRewriter);
    }

    public JdbcInsertBuilder(JdbcUpdateCallback updateCallback, Table table, boolean isInlineValues, IQueryRewriter queryRewriter) {
        super((UpdateCallback)updateCallback, table);
        if (!(table instanceof JdbcTable)) {
            throw new IllegalArgumentException("Not a valid JDBC table: " + table);
        }
        this._inlineValues = isInlineValues;
        this._queryRewriter = queryRewriter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        String sql = this.createSqlStatement();
        if (logger.isDebugEnabled()) {
            logger.debug("Inserting: {}", (Object)Arrays.toString(this.getValues()));
            logger.debug("Insert statement created: {}", (Object)sql);
        }
        JdbcUpdateCallback updateCallback = (JdbcUpdateCallback)this.getUpdateCallback();
        boolean reuseStatement = !this._inlineValues;
        PreparedStatement st = updateCallback.getPreparedStatement(sql, reuseStatement);
        try {
            if (reuseStatement) {
                Column[] columns = this.getColumns();
                Object[] values = this.getValues();
                boolean[] explicitNulls = this.getExplicitNulls();
                int valueCounter = 1;
                for (int i = 0; i < columns.length; ++i) {
                    boolean explicitNull = explicitNulls[i];
                    if (values[i] == null && !explicitNull) continue;
                    JdbcUtils.setStatementValue(st, valueCounter, columns[i], values[i]);
                    ++valueCounter;
                }
            }
            updateCallback.executePreparedStatement(st, reuseStatement);
            if (!this._inlineValues) return;
        }
        catch (SQLException e) {
            try {
                throw JdbcUtils.wrapException(e, "execute insert statement: " + sql);
            }
            catch (Throwable throwable) {
                if (!this._inlineValues) throw throwable;
                FileHelper.safeClose((Object[])new Object[]{st});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{st});
        return;
    }

    protected String createSqlStatement() {
        return this.createSqlStatement(this._inlineValues);
    }

    private String createSqlStatement(boolean inlineValues) {
        int i;
        Object[] values = this.getValues();
        Table table = this.getTable();
        StringBuilder sb = new StringBuilder();
        String tableLabel = this._queryRewriter.rewriteFromItem(new FromItem(table));
        sb.append("INSERT INTO ");
        sb.append(tableLabel);
        sb.append(" (");
        Column[] columns = this.getColumns();
        boolean[] explicitNulls = this.getExplicitNulls();
        boolean firstValue = true;
        for (i = 0; i < columns.length; ++i) {
            if (values[i] == null && !explicitNulls[i]) continue;
            if (firstValue) {
                firstValue = false;
            } else {
                sb.append(',');
            }
            String columnName = columns[i].getName();
            columnName = ((JdbcUpdateCallback)this.getUpdateCallback()).quoteIfNescesary(columnName);
            sb.append(columnName);
        }
        sb.append(") VALUES (");
        firstValue = true;
        for (i = 0; i < columns.length; ++i) {
            if (values[i] == null && !explicitNulls[i]) continue;
            if (firstValue) {
                firstValue = false;
            } else {
                sb.append(',');
            }
            if (inlineValues) {
                sb.append(JdbcUtils.getValueAsSql(columns[i], values[i], this._queryRewriter));
                continue;
            }
            sb.append('?');
        }
        sb.append(")");
        String sql = sb.toString();
        return sql;
    }

    public String toSql() {
        return this.createSqlStatement(true);
    }
}

