/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.jdbc.dialects;

import org.eobjects.metamodel.jdbc.JdbcDataContext;
import org.eobjects.metamodel.jdbc.dialects.DefaultQueryRewriter;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectClause;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;

public class HsqldbQueryRewriter
extends DefaultQueryRewriter {
    public HsqldbQueryRewriter(JdbcDataContext dataContext) {
        super(dataContext);
    }

    @Override
    public String rewriteColumnType(ColumnType columnType) {
        if (columnType == ColumnType.BLOB) {
            return "LONGVARBINARY";
        }
        return super.rewriteColumnType(columnType);
    }

    @Override
    public boolean isFirstRowSupported() {
        return true;
    }

    @Override
    public boolean isMaxRowsSupported() {
        return true;
    }

    @Override
    protected String rewriteSelectClause(Query query, SelectClause selectClause) {
        String result = super.rewriteSelectClause(query, selectClause);
        Integer firstRow = query.getFirstRow();
        Integer maxRows = query.getMaxRows();
        if (maxRows != null || firstRow != null) {
            if (maxRows == null) {
                maxRows = Integer.MAX_VALUE;
            }
            if (firstRow == null || firstRow <= 0) {
                result = "SELECT TOP " + maxRows + " " + result.substring(7);
            } else {
                int offset = firstRow - 1;
                result = "SELECT LIMIT " + offset + " " + maxRows + " " + result.substring(7);
            }
        }
        return result;
    }

    @Override
    public String rewriteFilterItem(FilterItem item) {
        SelectItem selectItem;
        Column column;
        if (!item.isCompoundFilter() && (column = (selectItem = item.getSelectItem()).getColumn()) != null && column.getType() == ColumnType.TIMESTAMP) {
            String result = super.rewriteFilterItem(item);
            int indexOfTimestamp = result.lastIndexOf("TIMESTAMP");
            if (indexOfTimestamp != -1) {
                result = result.substring(0, indexOfTimestamp) + result.substring(indexOfTimestamp + "TIMESTAMP".length());
            }
            return result;
        }
        return super.rewriteFilterItem(item);
    }
}

