/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bson.types.ObjectId;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.QueryPostprocessDataContext;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.UpdateScript;
import org.eobjects.metamodel.UpdateableDataContext;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.mongodb.DefaultWriteConcernAdvisor;
import org.eobjects.metamodel.mongodb.MongoDbDataSet;
import org.eobjects.metamodel.mongodb.MongoDbTableDef;
import org.eobjects.metamodel.mongodb.MongoDbUpdateCallback;
import org.eobjects.metamodel.mongodb.SimpleWriteConcernAdvisor;
import org.eobjects.metamodel.mongodb.WriteConcernAdvisor;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.SimpleTableDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext {
    private static final Logger logger = LoggerFactory.getLogger(MongoDbDataSet.class);
    private final DB _mongoDb;
    private final SimpleTableDef[] _tableDefs;
    private WriteConcernAdvisor _writeConcernAdvisor;
    private Schema _schema;

    @Deprecated
    public MongoDbDataContext(DB mongoDb, MongoDbTableDef ... tableDefs) {
        this(mongoDb, (SimpleTableDef[])tableDefs);
    }

    public MongoDbDataContext(DB mongoDb, SimpleTableDef ... tableDefs) {
        this._mongoDb = mongoDb;
        this._tableDefs = tableDefs;
        this._schema = null;
    }

    public MongoDbDataContext(DB mongoDb) {
        this(mongoDb, MongoDbDataContext.detectSchema(mongoDb));
    }

    public static SimpleTableDef[] detectSchema(DB db) {
        Set collectionNames = db.getCollectionNames();
        SimpleTableDef[] result = new SimpleTableDef[collectionNames.size()];
        int i = 0;
        for (String collectionName : collectionNames) {
            SimpleTableDef table;
            result[i] = table = MongoDbDataContext.detectTable(db, collectionName);
            ++i;
        }
        return result;
    }

    public static SimpleTableDef detectTable(DB db, String collectionName) {
        DBCollection collection = db.getCollection(collectionName);
        DBCursor cursor = collection.find().limit(1000);
        TreeMap columnsAndTypes = new TreeMap();
        while (cursor.hasNext()) {
            DBObject object = cursor.next();
            Set keysInObject = object.keySet();
            for (String key : keysInObject) {
                Object value;
                HashSet types = (HashSet)columnsAndTypes.get(key);
                if (types == null) {
                    types = new HashSet();
                    columnsAndTypes.put(key, types);
                }
                if ((value = object.get(key)) == null) continue;
                types.add(value.getClass());
            }
        }
        cursor.close();
        String[] columnNames = new String[columnsAndTypes.size()];
        ColumnType[] columnTypes = new ColumnType[columnsAndTypes.size()];
        int i = 0;
        for (Map.Entry columnAndTypes : columnsAndTypes.entrySet()) {
            String columnName = (String)columnAndTypes.getKey();
            Set columnTypeSet = (Set)columnAndTypes.getValue();
            Class columnType = columnTypeSet.size() == 1 ? (Class)columnTypeSet.iterator().next() : Object.class;
            columnNames[i] = columnName;
            columnTypes[i] = columnType == ObjectId.class ? ColumnType.ROWID : ColumnType.convertColumnType((Class)columnType);
            ++i;
        }
        return new SimpleTableDef(collectionName, columnNames, columnTypes);
    }

    protected Schema getMainSchema() throws MetaModelException {
        if (this._schema == null) {
            MutableSchema schema = new MutableSchema(this.getMainSchemaName());
            for (SimpleTableDef tableDef : this._tableDefs) {
                MutableTable table = tableDef.toTable().setSchema((Schema)schema);
                schema.addTable(table);
            }
            this._schema = schema;
        }
        return this._schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._mongoDb.getName();
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        DBCollection collection = this._mongoDb.getCollection(table.getName());
        BasicDBObject query = this.createMongoDbQuery(table, whereItems);
        logger.info("Executing MongoDB 'count' query: {}", (Object)query);
        long count = collection.count((DBObject)query);
        return count;
    }

    public DataSet executeQuery(Query query) {
        List fromItems = query.getFromClause().getItems();
        if (fromItems.size() == 1 && ((FromItem)fromItems.get(0)).getTable() != null && ((FromItem)fromItems.get(0)).getTable().getSchema() == this._schema) {
            Table table = ((FromItem)fromItems.get(0)).getTable();
            if (query.getGroupByClause().isEmpty() && query.getHavingClause().isEmpty() && query.getOrderByClause().isEmpty()) {
                List whereItems = query.getWhereClause().getItems();
                boolean allSelectItemsAreColumns = true;
                List selectItems = query.getSelectClause().getItems();
                for (SelectItem selectItem : selectItems) {
                    if (selectItem.getFunction() == null && selectItem.getColumn() != null) continue;
                    allSelectItemsAreColumns = false;
                    break;
                }
                if (allSelectItemsAreColumns) {
                    logger.debug("Query can be expressed in full MongoDB, no post processing needed.");
                    Column[] columns = new Column[selectItems.size()];
                    for (int i = 0; i < columns.length; ++i) {
                        columns[i] = ((SelectItem)selectItems.get(i)).getColumn();
                    }
                    int firstRow = query.getFirstRow() == null ? 1 : query.getFirstRow();
                    int maxRows = query.getMaxRows() == null ? -1 : query.getMaxRows();
                    DataSet dataSet = this.materializeMainSchemaTableInternal(table, columns, whereItems, firstRow, maxRows, false);
                    return dataSet;
                }
            }
        }
        logger.debug("Query will be simplified for MongoDB and post processed.");
        return super.executeQuery(query);
    }

    private DataSet materializeMainSchemaTableInternal(Table table, Column[] columns, List<FilterItem> whereItems, int firstRow, int maxRows, boolean queryPostProcessed) {
        DBCollection collection = this._mongoDb.getCollection(table.getName());
        BasicDBObject query = this.createMongoDbQuery(table, whereItems);
        logger.info("Executing MongoDB 'find' query: {}", (Object)query);
        DBCursor cursor = collection.find((DBObject)query);
        if (maxRows > 0) {
            cursor = cursor.limit(maxRows);
        }
        if (firstRow > 1) {
            int skip = firstRow - 1;
            cursor = cursor.skip(skip);
        }
        return new MongoDbDataSet(cursor, columns, queryPostProcessed);
    }

    protected BasicDBObject createMongoDbQuery(Table table, List<FilterItem> whereItems) {
        assert (this._schema == table.getSchema());
        BasicDBObject query = new BasicDBObject();
        if (whereItems != null && !whereItems.isEmpty()) {
            for (FilterItem item : whereItems) {
                this.convertToCursorObject(query, item);
            }
        }
        return query;
    }

    private void convertToCursorObject(BasicDBObject query, FilterItem item) {
        if (item.isCompoundFilter()) {
            FilterItem[] childItems;
            BasicDBList orList = new BasicDBList();
            for (FilterItem childItem : childItems = item.getChildItems()) {
                BasicDBObject childObject = new BasicDBObject();
                this.convertToCursorObject(childObject, childItem);
                orList.add((Object)childObject);
            }
            query.put("$or", (Object)orList);
        } else {
            Column column = item.getSelectItem().getColumn();
            String columnName = column.getName();
            Object operand = item.getOperand();
            String operatorName = this.getOperatorName(item);
            BasicDBObject existingFilterObject = (BasicDBObject)query.get(columnName);
            if (existingFilterObject == null) {
                if (operatorName == null) {
                    query.put(columnName, operand);
                } else {
                    query.put(columnName, (Object)new BasicDBObject(operatorName, operand));
                }
            } else {
                if (operatorName == null) {
                    throw new IllegalStateException("Cannot retrieve records for a column with two EQUALS_TO operators");
                }
                existingFilterObject.append(operatorName, operand);
            }
        }
    }

    private String getOperatorName(FilterItem item) {
        String operatorName;
        switch (item.getOperator()) {
            case EQUALS_TO: {
                operatorName = null;
                break;
            }
            case LESS_THAN: 
            case LOWER_THAN: {
                operatorName = "$lt";
                break;
            }
            case GREATER_THAN: 
            case HIGHER_THAN: {
                operatorName = "$gt";
                break;
            }
            case DIFFERENT_FROM: {
                operatorName = "$ne";
                break;
            }
            case IN: {
                operatorName = "$in";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operator type: " + item.getOperator());
            }
        }
        return operatorName;
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        return this.materializeMainSchemaTableInternal(table, columns, null, 1, maxRows, true);
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int firstRow, int maxRows) {
        return this.materializeMainSchemaTableInternal(table, columns, null, firstRow, maxRows, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(UpdateScript update, WriteConcernAdvisor writeConcernAdvisor) {
        MongoDbUpdateCallback callback = new MongoDbUpdateCallback(this, writeConcernAdvisor);
        try {
            update.run((UpdateCallback)callback);
        }
        finally {
            callback.close();
        }
    }

    public void executeUpdate(UpdateScript update, WriteConcern writeConcern) {
        this.executeUpdate(update, new SimpleWriteConcernAdvisor(writeConcern));
    }

    public void executeUpdate(UpdateScript update) {
        this.executeUpdate(update, this.getWriteConcernAdvisor());
    }

    public WriteConcernAdvisor getWriteConcernAdvisor() {
        if (this._writeConcernAdvisor == null) {
            return new DefaultWriteConcernAdvisor();
        }
        return this._writeConcernAdvisor;
    }

    public void setWriteConcernAdvisor(WriteConcernAdvisor writeConcernAdvisor) {
        this._writeConcernAdvisor = writeConcernAdvisor;
    }

    public DB getMongoDb() {
        return this._mongoDb;
    }

    protected void addTable(MutableTable table) {
        if (!(this._schema instanceof MutableSchema)) {
            throw new UnsupportedOperationException("Schema is not mutable");
        }
        MutableSchema mutableSchema = (MutableSchema)this._schema;
        mutableSchema.addTable(table);
    }
}

