/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.mongodb;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.List;
import org.eobjects.metamodel.data.AbstractDataSet;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoDbDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(MongoDbDataSet.class);
    private final DBCursor _cursor;
    private final boolean _queryPostProcessed;
    private boolean _closed;
    private volatile DBObject _dbObject;

    public MongoDbDataSet(DBCursor cursor, Column[] columns, boolean queryPostProcessed) {
        super(columns);
        this._cursor = cursor;
        this._queryPostProcessed = queryPostProcessed;
        this._closed = false;
    }

    public boolean isQueryPostProcessed() {
        return this._queryPostProcessed;
    }

    public void close() {
        super.close();
        this._cursor.close();
        this._closed = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this._closed) {
            logger.warn("finalize() invoked, but DataSet is not closed. Invoking close() on {}", (Object)this);
            this.close();
        }
    }

    public boolean next() {
        if (this._cursor.hasNext()) {
            this._dbObject = this._cursor.next();
            return true;
        }
        this._dbObject = null;
        return false;
    }

    public Row getRow() {
        if (this._dbObject == null) {
            return null;
        }
        int size = this.getHeader().size();
        Object[] values = new Object[size];
        for (int i = 0; i < values.length; ++i) {
            SelectItem selectItem = this.getHeader().getSelectItem(i);
            String key = selectItem.getColumn().getName();
            Object value = this._dbObject.get(key);
            values[i] = this.toValue(selectItem.getColumn(), value);
        }
        return new DefaultRow(this.getHeader(), values);
    }

    private Object toValue(Column column, Object value) {
        if (value instanceof List) {
            return value;
        }
        if (value instanceof DBObject) {
            DBObject basicDBObject = (DBObject)value;
            return basicDBObject.toMap();
        }
        return value;
    }
}

