/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.mongodb;

import com.mongodb.DBCollection;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import org.eobjects.metamodel.AbstractUpdateCallback;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.create.TableCreationBuilder;
import org.eobjects.metamodel.delete.RowDeletionBuilder;
import org.eobjects.metamodel.drop.TableDropBuilder;
import org.eobjects.metamodel.insert.RowInsertionBuilder;
import org.eobjects.metamodel.mongodb.MongoDbDataContext;
import org.eobjects.metamodel.mongodb.MongoDbDeleteBuilder;
import org.eobjects.metamodel.mongodb.MongoDbDropTableBuilder;
import org.eobjects.metamodel.mongodb.MongoDbInsertionBuilder;
import org.eobjects.metamodel.mongodb.MongoDbTableCreationBuilder;
import org.eobjects.metamodel.mongodb.WriteConcernAdvisor;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;

final class MongoDbUpdateCallback
extends AbstractUpdateCallback
implements UpdateCallback,
Closeable {
    private final MongoDbDataContext _dataContext;
    private final Map<String, DBCollection> _collections;
    private final WriteConcernAdvisor _writeConcernAdvisor;

    public MongoDbUpdateCallback(MongoDbDataContext dataContext, WriteConcernAdvisor writeConcernAdvisor) {
        super((DataContext)dataContext);
        this._dataContext = dataContext;
        this._writeConcernAdvisor = writeConcernAdvisor;
        this._collections = new HashMap<String, DBCollection>();
    }

    public MongoDbDataContext getDataContext() {
        return this._dataContext;
    }

    public WriteConcernAdvisor getWriteConcernAdvisor() {
        return this._writeConcernAdvisor;
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new MongoDbTableCreationBuilder(this, schema, name);
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException {
        return new MongoDbInsertionBuilder(this, table);
    }

    protected void createCollection(String name) {
        DBCollection collection = this._dataContext.getMongoDb().createCollection(name, null);
        this._collections.put(name, collection);
    }

    protected void removeCollection(String name) {
        DBCollection collection = this.getCollection(name);
        this._collections.remove(name);
        collection.drop();
    }

    protected DBCollection getCollection(String name) {
        DBCollection collection = this._collections.get(name);
        if (collection == null) {
            collection = this._dataContext.getMongoDb().getCollection(name);
            this._collections.put(name, collection);
        }
        return collection;
    }

    @Override
    public void close() {
        this._collections.clear();
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) throws UnsupportedOperationException {
        return new MongoDbDropTableBuilder(this, table);
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new MongoDbDeleteBuilder(this, table);
    }
}

