/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.openoffice;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eobjects.metamodel.AbstractDataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.jdbc.JdbcDataContext;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.TableType;
import org.eobjects.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOfficeDataContext
extends AbstractDataContext {
    private static final Logger logger = LoggerFactory.getLogger(OpenOfficeDataContext.class);
    private JdbcDataContext _dataContextDelegate;
    private Connection _connection;

    public OpenOfficeDataContext(File dbFile) throws MetaModelException {
        try {
            String databaseName = dbFile.getName();
            File tempDir = FileHelper.getTempDir();
            ZipFile zipFile = new ZipFile(dbFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryName.startsWith("database/")) {
                    File destFile = new File(tempDir, databaseName + "." + entryName.substring(9));
                    destFile.createNewFile();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Processing entry: " + entryName);
                        logger.debug("Writing temp file: " + destFile.getAbsolutePath());
                    }
                    byte[] buffer = new byte[1024];
                    InputStream inputStream = zipFile.getInputStream(entry);
                    BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destFile));
                    int len = inputStream.read(buffer);
                    while (len >= 0) {
                        ((OutputStream)outputStream).write(buffer, 0, len);
                        len = inputStream.read(buffer);
                    }
                    inputStream.close();
                    ((OutputStream)outputStream).close();
                    destFile.deleteOnExit();
                    continue;
                }
                logger.debug("Ignoring entry: " + entryName);
            }
            zipFile.close();
            Class.forName("org.hsqldb.jdbcDriver");
            String url = "jdbc:hsqldb:file:" + tempDir.getAbsolutePath() + "/" + databaseName;
            logger.info("Using database URL: " + url);
            this._connection = DriverManager.getConnection(url, "SA", "");
            this._connection.setReadOnly(true);
            this._dataContextDelegate = new JdbcDataContext(this._connection, TableType.DEFAULT_TABLE_TYPES, null);
        }
        catch (Exception e) {
            throw new MetaModelException(e);
        }
    }

    public DataSet executeQuery(Query query) throws MetaModelException {
        return this._dataContextDelegate.executeQuery(query);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._connection.close();
    }

    public Connection getConnection() {
        return this._connection;
    }

    protected String[] getSchemaNamesInternal() {
        return this._dataContextDelegate.getSchemaNames();
    }

    protected String getDefaultSchemaName() {
        return this._dataContextDelegate.getDefaultSchemaName();
    }

    protected Schema getSchemaByNameInternal(String name) {
        return this._dataContextDelegate.getSchemaByName(name);
    }
}

