/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eobjects.metamodel.AbstractUpdateCallback;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.create.AbstractTableCreationBuilder;
import org.eobjects.metamodel.create.TableCreationBuilder;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.delete.AbstractRowDeletionBuilder;
import org.eobjects.metamodel.delete.RowDeletionBuilder;
import org.eobjects.metamodel.drop.AbstractTableDropBuilder;
import org.eobjects.metamodel.drop.TableDropBuilder;
import org.eobjects.metamodel.insert.AbstractRowInsertionBuilder;
import org.eobjects.metamodel.insert.RowInsertionBuilder;
import org.eobjects.metamodel.pojo.MapTableDataProvider;
import org.eobjects.metamodel.pojo.PojoDataContext;
import org.eobjects.metamodel.pojo.PojoDataSet;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.SimpleTableDef;

final class PojoUpdateCallback
extends AbstractUpdateCallback {
    private final PojoDataContext _dataContext;

    public PojoUpdateCallback(PojoDataContext dataContext) {
        super((DataContext)dataContext);
        this._dataContext = dataContext;
    }

    public TableCreationBuilder createTable(Schema schema, String name) throws IllegalArgumentException, IllegalStateException {
        return new AbstractTableCreationBuilder<PojoUpdateCallback>(this, schema, name){

            public Table execute() throws MetaModelException {
                MutableTable table = this.getTable();
                MutableSchema schema = (MutableSchema)this.getSchema();
                table.setSchema((Schema)schema);
                schema.addTable(table);
                PojoUpdateCallback.this._dataContext.addTableDataProvider(new MapTableDataProvider(new SimpleTableDef((Table)table), new ArrayList()));
                return table;
            }
        };
    }

    public boolean isDropTableSupported() {
        return true;
    }

    public TableDropBuilder dropTable(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new AbstractTableDropBuilder(table){

            public void execute() throws MetaModelException {
                MutableTable mutableTable = (MutableTable)this.getTable();
                MutableSchema schema = (MutableSchema)mutableTable.getSchema();
                schema.removeTable((Table)mutableTable);
                mutableTable.setSchema(null);
            }
        };
    }

    public RowInsertionBuilder insertInto(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new AbstractRowInsertionBuilder<PojoUpdateCallback>(this, table){

            public void execute() throws MetaModelException {
                boolean[] explicitNulls = this.getExplicitNulls();
                Column[] columns = this.getColumns();
                Object[] values = this.getValues();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null && !explicitNulls[i]) continue;
                    map.put(columns[i].getName(), values[i]);
                }
                PojoUpdateCallback.this._dataContext.insert(this.getTable().getName(), map);
            }
        };
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public RowDeletionBuilder deleteFrom(Table table) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        return new AbstractRowDeletionBuilder(table){

            public void execute() throws MetaModelException {
                DataSet dataSet = PojoUpdateCallback.this._dataContext.query().from(this.getTable()).select(this.getTable().getColumns()).execute();
                PojoDataSet pojoDataSet = (PojoDataSet)dataSet;
                List whereItems = this.getWhereItems();
                while (pojoDataSet.next()) {
                    boolean delete = true;
                    Row row = pojoDataSet.getRow();
                    for (FilterItem whereItem : whereItems) {
                        if (whereItem.evaluate(row)) continue;
                        delete = false;
                        break;
                    }
                    if (!delete) continue;
                    pojoDataSet.remove();
                }
            }
        };
    }
}

