/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.salesforce;

import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.metamodel.data.AbstractDataSet;
import org.eobjects.metamodel.data.DataSetHeader;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.salesforce.SalesforceDataContext;
import org.eobjects.metamodel.salesforce.SalesforceUtils;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.util.BooleanComparator;
import org.eobjects.metamodel.util.NumberComparator;

final class SalesforceDataSet
extends AbstractDataSet {
    private final PartnerConnection _connection;
    private final AtomicInteger _recordIndex;
    private QueryResult _queryResult;
    private SObject[] _records;
    private SObject _record;

    public SalesforceDataSet(Column[] columns, QueryResult queryResult, PartnerConnection connection) {
        super(columns);
        this._connection = connection;
        this._queryResult = queryResult;
        this._records = this._queryResult.getRecords();
        this._recordIndex = new AtomicInteger();
        this._record = null;
    }

    public boolean next() {
        int index = this._recordIndex.getAndIncrement();
        if (index >= this._records.length) {
            if (this._queryResult.isDone()) {
                this._record = null;
                return false;
            }
            String queryLocator = this._queryResult.getQueryLocator();
            try {
                this._queryResult = this._connection.queryMore(queryLocator);
                this._records = this._queryResult.getRecords();
                this._recordIndex.set(0);
                return this.next();
            }
            catch (ConnectionException e) {
                throw SalesforceUtils.wrapException(e, "Failed to invoke queryMore service");
            }
        }
        this._record = this._records[index];
        return true;
    }

    public Row getRow() {
        if (this._record == null) {
            return null;
        }
        DataSetHeader header = this.getHeader();
        Object[] values = new Object[header.size()];
        for (int i = 0; i < values.length; ++i) {
            Object parsedValue;
            Column column = header.getSelectItem(i).getColumn();
            String fieldName = column.getName();
            Object value = this._record.getField(fieldName);
            values[i] = parsedValue = this.convert(value, column.getType());
        }
        return new DefaultRow(header, values);
    }

    private Object convert(Object value, ColumnType columnType) {
        if (value instanceof String && !columnType.isLiteral()) {
            if (columnType.isBoolean()) {
                return BooleanComparator.toBoolean((Object)value);
            }
            if (columnType.isNumber()) {
                return NumberComparator.toNumber((Object)columnType.isNumber());
            }
            if (columnType.isTimeBased()) {
                SimpleDateFormat format;
                if (columnType == ColumnType.DATE) {
                    format = new SimpleDateFormat("yyyy-MM-dd");
                } else if (columnType == ColumnType.TIMESTAMP) {
                    format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                    format.setTimeZone(SalesforceDataContext.SOQL_TIMEZONE);
                } else {
                    format = new SimpleDateFormat("HH:mm:ss.SSS");
                    format.setTimeZone(SalesforceDataContext.SOQL_TIMEZONE);
                }
                try {
                    return format.parse(value.toString());
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Unable to parse date/time value: " + value);
                }
            }
        }
        return value;
    }
}

