/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.salesforce;

import java.util.ArrayList;
import java.util.List;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.delete.AbstractRowDeletionBuilder;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.salesforce.SalesforceUpdateCallback;
import org.eobjects.metamodel.schema.Table;

final class SalesforceDeleteBuilder
extends AbstractRowDeletionBuilder {
    private final SalesforceUpdateCallback _updateCallback;

    public SalesforceDeleteBuilder(SalesforceUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        List whereItems = this.getWhereItems();
        if (whereItems.isEmpty()) {
            throw new IllegalStateException("Salesforce only allows deletion of records by their specific IDs. Violated by not having any where items");
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (FilterItem whereItem : whereItems) {
            this._updateCallback.buildIdList(idList, whereItem);
        }
        this._updateCallback.delete(idList.toArray(new String[idList.size()]));
    }
}

