/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.salesforce;

import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.ws.ConnectionException;
import java.util.ArrayList;
import java.util.List;
import org.eobjects.metamodel.salesforce.SalesforceUtils;
import org.eobjects.metamodel.schema.AbstractTable;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.Relationship;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.schema.TableType;
import org.eobjects.metamodel.util.LazyRef;
import org.eobjects.metamodel.util.Ref;

final class SalesforceTable
extends AbstractTable {
    private static final long serialVersionUID = 1L;
    private final transient Ref<List<Column>> _columnRef;
    private final transient PartnerConnection _connection;
    private final String _name;
    private final String _remarks;
    private final Schema _schema;

    public SalesforceTable(String name, String remarks, Schema schema, PartnerConnection connection) {
        this._name = name;
        this._remarks = remarks;
        this._schema = schema;
        this._connection = connection;
        this._columnRef = new LazyRef<List<Column>>(){

            protected List<Column> fetch() {
                DescribeSObjectResult describeSObject;
                ArrayList<Column> result = new ArrayList<Column>();
                try {
                    describeSObject = SalesforceTable.this._connection.describeSObject(SalesforceTable.this._name);
                }
                catch (ConnectionException e) {
                    throw SalesforceUtils.wrapException(e, "Failed to invoke describeSObject service");
                }
                Field[] fields = describeSObject.getFields();
                int i = 0;
                for (Field field : fields) {
                    String columnName = field.getName();
                    String columnLabel = field.getLabel();
                    Boolean nillable = field.isNillable();
                    FieldType type = field.getType();
                    Integer columnSize = field.getLength();
                    ColumnType columnType = SalesforceTable.toColumnType(type);
                    MutableColumn column = new MutableColumn(columnName, columnType);
                    column.setTable((Table)SalesforceTable.this);
                    column.setRemarks(columnLabel);
                    column.setNullable(nillable);
                    column.setNativeType(type.toString());
                    column.setColumnSize(columnSize);
                    column.setColumnNumber(i);
                    if (type == FieldType.id) {
                        column.setPrimaryKey(true);
                    }
                    ++i;
                    result.add((Column)column);
                }
                return result;
            }
        };
    }

    protected static ColumnType toColumnType(FieldType type) {
        switch (type) {
            case _boolean: {
                return ColumnType.BOOLEAN;
            }
            case _int: {
                return ColumnType.INTEGER;
            }
            case _double: {
                return ColumnType.DOUBLE;
            }
            case date: {
                return ColumnType.DATE;
            }
            case datetime: {
                return ColumnType.TIMESTAMP;
            }
            case time: {
                return ColumnType.TIME;
            }
            case string: 
            case email: 
            case url: 
            case phone: 
            case reference: 
            case textarea: 
            case encryptedstring: 
            case base64: 
            case currency: 
            case id: 
            case picklist: {
                return ColumnType.VARCHAR;
            }
        }
        return ColumnType.OTHER;
    }

    public String getName() {
        return this._name;
    }

    public Column[] getColumns() {
        if (this._columnRef == null) {
            return new Column[0];
        }
        List columns = (List)this._columnRef.get();
        return columns.toArray(new Column[columns.size()]);
    }

    public Schema getSchema() {
        return this._schema;
    }

    public TableType getType() {
        return TableType.TABLE;
    }

    public Relationship[] getRelationships() {
        return new Relationship[0];
    }

    public String getRemarks() {
        return this._remarks;
    }

    public String getQuote() {
        return null;
    }
}

