/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.salesforce;

import com.sforce.soap.partner.sobject.SObject;
import java.util.ArrayList;
import java.util.List;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.salesforce.SalesforceUpdateCallback;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.update.AbstractRowUpdationBuilder;

public class SalesforceUpdateBuilder
extends AbstractRowUpdationBuilder {
    private final SalesforceUpdateCallback _updateCallback;

    public SalesforceUpdateBuilder(SalesforceUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        ArrayList<String> idList = new ArrayList<String>();
        List whereItems = this.getWhereItems();
        for (FilterItem whereItem : whereItems) {
            this._updateCallback.buildIdList(idList, whereItem);
        }
        SObject[] updatedObjects = new SObject[idList.size()];
        for (int i = 0; i < updatedObjects.length; ++i) {
            SObject object;
            updatedObjects[i] = object = this.buildUpdatedObject((String)idList.get(i));
        }
        this._updateCallback.update(updatedObjects);
    }

    private SObject buildUpdatedObject(String id) {
        SObject obj = new SObject();
        obj.setId(id);
        obj.setType(this.getTable().getName());
        Object[] values = this.getValues();
        Column[] columns = this.getColumns();
        boolean[] explicitNulls = this.getExplicitNulls();
        ArrayList<String> nullFields = new ArrayList<String>();
        for (int i = 0; i < columns.length; ++i) {
            Object value = values[i];
            Column column = columns[i];
            if (value == null) {
                if (!explicitNulls[i]) continue;
                nullFields.add(column.getName());
                continue;
            }
            obj.setField(column.getName(), value);
        }
        obj.setFieldsToNull(nullFields.toArray(new String[nullFields.size()]));
        return obj;
    }
}

