/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.sugarcrm;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMessageHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger logger = LoggerFactory.getLogger(LoggingMessageHandler.class);

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    public void close(MessageContext context) {
    }

    public boolean handleFault(SOAPMessageContext context) {
        if (logger.isDebugEnabled()) {
            String messageAsString = this.getMessageAsString(context.getMessage());
            logger.debug("Received fault message: {}", (Object)messageAsString);
        }
        return true;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        if (logger.isDebugEnabled()) {
            String messageAsString = this.getMessageAsString(context.getMessage());
            logger.debug("Handling message: {}", (Object)messageAsString);
        }
        return true;
    }

    private String getMessageAsString(SOAPMessage message) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)baos);
        }
        catch (Exception e) {
            logger.error("Unexpected error while getting message", (Throwable)e);
        }
        String messageAsString = new String(baos.toByteArray());
        return messageAsString;
    }
}

