/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.sugarcrm;

import com.sugarcrm.ws.soap.EntryValue;
import com.sugarcrm.ws.soap.GetEntriesCountResult;
import com.sugarcrm.ws.soap.GetEntryListResultVersion2;
import com.sugarcrm.ws.soap.LinkNamesToFieldsArray;
import com.sugarcrm.ws.soap.NameValueList;
import com.sugarcrm.ws.soap.SelectFields;
import com.sugarcrm.ws.soap.Sugarsoap;
import com.sugarcrm.ws.soap.SugarsoapPortType;
import com.sugarcrm.ws.soap.UserAuth;
import java.io.Closeable;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.commons.codec.digest.DigestUtils;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.QueryPostprocessDataContext;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.MaxRowsDataSet;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.sugarcrm.SugarCrmDataSet;
import org.eobjects.metamodel.sugarcrm.SugarCrmSchema;
import org.eobjects.metamodel.sugarcrm.SugarCrmXmlHelper;
import org.eobjects.metamodel.util.LazyRef;
import org.eobjects.metamodel.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SugarCrmDataContext
extends QueryPostprocessDataContext
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(SugarCrmDataContext.class);
    public static final int FETCH_SIZE = 200;
    private final LazyRef<String> _sessionId;
    private final SugarsoapPortType _service;

    public SugarCrmDataContext(String sugarCrmBaseUrl, final String username, String password, final String applicationName) {
        URL wsdlUrl;
        if (sugarCrmBaseUrl.endsWith("/")) {
            sugarCrmBaseUrl = sugarCrmBaseUrl.substring(0, sugarCrmBaseUrl.length() - 1);
        }
        String endpointAddress = sugarCrmBaseUrl + "/service/v4/soap.php";
        String wsdlAddress = endpointAddress + "?wsdl";
        logger.info("Connecting to SugarCRM SOAP service using WSDL URL: {}", (Object)wsdlAddress);
        try {
            wsdlUrl = new URL(wsdlAddress);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid SugarCRM base URL: " + e.getMessage(), e);
        }
        Sugarsoap soap = new Sugarsoap(wsdlUrl, new QName("http://www.sugarcrm.com/sugarcrm", "sugarsoap"));
        this._service = soap.getSugarsoapPort();
        assert (this._service instanceof BindingProvider);
        BindingProvider bindingProvider = (BindingProvider)this._service;
        bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpointAddress);
        final String md5password = DigestUtils.md5Hex((String)password);
        this._sessionId = new LazyRef<String>(){

            protected String fetch() {
                UserAuth userAuth = new UserAuth();
                userAuth.setUserName(username);
                userAuth.setPassword(md5password);
                logger.debug("Logging in as '{}', with application name '{}'", (Object)username, (Object)applicationName);
                EntryValue response = SugarCrmDataContext.this._service.login(userAuth, applicationName, new NameValueList());
                String sessionId = response.getId();
                logger.info("Started session with SugarCRM. Session ID: {}", (Object)sessionId);
                return sessionId;
            }
        };
    }

    @Override
    public void close() {
        if (this._sessionId.isFetched()) {
            try {
                this._service.logout((String)this._sessionId.get());
            }
            catch (Exception e) {
                logger.debug("Failed to log out while closing DataContext", (Throwable)e);
            }
        }
    }

    protected Schema getMainSchema() throws MetaModelException {
        SugarCrmSchema schema = new SugarCrmSchema(this.getMainSchemaName(), this._service, (Ref<String>)this._sessionId);
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return "SugarCRM";
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (whereItems.isEmpty()) {
            String session = (String)this._sessionId.get();
            String moduleName = table.getName();
            GetEntriesCountResult entriesCount = this._service.getEntriesCount(session, moduleName, "", 0);
            int resultCount = entriesCount.getResultCount();
            return resultCount;
        }
        return super.executeCountQuery(table, whereItems, functionApproximationAllowed);
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        String session = (String)this._sessionId.get();
        String moduleName = table.getName();
        SelectFields selectFields = SugarCrmXmlHelper.createSelectFields(columns);
        LinkNamesToFieldsArray linkNameToFieldsArray = new LinkNamesToFieldsArray();
        int fetchSize = maxRows < 0 || maxRows > 200 ? 200 : maxRows;
        GetEntryListResultVersion2 entryList = this._service.getEntryList(session, moduleName, "", "", 0, selectFields, linkNameToFieldsArray, fetchSize, 0, false);
        SugarCrmDataSet dataSet = new SugarCrmDataSet(columns, this._service, session, entryList);
        if (maxRows > 0) {
            return new MaxRowsDataSet((DataSet)dataSet, maxRows);
        }
        return dataSet;
    }
}

