/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.xml;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.MetaModelHelper;
import org.eobjects.metamodel.QueryPostprocessDataContext;
import org.eobjects.metamodel.data.CachingDataSetHeader;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.DataSetHeader;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.InMemoryDataSet;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.JoinType;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.MutableRelationship;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Relationship;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.schema.TableType;
import org.eobjects.metamodel.util.FileResource;
import org.eobjects.metamodel.util.ImmutableRef;
import org.eobjects.metamodel.util.NumberComparator;
import org.eobjects.metamodel.util.Ref;
import org.eobjects.metamodel.util.Resource;
import org.eobjects.metamodel.util.UrlResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlDomDataContext
extends QueryPostprocessDataContext {
    private static final Logger logger = LoggerFactory.getLogger(XmlDomDataContext.class);
    public static final String NATIVE_TYPE_PRIMARY_KEY = "Auto-generated primary key";
    public static final String NATIVE_TYPE_FOREIGN_KEY = "Auto-generated foreign key";
    public static final String NATIVE_TYPE_ATTRIBUTE = "XML Attribute";
    public static final String NATIVE_TYPE_TEXT = "XML Text";
    private static final String TEXT_CONTENT_TEMP_SUFFIX = "_metamodel_text_content";
    private final Ref<InputSource> _inputSourceRef;
    private final Map<String, List<Object[]>> _tableData = new HashMap<String, List<Object[]>>();
    private final String _schemaName;
    private MutableSchema _schema;
    private boolean _autoFlattenTables;

    public XmlDomDataContext(String schemaName, Document document, boolean autoFlattenTables) {
        this._autoFlattenTables = autoFlattenTables;
        this._schemaName = schemaName;
        this._schema = new MutableSchema(this._schemaName);
        this._inputSourceRef = null;
        this.loadSchema(document);
    }

    public XmlDomDataContext(Resource resource, boolean autoFlattenTables) throws IllegalArgumentException {
        this._inputSourceRef = XmlDomDataContext.createInputSourceRef(resource);
        this._schemaName = resource.getName();
        this._autoFlattenTables = autoFlattenTables;
    }

    public XmlDomDataContext(File file, boolean autoFlattenTables) {
        this((Resource)new FileResource(file), autoFlattenTables);
    }

    public XmlDomDataContext(InputSource inputSource, String schemaName, boolean autoFlattenTables) {
        this._inputSourceRef = new ImmutableRef((Object)inputSource);
        this._schemaName = schemaName;
        this._autoFlattenTables = autoFlattenTables;
    }

    public XmlDomDataContext(URL url, boolean autoFlattenTables) throws IllegalArgumentException {
        this((Resource)new UrlResource(url), autoFlattenTables);
    }

    private static Ref<InputSource> createInputSourceRef(final Resource resource) {
        return new Ref<InputSource>(){

            public InputSource get() {
                InputStream in = resource.read();
                return new InputSource(in);
            }
        };
    }

    public XmlDomDataContext(File file) {
        this(file, true);
    }

    public boolean isAutoFlattenTables() {
        return this._autoFlattenTables;
    }

    public void setAutoFlattenTables(boolean autoFlattenTables) {
        this._autoFlattenTables = autoFlattenTables;
    }

    public DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        this.loadSchema();
        List<Object[]> tableData = this._tableData.get(table.getName());
        if (tableData == null) {
            throw new IllegalStateException("No such table name: '" + table.getName() + "'. Valid table names are: " + this._tableData.keySet());
        }
        SelectItem[] selectItems = MetaModelHelper.createSelectItems((Column[])columns);
        CachingDataSetHeader header = new CachingDataSetHeader(selectItems);
        ArrayList<DefaultRow> resultData = new ArrayList<DefaultRow>();
        for (Object[] tableDataRow : tableData) {
            if (maxRows == 0) break;
            --maxRows;
            Object[] dataValues = new Object[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                int columnNumber = column.getColumnNumber();
                dataValues[i] = columnNumber < tableDataRow.length ? tableDataRow[columnNumber] : null;
            }
            resultData.add(new DefaultRow((DataSetHeader)header, dataValues));
        }
        return new InMemoryDataSet((DataSetHeader)header, resultData);
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._schemaName;
    }

    protected Schema getMainSchema() throws MetaModelException {
        this.loadSchema();
        return this._schema;
    }

    public XmlDomDataContext reloadSchema() {
        this._schema = null;
        this.loadSchema();
        return this;
    }

    public XmlDomDataContext loadSchema() {
        if (this._schema == null) {
            this._schema = new MutableSchema(this._schemaName);
            InputSource inputSource = (InputSource)this._inputSourceRef.get();
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setIgnoringComments(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(inputSource);
                this.loadSchema(document);
            }
            catch (Exception e) {
                throw new MetaModelException("Error parsing XML file: " + e.getMessage(), e);
            }
        }
        return this;
    }

    private void loadSchema(Document document) {
        MutableTable[] tables;
        Element rootElement = document.getDocumentElement();
        this.loadTables(rootElement, "", null, 0);
        for (MutableTable table : tables = this._schema.getTables()) {
            String tableName = table.getName();
            List<Object[]> tableRows = this._tableData.get(tableName);
            if (tableRows == null) {
                logger.info("Remove table (no data in it): {}", (Object)tableName);
                this._schema.removeTable((Table)table);
                continue;
            }
            MutableColumn idColumn = this.getIdColumn(table);
            MutableColumn column = (MutableColumn)table.getColumnByName("id");
            if (column == null) {
                idColumn.setName("id");
            }
            MutableColumn textContentColumn = (MutableColumn)this.getTextContentColumn(table, null);
            int textContentColumnIndex = textContentColumn.getColumnNumber();
            boolean found = false;
            for (Object[] objects : tableRows) {
                if (objects[textContentColumnIndex] == null) continue;
                found = true;
                break;
            }
            if (!found) {
                table.removeColumn((Column)textContentColumn);
                continue;
            }
            String currentName = textContentColumn.getName();
            String preferredName = currentName.substring(0, currentName.length() - TEXT_CONTENT_TEMP_SUFFIX.length());
            column = (MutableColumn)table.getColumnByName(preferredName);
            if (column != null) continue;
            textContentColumn.setName(preferredName);
        }
        if (this._autoFlattenTables) {
            this.autoFlattenTables();
        }
    }

    private void loadTables(Element element, String tablePrefix, Column parentKeyColumn, int parentKey) {
        Attr[] attributes = XmlDomDataContext.getAttributes(element);
        String textContent = XmlDomDataContext.getTextContent(element);
        String tableName = tablePrefix + element.getNodeName();
        if (attributes.length > 0 || textContent != null || XmlDomDataContext.hasSiblings(element)) {
            MutableColumn foreignKeyColumn;
            List<Object[]> tableRows;
            MutableColumn idColumn;
            MutableTable table = (MutableTable)this._schema.getTableByName(tableName);
            if (table == null) {
                logger.info("Creating table: {}", (Object)tableName);
                table = new MutableTable(tableName, TableType.TABLE, (Schema)this._schema);
                this._schema.addTable(table);
                idColumn = this.getIdColumn(table);
                tableRows = new ArrayList<Object[]>();
                this._tableData.put(tableName, tableRows);
                if (parentKeyColumn != null) {
                    Table parentTable = parentKeyColumn.getTable();
                    foreignKeyColumn = new MutableColumn(parentTable.getName() + "_id", parentKeyColumn.getType(), (Table)table, table.getColumnCount(), Boolean.valueOf(false));
                    foreignKeyColumn.setNativeType(NATIVE_TYPE_FOREIGN_KEY);
                    table.addColumn((Column)foreignKeyColumn);
                    MutableRelationship.createRelationship((Column[])new Column[]{parentKeyColumn}, (Column[])new Column[]{foreignKeyColumn});
                } else {
                    foreignKeyColumn = null;
                }
            } else {
                idColumn = this.getIdColumn(table);
                tableRows = this._tableData.get(tableName);
                Column[] foreignKeys = table.getForeignKeys();
                foreignKeyColumn = foreignKeys.length == 1 ? (MutableColumn)foreignKeys[0] : null;
            }
            Column textContentColumn = this.getTextContentColumn(table, element.getNodeName());
            HashMap<MutableColumn, String> columnValues = new HashMap<MutableColumn, String>();
            for (Attr attr : attributes) {
                String name = attr.getName();
                MutableColumn column = (MutableColumn)table.getColumnByName(name);
                if (column == null) {
                    logger.info("Creating column: {}.{}", (Object)tableName, (Object)name);
                    column = new MutableColumn(name, ColumnType.VARCHAR, (Table)table, table.getColumnCount(), Boolean.valueOf(true));
                    column.setNativeType(NATIVE_TYPE_ATTRIBUTE);
                    table.addColumn((Column)column);
                }
                columnValues.put(column, attr.getValue());
            }
            Object[] rowData = new Object[table.getColumnCount()];
            int id = tableRows.size() + 1;
            rowData[idColumn.getColumnNumber()] = id;
            if (foreignKeyColumn != null) {
                rowData[foreignKeyColumn.getColumnNumber()] = parentKey;
            }
            if (textContent != null) {
                rowData[textContentColumn.getColumnNumber()] = textContent;
            }
            for (Map.Entry entry : columnValues.entrySet()) {
                rowData[((Column)entry.getKey()).getColumnNumber()] = entry.getValue();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Adding data [{}] to table: {}", (Object)Arrays.toString(rowData), (Object)tableName);
            }
            if (!XmlDomDataContext.isRootElement(element)) {
                parentKey = id;
                parentKeyColumn = idColumn;
            }
            tableRows.add(rowData);
        }
        if (!XmlDomDataContext.isRootElement(element)) {
            tablePrefix = tableName + "_";
        }
        Element[] childElements = XmlDomDataContext.getChildElements(element);
        for (int i = 0; i < childElements.length; ++i) {
            this.loadTables(childElements[i], tablePrefix, parentKeyColumn, parentKey);
        }
    }

    private Column getTextContentColumn(MutableTable table, String preferredColumnName) {
        Column[] columns = table.getColumns();
        MutableColumn column = null;
        for (Column col : columns) {
            if (!NATIVE_TYPE_TEXT.equals(col.getNativeType())) continue;
            column = (MutableColumn)col;
            break;
        }
        if (column == null && preferredColumnName != null) {
            logger.info("Creating text content column for table: " + table.getName());
            column = new MutableColumn(preferredColumnName + TEXT_CONTENT_TEMP_SUFFIX, ColumnType.VARCHAR, (Table)table, table.getColumnCount(), Boolean.valueOf(true));
            column.setNativeType(NATIVE_TYPE_TEXT);
            table.addColumn((Column)column);
        }
        return column;
    }

    private MutableColumn getIdColumn(MutableTable table) {
        Column[] columns = table.getColumns();
        MutableColumn column = null;
        for (Column col : columns) {
            if (!NATIVE_TYPE_PRIMARY_KEY.equals(col.getNativeType())) continue;
            column = (MutableColumn)col;
            break;
        }
        if (column == null) {
            String tableName = table.getName();
            logger.info("Creating id column for table: " + tableName);
            column = new MutableColumn(tableName + "_metamodel_surrogate_id", ColumnType.INTEGER, (Table)table, table.getColumnCount(), Boolean.valueOf(false));
            column.setNativeType(NATIVE_TYPE_PRIMARY_KEY);
            column.setIndexed(true);
            table.addColumn((Column)column);
        }
        return column;
    }

    public static String getTextContent(Element element) {
        String textContent = null;
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Text)) continue;
            textContent = ((Text)node).getWholeText();
            break;
        }
        if (textContent != null && !"".equals(textContent = textContent.trim())) {
            return textContent;
        }
        return null;
    }

    public static Attr[] getAttributes(Element element) {
        ArrayList<Attr> result = new ArrayList<Attr>();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            result.add(attribute);
        }
        return result.toArray(new Attr[result.size()]);
    }

    public static boolean hasSiblings(Element element) {
        if (!XmlDomDataContext.isRootElement(element)) {
            String name = element.getNodeName();
            Element[] siblingNodes = XmlDomDataContext.getChildElements((Element)element.getParentNode());
            for (int i = 0; i < siblingNodes.length; ++i) {
                Element siblingNode = siblingNodes[i];
                if (siblingNode == element || !name.equals(siblingNode.getNodeName())) continue;
                return true;
            }
        }
        return false;
    }

    public static Element[] getChildElements(Element element) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!(child instanceof Element)) continue;
            result.add((Element)child);
        }
        return result.toArray(new Element[result.size()]);
    }

    public static boolean isRootElement(Element element) {
        return !(element.getParentNode() instanceof Element);
    }

    public XmlDomDataContext flattenTables(Relationship relationship) {
        Column[] foreignKeys;
        MutableTable primaryTable = (MutableTable)relationship.getPrimaryTable();
        MutableTable foreignTable = (MutableTable)relationship.getForeignTable();
        if (foreignTable.getPrimaryKeyRelationships().length != 0) {
            Relationship[] foreignPrimaryRelationships = foreignTable.getPrimaryKeyRelationships();
            Object[] foreignPrimaryNames = new String[foreignPrimaryRelationships.length];
            for (int i = 0; i < foreignPrimaryRelationships.length; ++i) {
                foreignPrimaryNames[i] = foreignPrimaryRelationships[i].getForeignTable().getName();
            }
            throw new UnsupportedOperationException("Cannot flatten foreign table '" + foreignTable.getName() + "' as it acts as primary table for tables: " + Arrays.toString(foreignPrimaryNames));
        }
        ArrayList<Column> primaryColumns = new ArrayList<Column>(Arrays.asList(primaryTable.getColumns()));
        ArrayList<Column> foreignColumns = new ArrayList<Column>(Arrays.asList(foreignTable.getColumns()));
        String primaryTableName = primaryTable.getName();
        String foreignTableName = foreignTable.getName();
        MutableColumn idColumn = this.getIdColumn(foreignTable);
        foreignColumns.remove(idColumn);
        for (Column foreignKey : foreignKeys = foreignTable.getForeignKeys()) {
            foreignColumns.remove(foreignKey);
        }
        Query q = new Query();
        q.select(primaryColumns.toArray(new Column[primaryColumns.size()]));
        q.select(foreignColumns.toArray(new Column[foreignColumns.size()]));
        q.from(new FromItem[]{new FromItem(JoinType.LEFT, relationship)});
        if (logger.isDebugEnabled()) {
            logger.debug("Setting table data for '{}' to query result: {}", (Object)primaryTableName, (Object)q.toString());
        }
        List tableRows = this.executeQuery(q).toObjectArrays();
        for (Column foreignColumn : foreignColumns) {
            MutableColumn newPrimaryColumn = new MutableColumn(foreignColumn.getName(), foreignColumn.getType(), (Table)primaryTable, primaryTable.getColumnCount(), foreignColumn.isNullable());
            newPrimaryColumn.setIndexed(foreignColumn.isIndexed());
            newPrimaryColumn.setNativeType(foreignColumn.getNativeType());
            primaryTable.addColumn((Column)newPrimaryColumn);
        }
        this._tableData.put(primaryTableName, tableRows);
        MutableSchema mutableSchema = (MutableSchema)foreignTable.getSchema();
        mutableSchema.removeTable((Table)foreignTable);
        this._tableData.remove(foreignTableName);
        ((MutableRelationship)relationship).remove();
        if (logger.isInfoEnabled()) {
            logger.info("Tables '" + primaryTableName + "' and '" + foreignTableName + "' flattened to: " + primaryTableName);
            if (logger.isDebugEnabled()) {
                logger.debug(primaryTableName + " columns: " + Arrays.toString(primaryTable.getColumns()));
            }
        }
        return this;
    }

    public XmlDomDataContext autoFlattenTables() {
        MutableTable[] tables;
        for (MutableTable table : tables = this._schema.getTables()) {
            Column[] columns;
            Relationship[] foreignKeyRelationships;
            if (!this._tableData.containsKey(table.getName()) || (foreignKeyRelationships = table.getForeignKeyRelationships()).length != 1 || table.getPrimaryKeyRelationships().length != 0) continue;
            Relationship foreignKeyRelationship = foreignKeyRelationships[0];
            int nonDataColumns = 0;
            for (Column column : columns = table.getColumns()) {
                String nativeType = column.getNativeType();
                if (!NATIVE_TYPE_FOREIGN_KEY.equals(nativeType) && !NATIVE_TYPE_PRIMARY_KEY.equals(nativeType)) continue;
                ++nonDataColumns;
            }
            if (columns.length != nonDataColumns + 1) continue;
            boolean uniqueForeignKeys = true;
            Column[] foreignColumns = foreignKeyRelationship.getForeignColumns();
            SelectItem countAllItem = SelectItem.getCountAllItem();
            Query q = new Query().select(foreignColumns).select(new SelectItem[]{countAllItem}).from((Table)table).groupBy(foreignColumns);
            DataSet data = this.executeQuery(q);
            Comparable comparable = NumberComparator.getComparable((Object)1);
            while (data.next()) {
                Object value = data.getRow().getValue(countAllItem);
                if (comparable.compareTo(value) >= 0) continue;
                uniqueForeignKeys = false;
                break;
            }
            data.close();
            if (!uniqueForeignKeys) continue;
            this.flattenTables(foreignKeyRelationship);
        }
        return this;
    }
}

