/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.metamodel.data.RowPublisher;
import org.eobjects.metamodel.xml.XmlStopParsingException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XmlSaxContentHandler
extends DefaultHandler {
    private final boolean _checkAttributes;
    private final String _rowXpath;
    private final String[] _valueXpaths;
    private final StringBuilder _pathBuilder;
    private final StringBuilder _valueBuilder;
    private final RowPublisher _rowPublisher;
    private final Map<String, Integer> _indexIndexes;
    private final Map<String, AtomicInteger> _indexCounters = new HashMap<String, AtomicInteger>();
    private volatile Object[] _rowValues;
    private volatile int _xpathIndex;

    public XmlSaxContentHandler(String rowXpath, RowPublisher rowPublisher, String ... valueXpaths) {
        this._indexIndexes = new HashMap<String, Integer>();
        this._rowXpath = rowXpath;
        this._rowPublisher = rowPublisher;
        this._valueXpaths = valueXpaths;
        this._rowValues = new Object[valueXpaths.length];
        boolean checkAttributes = false;
        for (int i = 0; i < valueXpaths.length; ++i) {
            String xpath = valueXpaths[i];
            if ("row_id".equals(xpath)) {
                xpath = "index(" + xpath + ")";
            }
            if (xpath.startsWith("index(") && xpath.endsWith(")")) {
                xpath = xpath.substring("index(".length(), xpath.length() - 1);
                this._indexCounters.put(xpath, new AtomicInteger(-1));
                this._indexIndexes.put(xpath, i);
                continue;
            }
            if (xpath.indexOf(64) == -1) continue;
            checkAttributes = true;
        }
        this._checkAttributes = checkAttributes;
        this._xpathIndex = -1;
        this._pathBuilder = new StringBuilder();
        this._valueBuilder = new StringBuilder();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String xpath;
        AtomicInteger indexCounter;
        this._pathBuilder.append('/');
        this._pathBuilder.append(qName);
        if (this._checkAttributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeName = attributes.getQName(i);
                String attributeValue = attributes.getValue(i);
                this.startAttribute(attributeName, attributeValue);
                this.endAttribute(attributeName, attributeValue);
            }
        }
        if ((indexCounter = this._indexCounters.get(xpath = this._pathBuilder.toString())) != null) {
            indexCounter.incrementAndGet();
        }
        this._xpathIndex = this.indexOfXpath(xpath);
    }

    private int indexOfXpath(String path) {
        if (path == null || path.length() == 0) {
            return -1;
        }
        for (int i = 0; i < this._valueXpaths.length; ++i) {
            if (!path.equals(this._valueXpaths[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._xpathIndex != -1) {
            this._valueBuilder.append(ch, start, length);
        }
    }

    private void startAttribute(String attributeName, String attributeValue) {
        this._pathBuilder.append('@');
        this._pathBuilder.append(attributeName);
        int indexOfXpath = this.indexOfXpath(this._pathBuilder.toString());
        if (indexOfXpath != -1) {
            this._rowValues[indexOfXpath] = attributeValue;
        }
    }

    private void endAttribute(String attributeName, String attributeValue) {
        this._pathBuilder.setLength(this._pathBuilder.length() - attributeName.length() - 1);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this._xpathIndex != -1) {
            this._rowValues[this._xpathIndex] = this._valueBuilder.toString().trim();
        }
        this._xpathIndex = -1;
        this._valueBuilder.setLength(0);
        if (this._rowXpath.equals(this._pathBuilder.toString())) {
            this.insertRowIndexes();
            boolean more = this._rowPublisher.publish(this._rowValues);
            if (!more) {
                throw new XmlStopParsingException();
            }
            this._rowValues = new Object[this._valueXpaths.length];
        }
        this._pathBuilder.setLength(this._pathBuilder.length() - qName.length() - 1);
    }

    private void insertRowIndexes() {
        Set<Map.Entry<String, Integer>> entrySet = this._indexIndexes.entrySet();
        for (Map.Entry<String, Integer> entry : entrySet) {
            String xpath = entry.getKey();
            Integer indexIndex = entry.getValue();
            AtomicInteger indexCount = this._indexCounters.get(xpath);
            this._rowValues[indexIndex.intValue()] = indexCount.get();
        }
    }
}

