/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client;

import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.http.client.async.AsyncContentProvider;

public final class HttpResponse
implements Closeable {
    private final AsyncContentProvider body;
    private boolean closed = false;
    private final Map<String, String> headers;
    private final int status;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(HttpResponse httpResponse) {
        return new Builder(httpResponse);
    }

    private HttpResponse(Builder builder) {
        this.status = builder.status;
        this.headers = Collections.unmodifiableMap(new HashMap(builder.headers));
        this.body = Objects.requireNonNull(builder.body);
    }

    @Override
    public void close() {
        this.closed = true;
        this.body.close();
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            System.err.println("HEY DEVELOPER! YOU FORGOT TO CLOSE YOUR " + this.getClass().getName() + " INSTANCE");
        }
    }

    public AsyncContentProvider getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public int getStatus() {
        return this.status;
    }

    public static final class Builder {
        private AsyncContentProvider body;
        private Map<String, String> headers = Collections.emptyMap();
        private int status;

        private Builder() {
        }

        private Builder(HttpResponse httpResponse) {
            this.status = httpResponse.status;
            this.headers = Objects.requireNonNull(httpResponse.headers);
            this.body = Objects.requireNonNull(httpResponse.body);
        }

        public Builder body(AsyncContentProvider body) {
            this.body = Objects.requireNonNull(body);
            return this;
        }

        public HttpResponse build() {
            return new HttpResponse(this);
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = Objects.requireNonNull(headers);
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }
    }
}

