/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.everit.http.client.async.AsyncContentProvider;
import org.everit.http.client.async.ByteArrayAsyncContentProvider;

public class Part {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private final AsyncContentProvider content;
    private final Optional<String> contentType;
    private final Map<String, String> fields;
    private final Optional<String> fileName;
    private final String headers;
    private final String name;

    public static Part createFieldPart(String name, AsyncContentProvider value) {
        return new Part(name, Optional.empty(), Optional.empty(), value, Collections.emptyMap());
    }

    public static Part createFieldPart(String name, String value) {
        return Part.createFieldPart(name, new ByteArrayAsyncContentProvider(value.getBytes(StandardCharsets.UTF_8), Optional.empty()));
    }

    public Part(String name, Optional<String> fileName, Optional<String> contentType, AsyncContentProvider content, Map<String, String> fields) {
        this.name = name;
        this.fileName = fileName;
        this.contentType = contentType;
        this.content = content;
        this.fields = fields;
        this.headers = this.headers();
    }

    public AsyncContentProvider getContent() {
        return this.content;
    }

    public String getHeaders() {
        return this.headers;
    }

    private String headers() {
        String contentDisposition = "Content-Disposition: form-data; name=\"" + this.name + "\"";
        if (this.fileName.isPresent()) {
            contentDisposition = contentDisposition + "; filename=\"" + this.fileName.get() + "\"";
        }
        contentDisposition = contentDisposition + "\r\n";
        String contentType = this.resolveContentTypeHeader();
        if (this.fields.isEmpty()) {
            String headers = contentDisposition;
            headers = headers + contentType;
            headers = headers + "\r\n";
            return headers;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(contentDisposition);
        sb.append(contentType);
        for (Map.Entry<String, String> field : this.fields.entrySet()) {
            if (HEADER_CONTENT_TYPE.equals(field.getKey())) continue;
            sb.append(field.getKey());
            sb.append(": ");
            String value = field.getValue();
            if (value != null) {
                sb.append(value);
            }
            sb.append("\r\n");
        }
        sb.append("\r\n");
        return sb.toString();
    }

    private String resolveContentTypeHeader() {
        String contentType = null;
        if (this.contentType.isPresent()) {
            contentType = this.contentType.get();
        }
        if (contentType == null) {
            contentType = this.fields.get(HEADER_CONTENT_TYPE);
        }
        if (contentType == null && this.content.getContentType().isPresent()) {
            contentType = this.content.getContentType().get().toString();
        }
        if (contentType == null) {
            contentType = "text/plain";
        }
        contentType = "Content-Type: " + contentType + "\r\n";
        return contentType;
    }

    public String toString() {
        return String.format("%s@%x[name=%s,fileName=%s,length=%d,headers=%s]", this.getClass().getSimpleName(), this.hashCode(), this.name, this.fileName, this.content.getContentLength(), this.fields);
    }
}

