/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client.async;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.everit.http.client.async.AsyncCallback;
import org.everit.http.client.async.AsyncContentListener;
import org.everit.http.client.async.AsyncContentProvider;

public abstract class AbstractAsyncContentProvider
implements AsyncContentProvider {
    private static final Logger LOGGER = Logger.getLogger(AbstractAsyncContentProvider.class.getName());
    private boolean closed = false;
    private AsyncContentListener contentListener;
    private Throwable error;
    private Consumer<Throwable> errorAction;
    private boolean finished = false;
    private Runnable successAction;

    private void callErrorListenerIfNecessary() {
        if (this.error != null && this.errorAction != null) {
            try {
                this.errorAction.accept(this.error);
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Error during handling exception", e);
            }
        }
    }

    private void callSuccessListenerIfNecessary() {
        if (this.error == null && this.finished && this.successAction != null) {
            try {
                this.successAction.run();
            }
            catch (Throwable e) {
                this.error = e;
                this.callErrorListenerIfNecessary();
            }
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.doClose();
        }
        finally {
            this.closed = true;
        }
    }

    protected abstract void doClose();

    @Override
    public final Optional<Throwable> getFailure() {
        return Optional.ofNullable(this.error);
    }

    protected void handleErrorFromInput(Throwable failure) {
        this.error = failure;
        this.callErrorListenerIfNecessary();
    }

    protected void handleSuccess() {
        this.finished = true;
        this.callSuccessListenerIfNecessary();
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    private void nextChunkCallback(ByteBuffer chunk) {
        this.contentListener.onContent(chunk, new AsyncCallback(){

            @Override
            public void failed(Throwable e) {
                AbstractAsyncContentProvider.this.error = e;
                AbstractAsyncContentProvider.this.callErrorListenerIfNecessary();
            }

            @Override
            public void processed() {
                AbstractAsyncContentProvider.this.provideNextChunkHandleError(x$0 -> AbstractAsyncContentProvider.this.nextChunkCallback(x$0));
            }
        });
    }

    @Override
    public final AsyncContentProvider onContent(AsyncContentListener listener) {
        if (this.closed) {
            throw new IllegalStateException("This provider is already closed");
        }
        this.contentListener = listener;
        this.provideNextChunkHandleError(this::nextChunkCallback);
        return this;
    }

    @Override
    public final AsyncContentProvider onError(Consumer<Throwable> action) {
        if (this.closed) {
            throw new IllegalStateException("This provider is already closed");
        }
        this.errorAction = action;
        this.callErrorListenerIfNecessary();
        return this;
    }

    @Override
    public final AsyncContentProvider onSuccess(Runnable action) {
        if (this.closed) {
            throw new IllegalStateException("This provider is already closed");
        }
        this.successAction = action;
        this.callSuccessListenerIfNecessary();
        return this;
    }

    protected abstract void provideNextChunk(Consumer<ByteBuffer> var1);

    private void provideNextChunkHandleError(Consumer<ByteBuffer> callback) {
        try {
            this.provideNextChunk(callback);
        }
        catch (Throwable e) {
            this.handleErrorFromInput(e);
        }
    }

    protected static interface OnlyProcessedHandlingAsyncContentListener {
        public void onContent(ByteBuffer var1, Runnable var2);
    }
}

