/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.EventPrivacyType;
import facebook4j.internal.http.HttpParameter;
import facebook4j.internal.util.z_F4JInternalStringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;

public class EventUpdate
implements Serializable {
    private static final long serialVersionUID = 375802784481895434L;
    private final String name;
    private final Calendar startTime;
    private Calendar endTime;
    private String description;
    private String location;
    private String locationId;
    private EventPrivacyType privacyType;

    public EventUpdate(String name, Calendar startTime) {
        this.name = name;
        this.startTime = startTime;
    }

    public EventUpdate(String name, Calendar startTime, Calendar endTime, String description, String location, String locationId, EventPrivacyType privacyType) {
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
        this.description = description;
        this.location = location;
        this.locationId = locationId;
        this.privacyType = privacyType;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
    }

    public EventUpdate endTime(Calendar endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EventUpdate description(String description) {
        this.setDescription(description);
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public EventUpdate location(String location) {
        this.setLocation(location);
        return this;
    }

    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public EventUpdate locationId(String locationId) {
        this.setLocationId(locationId);
        return this;
    }

    public EventPrivacyType getPrivacyType() {
        return this.privacyType;
    }

    public void setPrivacyType(EventPrivacyType privacyType) {
        this.privacyType = privacyType;
    }

    public EventUpdate privacyType(EventPrivacyType privacyType) {
        this.setPrivacyType(privacyType);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("name", this.name));
        params.add(new HttpParameter("start_time", z_F4JInternalStringUtil.formatISO8601Datetime(this.startTime)));
        if (this.endTime != null) {
            params.add(new HttpParameter("end_time", z_F4JInternalStringUtil.formatISO8601Datetime(this.endTime)));
        }
        if (this.description != null) {
            params.add(new HttpParameter("description", this.description));
        }
        if (this.location != null) {
            params.add(new HttpParameter("location", this.location));
        }
        if (this.locationId != null) {
            params.add(new HttpParameter("location_id", this.locationId));
        }
        if (this.privacyType != null) {
            params.add(new HttpParameter("privacy_type", this.privacyType.toString()));
        }
        return params.toArray(new HttpParameter[params.size()]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.locationId == null ? 0 : this.locationId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.privacyType == null ? 0 : this.privacyType.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventUpdate other = (EventUpdate)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.locationId == null ? other.locationId != null : !this.locationId.equals(other.locationId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.privacyType != other.privacyType) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }

    public String toString() {
        return "EventUpdate [name=" + this.name + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", description=" + this.description + ", location=" + this.location + ", locationId=" + this.locationId + ", privacyType=" + (Object)((Object)this.privacyType) + "]";
    }
}

