/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.PrivacyBean;
import facebook4j.PrivacyType;
import facebook4j.internal.util.z_F4JInternalStringUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrivacyBuilder {
    private PrivacyBean privacyBean = new PrivacyBean();

    public PrivacyBuilder setValue(PrivacyType value) {
        this.checkNotBuilt();
        this.privacyBean.setValue(value.toString());
        return this;
    }

    public PrivacyBuilder setFriends(PrivacyType friends) {
        this.checkNotBuilt();
        this.privacyBean.setFriends(friends.toString());
        return this;
    }

    public PrivacyBuilder setNetworks(String networks) {
        this.checkNotBuilt();
        this.privacyBean.setNetworks(networks);
        return this;
    }

    public PrivacyBuilder setNetworks(List<String> networks) {
        this.checkNotBuilt();
        this.privacyBean.setNetworks(z_F4JInternalStringUtil.join(networks.toArray(new String[networks.size()])));
        return this;
    }

    public PrivacyBuilder addNetwork(String network) {
        this.checkNotBuilt();
        String networks = this.privacyBean.getNetworks();
        if (networks == null) {
            this.privacyBean.setNetworks(network);
        } else {
            this.privacyBean.setNetworks(networks + "," + network);
        }
        return this;
    }

    public PrivacyBuilder setAllow(String allow) {
        this.checkNotBuilt();
        this.privacyBean.setAllow(allow);
        return this;
    }

    public PrivacyBuilder setAllow(List<String> allow) {
        this.checkNotBuilt();
        this.privacyBean.setAllow(z_F4JInternalStringUtil.join(allow.toArray(new String[allow.size()])));
        return this;
    }

    public PrivacyBuilder addAllow(String allow) {
        this.checkNotBuilt();
        String allows = this.privacyBean.getAllow();
        if (allows == null) {
            this.privacyBean.setAllow(allow);
        } else {
            this.privacyBean.setAllow(allows + "," + allow);
        }
        return this;
    }

    public PrivacyBuilder setDeny(String deny) {
        this.checkNotBuilt();
        this.privacyBean.setDeny(deny);
        return this;
    }

    public PrivacyBuilder setDeny(List<String> deny) {
        this.checkNotBuilt();
        this.privacyBean.setDeny(z_F4JInternalStringUtil.join(deny.toArray(new String[deny.size()])));
        return this;
    }

    public PrivacyBuilder addDeny(String deny) {
        this.checkNotBuilt();
        String denys = this.privacyBean.getDeny();
        if (denys == null) {
            this.privacyBean.setDeny(deny);
        } else {
            this.privacyBean.setDeny(denys + "," + deny);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivacyBean build() {
        this.checkNotBuilt();
        try {
            PrivacyBean privacyBean = this.privacyBean;
            return privacyBean;
        }
        finally {
            this.privacyBean = null;
        }
    }

    private void checkNotBuilt() {
        if (this.privacyBean == null) {
            throw new IllegalStateException("Cannot use this builder any longer, build() has already been called");
        }
    }
}

