/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.conf;

import facebook4j.conf.Configuration;
import facebook4j.conf.ConfigurationBase;
import facebook4j.conf.PropertyConfiguration;

public final class ConfigurationBuilder {
    private ConfigurationBase configurationBean = new PropertyConfiguration();

    public ConfigurationBuilder setUseSSL(boolean useSSL) {
        this.checkNotBuilt();
        this.configurationBean.setUseSSL(useSSL);
        return this;
    }

    public ConfigurationBuilder setPrettyDebugEnabled(boolean prettyDebugEnabled) {
        this.checkNotBuilt();
        this.configurationBean.setPrettyDebugEnabled(prettyDebugEnabled);
        return this;
    }

    public ConfigurationBuilder setGZIPEnabled(boolean gzipEnabled) {
        this.checkNotBuilt();
        this.configurationBean.setGZIPEnabled(gzipEnabled);
        return this;
    }

    public ConfigurationBuilder setDebugEnabled(boolean debugEnabled) {
        this.checkNotBuilt();
        this.configurationBean.setDebug(debugEnabled);
        return this;
    }

    public ConfigurationBuilder setHttpProxyHost(String httpProxyHost) {
        this.checkNotBuilt();
        this.configurationBean.setHttpProxyHost(httpProxyHost);
        return this;
    }

    public ConfigurationBuilder setHttpProxyUser(String httpProxyUser) {
        this.checkNotBuilt();
        this.configurationBean.setHttpProxyUser(httpProxyUser);
        return this;
    }

    public ConfigurationBuilder setHttpProxyPassword(String httpProxyPassword) {
        this.checkNotBuilt();
        this.configurationBean.setHttpProxyPassword(httpProxyPassword);
        return this;
    }

    public ConfigurationBuilder setHttpProxyPort(int httpProxyPort) {
        this.checkNotBuilt();
        this.configurationBean.setHttpProxyPort(httpProxyPort);
        return this;
    }

    public ConfigurationBuilder setHttpConnectionTimeout(int httpConnectionTimeout) {
        this.checkNotBuilt();
        this.configurationBean.setHttpConnectionTimeout(httpConnectionTimeout);
        return this;
    }

    public ConfigurationBuilder setHttpReadTimeout(int httpReadTimeout) {
        this.checkNotBuilt();
        this.configurationBean.setHttpReadTimeout(httpReadTimeout);
        return this;
    }

    public ConfigurationBuilder setHttpStreamingReadTimeout(int httpStreamingReadTimeout) {
        this.checkNotBuilt();
        this.configurationBean.setHttpStreamingReadTimeout(httpStreamingReadTimeout);
        return this;
    }

    public ConfigurationBuilder setHttpRetryCount(int httpRetryCount) {
        this.checkNotBuilt();
        this.configurationBean.setHttpRetryCount(httpRetryCount);
        return this;
    }

    public ConfigurationBuilder setHttpMaxTotalConnections(int httpMaxConnections) {
        this.checkNotBuilt();
        this.configurationBean.setHttpMaxTotalConnections(httpMaxConnections);
        return this;
    }

    public ConfigurationBuilder setHttpDefaultMaxPerRoute(int httpDefaultMaxPerRoute) {
        this.checkNotBuilt();
        this.configurationBean.setHttpDefaultMaxPerRoute(httpDefaultMaxPerRoute);
        return this;
    }

    public ConfigurationBuilder setHttpRetryIntervalSeconds(int httpRetryIntervalSeconds) {
        this.checkNotBuilt();
        this.configurationBean.setHttpRetryIntervalSeconds(httpRetryIntervalSeconds);
        return this;
    }

    public ConfigurationBuilder setOAuthAppId(String oAuthAppId) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthAppId(oAuthAppId);
        return this;
    }

    public ConfigurationBuilder setOAuthAppSecret(String oAuthAppSecret) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthAppSecret(oAuthAppSecret);
        return this;
    }

    public ConfigurationBuilder setOAuthAccessToken(String oAuthAccessToken) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthAccessToken(oAuthAccessToken);
        return this;
    }

    public ConfigurationBuilder setOAuthPermissions(String oAuthPermissions) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthPermissions(oAuthPermissions);
        return this;
    }

    public ConfigurationBuilder setOAuthAuthorizationURL(String oAuthAuthorizationURL) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthAuthorizationURL(oAuthAuthorizationURL);
        return this;
    }

    public ConfigurationBuilder setOAuthAccessTokenURL(String oAuthAccessTokenURL) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthAccessTokenURL(oAuthAccessTokenURL);
        return this;
    }

    public ConfigurationBuilder setRestBaseURL(String restBaseURL) {
        this.checkNotBuilt();
        this.configurationBean.setRestBaseURL(restBaseURL);
        return this;
    }

    public ConfigurationBuilder setVideoBaseURL(String videoBaseURL) {
        this.checkNotBuilt();
        this.configurationBean.setVideoBaseURL(videoBaseURL);
        return this;
    }

    public ConfigurationBuilder setClientVersion(String clientVersion) {
        this.checkNotBuilt();
        this.configurationBean.setClientVersion(clientVersion);
        return this;
    }

    public ConfigurationBuilder setClientURL(String clientURL) {
        this.checkNotBuilt();
        this.configurationBean.setClientURL(clientURL);
        return this;
    }

    public ConfigurationBuilder setJSONStoreEnabled(boolean enabled) {
        this.checkNotBuilt();
        this.configurationBean.setJSONStoreEnabled(enabled);
        return this;
    }

    public ConfigurationBuilder setMBeanEnabled(boolean enabled) {
        this.checkNotBuilt();
        this.configurationBean.setMBeanEnabled(enabled);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration build() {
        this.checkNotBuilt();
        this.configurationBean.cacheInstance();
        try {
            ConfigurationBase configurationBase = this.configurationBean;
            return configurationBase;
        }
        finally {
            this.configurationBean = null;
        }
    }

    private void checkNotBuilt() {
        if (this.configurationBean == null) {
            throw new IllegalStateException("Cannot use this builder any longer, build() has already been called");
        }
    }
}

