/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Achievement;
import facebook4j.Application;
import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.Like;
import facebook4j.PagableList;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.ApplicationJSONImpl;
import facebook4j.internal.json.CommentJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.LikeJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AchievementJSONImpl
extends FacebookResponseImpl
implements Achievement,
Serializable {
    private static final long serialVersionUID = -4720957321727049130L;
    private String id;
    private IdNameEntity from;
    private Date startTime;
    private Date endTime;
    private Date publishTime;
    private Application application;
    private Integer importance;
    private Achievement.AchievedObject achievement;
    private PagableList<Like> likes;
    private PagableList<Comment> comments;

    AchievementJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    AchievementJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            JSONObject commentsJSONObject;
            int i;
            int size;
            JSONArray list;
            JSONObject likesJSONObject;
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            }
            this.startTime = z_F4JInternalParseUtil.getISO8601Datetime("start_time", json);
            this.endTime = z_F4JInternalParseUtil.getISO8601Datetime("end_time", json);
            this.publishTime = z_F4JInternalParseUtil.getISO8601Datetime("publish_time", json);
            if (!json.isNull("application")) {
                JSONObject applicationJSONObject = json.getJSONObject("application");
                this.application = new ApplicationJSONImpl(applicationJSONObject);
            }
            if (!json.isNull("importance")) {
                this.importance = z_F4JInternalParseUtil.getPrimitiveInt("importance", json);
            }
            this.achievement = new AchievedObjectJSONImpl(json.getJSONObject("achievement"));
            if (!json.isNull("likes") && !(likesJSONObject = json.getJSONObject("likes")).isNull("data")) {
                list = likesJSONObject.getJSONArray("data");
                size = list.length();
                this.likes = new PagableListImpl<Like>(size, likesJSONObject, new Like[0]);
                for (i = 0; i < size; ++i) {
                    LikeJSONImpl like = new LikeJSONImpl(list.getJSONObject(i));
                    this.likes.add(like);
                }
            }
            if (!json.isNull("comments") && !(commentsJSONObject = json.getJSONObject("comments")).isNull("data")) {
                list = commentsJSONObject.getJSONArray("data");
                size = list.length();
                this.comments = new PagableListImpl<Comment>(size, commentsJSONObject, new Comment[0]);
                for (i = 0; i < size; ++i) {
                    CommentJSONImpl comment = new CommentJSONImpl(list.getJSONObject(i));
                    this.comments.add(comment);
                }
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public Date getPublishTime() {
        return this.publishTime;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Integer getImportance() {
        return this.importance;
    }

    @Override
    public Achievement.AchievedObject getAchievement() {
        return this.achievement;
    }

    @Override
    public PagableList<Like> getLikes() {
        return this.likes;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    static ResponseList<Achievement> createAchievementList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Achievement> achievements = new ResponseListImpl<Achievement>(size, json, new Achievement[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject achievementJSONObject = list.getJSONObject(i);
                AchievementJSONImpl achievement = new AchievementJSONImpl(achievementJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(achievement, achievementJSONObject);
                }
                achievements.add(achievement);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(achievements, list);
            }
            return achievements;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AchievementJSONImpl other = (AchievementJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "AchievementJSONImpl [id=" + this.id + ", from=" + this.from + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", publishTime=" + this.publishTime + ", application=" + this.application + ", importance=" + this.importance + ", achievement=" + this.achievement + ", likes=" + this.likes + ", comments=" + this.comments + "]";
    }

    private final class AchievedObjectJSONImpl
    implements Achievement.AchievedObject,
    Serializable {
        private static final long serialVersionUID = 5301659229411941184L;
        private String id;
        private URL url;
        private String type;
        private String title;

        AchievedObjectJSONImpl(JSONObject json) {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            this.url = z_F4JInternalParseUtil.getURL("url", json);
            this.type = z_F4JInternalParseUtil.getRawString("type", json);
            this.title = z_F4JInternalParseUtil.getRawString("title", json);
        }

        public String getId() {
            return this.id;
        }

        public URL getUrl() {
            return this.url;
        }

        public String getType() {
            return this.type;
        }

        public String getTitle() {
            return this.title;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AchievedObjectJSONImpl other = (AchievedObjectJSONImpl)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public String toString() {
            return "AchievedObjectJSONImpl [id=" + this.id + ", url=" + this.url + ", type=" + this.type + ", title=" + this.title + "]";
        }

        private AchievementJSONImpl getOuterType() {
            return AchievementJSONImpl.this;
        }
    }
}

