/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Activity;
import facebook4j.FacebookException;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ActivityJSONImpl
extends CategoryJSONImpl
implements Activity,
Serializable {
    private static final long serialVersionUID = 7801812616028452278L;

    ActivityJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res, conf);
    }

    ActivityJSONImpl(JSONObject json) throws FacebookException {
        super(json);
    }

    static ResponseList<Activity> createActivityList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Activity> activities = new ResponseListImpl<Activity>(size, json, new Activity[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject activityJSONObject = list.getJSONObject(i);
                ActivityJSONImpl activity = new ActivityJSONImpl(activityJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(activity, activityJSONObject);
                }
                activities.add(activity);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(activities, list);
            }
            return activities;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String toString() {
        return "ActivityJSONImpl [id=" + this.id + ", name=" + this.name + ", category=" + this.category + ", createdTime=" + this.createdTime + "]";
    }
}

