/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.GroupDoc;
import facebook4j.IdNameEntity;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GroupDocJSONImpl
extends FacebookResponseImpl
implements GroupDoc,
Serializable {
    private static final long serialVersionUID = -4514164915020257301L;
    private String id;
    private IdNameEntity from;
    private String subject;
    private URL icon;
    private Date updatedTime;
    private Long revision;
    private Boolean canEdit;
    private Boolean canDelete;

    GroupDocJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    GroupDocJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            }
            this.subject = z_F4JInternalParseUtil.getRawString("subject", json);
            this.icon = z_F4JInternalParseUtil.getURL("icon", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            this.revision = z_F4JInternalParseUtil.getLong("revision", json);
            this.canEdit = z_F4JInternalParseUtil.getBoolean("can_edit", json);
            this.canDelete = z_F4JInternalParseUtil.getBoolean("can_delete", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public Long getRevision() {
        return this.revision;
    }

    @Override
    public Boolean canEdit() {
        return this.canEdit;
    }

    @Override
    public Boolean canDelete() {
        return this.canDelete;
    }

    static ResponseList<GroupDoc> createGroupDocList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<GroupDoc> docs = new ResponseListImpl<GroupDoc>(size, json, new GroupDoc[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject groupDocJSONObject = list.getJSONObject(i);
                GroupDocJSONImpl doc = new GroupDocJSONImpl(groupDocJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(doc, groupDocJSONObject);
                }
                docs.add(doc);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(docs, list);
            }
            return docs;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupDocJSONImpl other = (GroupDocJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "GroupDocJSONImpl [id=" + this.id + ", from=" + this.from + ", subject=" + this.subject + ", icon=" + this.icon + ", updatedTime=" + this.updatedTime + ", revision=" + this.revision + ", canEdit=" + this.canEdit + ", canDelete=" + this.canDelete + "]";
    }
}

