/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.Link;
import facebook4j.PagableList;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CommentJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LinkJSONImpl
extends FacebookResponseImpl
implements Link,
Serializable {
    private static final long serialVersionUID = -5724838051542150714L;
    private String id;
    private IdNameEntity from;
    private String link;
    private String name;
    private PagableList<Comment> comments;
    private String description;
    private String icon;
    private String picture;
    private String message;
    private Date createdTime;
    private String type;

    LinkJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    LinkJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            }
            this.link = z_F4JInternalParseUtil.getRawString("link", json);
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            if (!json.isNull("comments")) {
                JSONObject commentsJSONObject = json.getJSONObject("comments");
                JSONArray list = commentsJSONObject.getJSONArray("data");
                int size = list.length();
                this.comments = new PagableListImpl<Comment>(size, commentsJSONObject, new Comment[0]);
                for (int i = 0; i < size; ++i) {
                    CommentJSONImpl tag = new CommentJSONImpl(list.getJSONObject(i));
                    this.comments.add(tag);
                }
            }
            this.description = z_F4JInternalParseUtil.getRawString("description", json);
            this.icon = z_F4JInternalParseUtil.getRawString("icon", json);
            this.picture = z_F4JInternalParseUtil.getRawString("picture", json);
            this.message = z_F4JInternalParseUtil.getRawString("message", json);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.type = z_F4JInternalParseUtil.getRawString("type", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public String getLink() {
        return this.link;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public String getPicture() {
        return this.picture;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public String getType() {
        return this.type;
    }

    static ResponseList<Link> createLinkList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Link> links = new ResponseListImpl<Link>(size, json, new Link[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject linkJSONObject = list.getJSONObject(i);
                LinkJSONImpl link = new LinkJSONImpl(linkJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(link, linkJSONObject);
                }
                links.add(link);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(links, list);
            }
            return links;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkJSONImpl other = (LinkJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "LinkJSONImpl [id=" + this.id + ", from=" + this.from + ", link=" + this.link + ", name=" + this.name + ", comments=" + this.comments + ", description=" + this.description + ", icon=" + this.icon + ", picture=" + this.picture + ", message=" + this.message + ", createdTime=" + this.createdTime + ", type=" + this.type + "]";
    }
}

