/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.Note;
import facebook4j.PagableList;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CommentJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NoteJSONImpl
extends FacebookResponseImpl
implements Note,
Serializable {
    private static final long serialVersionUID = -4829935468293079130L;
    private String id;
    private IdNameEntity from;
    private String subject;
    private String message;
    private PagableList<Comment> comments;
    private Date createdTime;
    private Date updatedTime;
    private URL icon;

    NoteJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    NoteJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            }
            this.subject = z_F4JInternalParseUtil.getRawString("subject", json);
            this.message = z_F4JInternalParseUtil.getRawString("message", json);
            if (!json.isNull("comments")) {
                JSONObject commentsJSONObject = json.getJSONObject("comments");
                JSONArray list = commentsJSONObject.getJSONArray("data");
                int size = list.length();
                this.comments = new PagableListImpl<Comment>(size, commentsJSONObject, new Comment[0]);
                for (int i = 0; i < size; ++i) {
                    CommentJSONImpl comment = new CommentJSONImpl(list.getJSONObject(i));
                    this.comments.add(comment);
                }
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            this.icon = z_F4JInternalParseUtil.getURL("icon", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    static ResponseList<Note> createNoteList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Note> notes = new ResponseListImpl<Note>(size, json, new Note[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject noteJSONObject = list.getJSONObject(i);
                NoteJSONImpl note = new NoteJSONImpl(noteJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(note, noteJSONObject);
                }
                notes.add(note);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(notes, list);
            }
            return notes;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NoteJSONImpl other = (NoteJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "NoteJSONImpl [id=" + this.id + ", from=" + this.from + ", subject=" + this.subject + ", message=" + this.message + ", comments=" + this.comments + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", icon=" + this.icon + "]";
    }
}

