/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Picture;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;

final class PictureJSONImpl
implements Picture,
Serializable {
    private static final long serialVersionUID = 3087810796439324798L;
    private final URL url;
    private final Boolean isSilhouette;

    PictureJSONImpl(JSONObject json) throws FacebookException {
        try {
            JSONObject pictureJSONObject = json.getJSONObject("data");
            this.url = z_F4JInternalParseUtil.getURL("url", pictureJSONObject);
            this.isSilhouette = z_F4JInternalParseUtil.getBoolean("is_silhouette", pictureJSONObject);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    PictureJSONImpl(URL url) {
        this.url = url;
        this.isSilhouette = true;
    }

    public URL getURL() {
        return this.url;
    }

    public Boolean isSilhouette() {
        return this.isSilhouette;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isSilhouette == null ? 0 : this.isSilhouette.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PictureJSONImpl other = (PictureJSONImpl)obj;
        if (this.isSilhouette == null ? other.isSilhouette != null : !this.isSilhouette.equals(other.isSilhouette)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return "PictureJSONImpl [url=" + this.url + ", isSilhouette=" + this.isSilhouette + "]";
    }
}

