/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Application;
import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.PagableList;
import facebook4j.Place;
import facebook4j.Post;
import facebook4j.Privacy;
import facebook4j.ResponseList;
import facebook4j.Tag;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.ApplicationJSONImpl;
import facebook4j.internal.json.CommentJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.PlaceJSONImpl;
import facebook4j.internal.json.PrivacyJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.json.TagJSONImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PostJSONImpl
extends FacebookResponseImpl
implements Post,
Serializable {
    private static final long serialVersionUID = 1303895381110118187L;
    private String id;
    private IdNameEntity from;
    private List<IdNameEntity> to;
    private String message;
    private List<Tag> messageTags;
    private URL picture;
    private URL link;
    private String name;
    private String caption;
    private String description;
    private URL source;
    private List<Post.Property> properties;
    private String icon;
    private List<Post.Action> actions;
    private Privacy privacy;
    private String type;
    private Integer sharesCount;
    private PagableList<IdNameEntity> likes;
    private Place place;
    private String statusType;
    private String story;
    private Map<String, Tag[]> storyTags;
    private List<IdNameEntity> withTags;
    private PagableList<Comment> comments;
    private Long objectId;
    private Application application;
    private Date createdTime;
    private Date updatedTime;

    PostJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    PostJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            JSONObject sharesJSONObject;
            int i;
            int i2;
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            }
            if (!json.isNull("to")) {
                JSONArray toJSONArray = json.getJSONObject("to").getJSONArray("data");
                this.to = new ArrayList<IdNameEntity>();
                for (i2 = 0; i2 < toJSONArray.length(); ++i2) {
                    JSONObject toJSONObject = toJSONArray.getJSONObject(i2);
                    this.to.add(new IdNameEntityJSONImpl(toJSONObject));
                }
            }
            this.message = z_F4JInternalParseUtil.getRawString("message", json);
            if (!json.isNull("message_tags")) {
                String raw = json.get("message_tags").toString();
                if (raw.startsWith("[")) {
                    JSONArray tagsJSONArray = json.getJSONArray("message_tags");
                    this.messageTags = new ArrayList<Tag>();
                    for (int i3 = 0; i3 < tagsJSONArray.length(); ++i3) {
                        JSONObject tagJSONObject = tagsJSONArray.getJSONObject(i3);
                        this.messageTags.add(new TagJSONImpl(tagJSONObject));
                    }
                } else {
                    JSONObject tagsJSONObject = json.getJSONObject("message_tags");
                    Iterator ids = tagsJSONObject.keys();
                    while (ids.hasNext()) {
                        String id = (String)ids.next();
                        JSONArray tagsJSONArray = tagsJSONObject.getJSONArray(id);
                        this.messageTags = new ArrayList<Tag>();
                        for (i = 0; i < tagsJSONArray.length(); ++i) {
                            JSONObject tagJSONObject = tagsJSONArray.getJSONObject(i);
                            this.messageTags.add(new TagJSONImpl(tagJSONObject));
                        }
                    }
                }
            }
            this.picture = z_F4JInternalParseUtil.getURL("picture", json);
            this.link = z_F4JInternalParseUtil.getURL("link", json);
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.caption = z_F4JInternalParseUtil.getRawString("caption", json);
            this.description = z_F4JInternalParseUtil.getRawString("description", json);
            this.source = z_F4JInternalParseUtil.getURL("source", json);
            if (!json.isNull("properties")) {
                JSONArray propertyJSONArray = json.getJSONArray("properties");
                this.properties = new ArrayList<Post.Property>();
                for (i2 = 0; i2 < propertyJSONArray.length(); ++i2) {
                    JSONObject propertyJSONObject = propertyJSONArray.getJSONObject(i2);
                    this.properties.add(new PropertyJSONImpl(propertyJSONObject));
                }
            }
            this.icon = z_F4JInternalParseUtil.getRawString("icon", json);
            if (!json.isNull("actions")) {
                JSONArray actionJSONArray = json.getJSONArray("actions");
                this.actions = new ArrayList<Post.Action>();
                for (i2 = 0; i2 < actionJSONArray.length(); ++i2) {
                    JSONObject actionJSONObject = actionJSONArray.getJSONObject(i2);
                    this.actions.add(new ActionJSONImpl(actionJSONObject));
                }
            }
            if (!json.isNull("privacy")) {
                JSONObject privacyJSONObject = json.getJSONObject("privacy");
                this.privacy = new PrivacyJSONImpl(privacyJSONObject);
            }
            this.type = z_F4JInternalParseUtil.getRawString("type", json);
            if (!json.isNull("shares") && !(sharesJSONObject = json.getJSONObject("shares")).isNull("count")) {
                this.sharesCount = z_F4JInternalParseUtil.getInt("count", sharesJSONObject);
            }
            if (!json.isNull("likes")) {
                JSONObject likesJSONObject = json.getJSONObject("likes");
                if (!likesJSONObject.isNull("data")) {
                    JSONArray list = likesJSONObject.getJSONArray("data");
                    int size = list.length();
                    this.likes = new PagableListImpl<IdNameEntity>(size, likesJSONObject, new IdNameEntity[0]);
                    for (int i4 = 0; i4 < size; ++i4) {
                        IdNameEntityJSONImpl like = new IdNameEntityJSONImpl(list.getJSONObject(i4));
                        this.likes.add(like);
                    }
                } else {
                    this.likes = new PagableListImpl<IdNameEntity>(1, likesJSONObject, new IdNameEntity[0]);
                }
            }
            if (!json.isNull("place")) {
                JSONObject placeJSONObject = json.getJSONObject("place");
                this.place = new PlaceJSONImpl(placeJSONObject);
            }
            this.statusType = z_F4JInternalParseUtil.getRawString("status_type", json);
            this.story = z_F4JInternalParseUtil.getRawString("story", json);
            if (!json.isNull("story_tags")) {
                JSONObject storyTagsJSONObject = json.getJSONObject("story_tags");
                this.storyTags = new HashMap<String, Tag[]>();
                Iterator keys = storyTagsJSONObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONArray storyTagsJSONArray = storyTagsJSONObject.getJSONArray(key);
                    Tag[] tags = new Tag[storyTagsJSONArray.length()];
                    for (i = 0; i < storyTagsJSONArray.length(); ++i) {
                        JSONObject tag = storyTagsJSONArray.getJSONObject(i);
                        tags[i] = new TagJSONImpl(tag);
                    }
                    this.storyTags.put(key, tags);
                }
            }
            if (!json.isNull("with_tags")) {
                JSONArray withTagsJSONArray = json.getJSONObject("with_tags").getJSONArray("data");
                this.withTags = new ArrayList<IdNameEntity>();
                for (int i5 = 0; i5 < withTagsJSONArray.length(); ++i5) {
                    JSONObject withTagJSONObject = withTagsJSONArray.getJSONObject(i5);
                    this.withTags.add(new IdNameEntityJSONImpl(withTagJSONObject));
                }
            }
            if (!json.isNull("comments")) {
                JSONObject commentsJSONObject = json.getJSONObject("comments");
                if (!commentsJSONObject.isNull("data")) {
                    JSONArray list = commentsJSONObject.getJSONArray("data");
                    int size = list.length();
                    this.comments = new PagableListImpl<Comment>(size, commentsJSONObject, new Comment[0]);
                    for (int i6 = 0; i6 < size; ++i6) {
                        CommentJSONImpl comment = new CommentJSONImpl(list.getJSONObject(i6));
                        this.comments.add(comment);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, commentsJSONObject, new Comment[0]);
                }
            }
            if (!json.isNull("object_id")) {
                this.objectId = z_F4JInternalParseUtil.getLong("object_id", json);
            }
            if (!json.isNull("application")) {
                JSONObject applicationJSONObject = json.getJSONObject("application");
                this.application = new ApplicationJSONImpl(applicationJSONObject);
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public List<IdNameEntity> getTo() {
        return this.to;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<Tag> getMessageTags() {
        return this.messageTags;
    }

    @Override
    public URL getPicture() {
        return this.picture;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public URL getSource() {
        return this.source;
    }

    @Override
    public List<Post.Property> getProperties() {
        return this.properties;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public List<Post.Action> getActions() {
        return this.actions;
    }

    @Override
    public Privacy getPrivacy() {
        return this.privacy;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Integer getSharesCount() {
        return this.sharesCount;
    }

    @Override
    public PagableList<IdNameEntity> getLikes() {
        return this.likes;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public String getStatusType() {
        return this.statusType;
    }

    @Override
    public String getStory() {
        return this.story;
    }

    @Override
    public Map<String, Tag[]> getStoryTags() {
        return this.storyTags;
    }

    @Override
    public List<IdNameEntity> getWithTags() {
        return this.withTags;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public Long getObjectId() {
        return this.objectId;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    static ResponseList<Post> createPostList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Post> posts = new ResponseListImpl<Post>(size, json, new Post[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject postJSONObject = list.getJSONObject(i);
                PostJSONImpl post = new PostJSONImpl(postJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(post, postJSONObject);
                }
                posts.add(post);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(posts, list);
            }
            return posts;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PostJSONImpl other = (PostJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "PostJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", to=" + this.to + ", message='" + this.message + '\'' + ", messageTags=" + this.messageTags + ", picture=" + this.picture + ", link=" + this.link + ", name='" + this.name + '\'' + ", caption='" + this.caption + '\'' + ", description='" + this.description + '\'' + ", source=" + this.source + ", properties=" + this.properties + ", icon='" + this.icon + '\'' + ", actions=" + this.actions + ", privacy=" + this.privacy + ", type='" + this.type + '\'' + ", sharesCount=" + this.sharesCount + ", likes=" + this.likes + ", place=" + this.place + ", statusType=" + this.statusType + ", story='" + this.story + '\'' + ", storyTags=" + this.storyTags + ", withTags=" + this.withTags + ", comments=" + this.comments + ", objectId=" + this.objectId + ", application=" + this.application + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + '}';
    }

    private class ActionJSONImpl
    implements Post.Action,
    Serializable {
        private static final long serialVersionUID = 2407371708630166786L;
        private final String name;
        private final String link;

        ActionJSONImpl(JSONObject json) throws FacebookException {
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.link = z_F4JInternalParseUtil.getRawString("link", json);
        }

        public String getName() {
            return this.name;
        }

        public String getLink() {
            return this.link;
        }

        public String toString() {
            return "Post.ActionJSONImpl [name=" + this.name + ", link=" + this.link + "]";
        }
    }

    private class PropertyJSONImpl
    implements Post.Property,
    Serializable {
        private static final long serialVersionUID = -2917519371927503549L;
        private final String name;
        private final String text;
        private final String href;

        PropertyJSONImpl(JSONObject json) {
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.text = z_F4JInternalParseUtil.getRawString("text", json);
            this.href = z_F4JInternalParseUtil.getRawString("href", json);
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public String getHref() {
            return this.href;
        }

        public String toString() {
            return "Post.PropertyJSONImpl [name=" + this.name + ", text=" + this.text + ", href=" + this.href + "]";
        }
    }
}

