/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Privacy;
import facebook4j.PrivacyType;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PrivacyJSONImpl
implements Privacy,
Serializable {
    private static final long serialVersionUID = -3272219269372534734L;
    private PrivacyType value;
    private PrivacyType friends;
    private List<String> networks;
    private List<String> allow;
    private List<String> deny;
    private List<String> description;

    public PrivacyJSONImpl(JSONObject json) throws FacebookException {
        this.value = PrivacyType.getInstance(z_F4JInternalParseUtil.getRawString("value", json));
        this.friends = PrivacyType.getInstance(z_F4JInternalParseUtil.getRawString("friends", json));
        if (!json.isNull("networks")) {
            String[] networksArray = z_F4JInternalParseUtil.getRawString("networks", json).split(",");
            this.networks = new ArrayList<String>(networksArray.length);
            for (String network : networksArray) {
                this.networks.add(network);
            }
        }
        if (!json.isNull("allow")) {
            String[] allowArray = z_F4JInternalParseUtil.getRawString("allow", json).split(",");
            this.allow = new ArrayList<String>(allowArray.length);
            for (String _allow : allowArray) {
                this.allow.add(_allow);
            }
        }
        if (!json.isNull("deny")) {
            String[] denyArray = z_F4JInternalParseUtil.getRawString("deny", json).split(",");
            this.deny = new ArrayList<String>(denyArray.length);
            for (String _deny : denyArray) {
                this.deny.add(_deny);
            }
        }
        if (!json.isNull("description")) {
            String[] descriptionArray = z_F4JInternalParseUtil.getRawString("description", json).split(",");
            this.description = new ArrayList<String>(descriptionArray.length);
            for (String _description : descriptionArray) {
                this.description.add(_description);
            }
        }
    }

    @Override
    public PrivacyType getValue() {
        return this.value;
    }

    @Override
    public PrivacyType getFriends() {
        return this.friends;
    }

    @Override
    public List<String> getNetworks() {
        return this.networks;
    }

    @Override
    public List<String> getAllow() {
        return this.allow;
    }

    @Override
    public List<String> getDeny() {
        return this.deny;
    }

    @Override
    public List<String> getDescription() {
        return this.description;
    }

    public String toString() {
        return "PrivacyJSONImpl [value=" + (Object)((Object)this.value) + ", friends=" + (Object)((Object)this.friends) + ", networks=" + this.networks + ", allow=" + this.allow + ", deny=" + this.deny + ", description=" + this.description + "]";
    }
}

