/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.ResponseList;
import facebook4j.Tag;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TagJSONImpl
extends FacebookResponseImpl
implements Tag,
Serializable {
    private static final long serialVersionUID = -947248601368391860L;
    private String id;
    private String name;
    private Integer offset;
    private Integer length;
    private String type;
    private Integer x;
    private Integer y;
    private Date createdTime;

    TagJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    TagJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        this.id = z_F4JInternalParseUtil.getRawString("id", json);
        this.name = z_F4JInternalParseUtil.getRawString("name", json);
        this.offset = !json.isNull("offset") ? Integer.valueOf(z_F4JInternalParseUtil.getPrimitiveInt("offset")) : null;
        this.length = !json.isNull("length") ? Integer.valueOf(z_F4JInternalParseUtil.getPrimitiveInt("length", json)) : null;
        this.type = z_F4JInternalParseUtil.getRawString("type", json);
        this.x = !json.isNull("x") ? Integer.valueOf(z_F4JInternalParseUtil.getPrimitiveInt("x", json)) : null;
        this.y = !json.isNull("y") ? Integer.valueOf(z_F4JInternalParseUtil.getPrimitiveInt("y", json)) : null;
        this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getOffset() {
        return this.offset;
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Integer getX() {
        return this.x;
    }

    @Override
    public Integer getY() {
        return this.y;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    static ResponseList<Tag> createTagList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Tag> tags = new ResponseListImpl<Tag>(size, json, new Tag[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject tagJSONObject = list.getJSONObject(i);
                TagJSONImpl tag = new TagJSONImpl(tagJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(tag, tagJSONObject);
                }
                tags.add(tag);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(tags, list);
            }
            return tags;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagJSONImpl other = (TagJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "TagJSONImpl [id=" + this.id + ", name=" + this.name + ", offset=" + this.offset + ", length=" + this.length + ", type=" + this.type + "]";
    }
}

