/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.IdNameEntity;
import facebook4j.PagableList;
import facebook4j.ResponseList;
import facebook4j.Video;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CommentJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VideoJSONImpl
extends FacebookResponseImpl
implements Video,
Serializable {
    private static final long serialVersionUID = -7490753250841393087L;
    private String id;
    private IdNameEntity from;
    private List<IdNameEntity> tags;
    private String name;
    private String description;
    private URL picture;
    private String embedHtml;
    private URL icon;
    private URL source;
    private Date createdTime;
    private Date updatedTime;
    private PagableList<Comment> comments;

    VideoJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    VideoJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            }
            if (!json.isNull("tags")) {
                JSONArray tagsJSONArray = json.getJSONArray("tags");
                for (int i = 0; i < tagsJSONArray.length(); ++i) {
                    this.tags.add(new IdNameEntityJSONImpl(tagsJSONArray.getJSONObject(i)));
                }
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.description = z_F4JInternalParseUtil.getRawString("description", json);
            this.picture = z_F4JInternalParseUtil.getURL("picture", json);
            this.embedHtml = z_F4JInternalParseUtil.getRawString("embed_html", json);
            this.icon = z_F4JInternalParseUtil.getURL("icon", json);
            this.source = z_F4JInternalParseUtil.getURL("source", json);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            if (!json.isNull("comments")) {
                JSONArray commentJSONArray = json.getJSONObject("comments").getJSONArray("data");
                int size = commentJSONArray.length();
                this.comments = new PagableListImpl<Comment>(size, json.getJSONObject("comments"), new Comment[0]);
                for (int i = 0; i < size; ++i) {
                    CommentJSONImpl comment = new CommentJSONImpl(commentJSONArray.getJSONObject(i));
                    this.comments.add(comment);
                }
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public List<IdNameEntity> getTags() {
        return this.tags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public URL getPicture() {
        return this.picture;
    }

    @Override
    public String getEmbedHtml() {
        return this.embedHtml;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    @Override
    public URL getSource() {
        return this.source;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    static ResponseList<Video> createVideoList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Video> videos = new ResponseListImpl<Video>(size, json, new Video[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject videoJSONObject = list.getJSONObject(i);
                VideoJSONImpl video = new VideoJSONImpl(videoJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(video, videoJSONObject);
                }
                videos.add(video);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(videos, list);
            }
            return videos;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VideoJSONImpl other = (VideoJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "VideoJSONImpl [id=" + this.id + ", from=" + this.from + ", tags=" + this.tags + ", name=" + this.name + ", description=" + this.description + ", picture=" + this.picture + ", embedHtml=" + this.embedHtml + ", icon=" + this.icon + ", source=" + this.source + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", comments=" + this.comments + "]";
    }
}

