/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.util;

import facebook4j.FacebookException;
import facebook4j.internal.http.HTMLEntity;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class z_F4JInternalParseUtil {
    private static final String ISO8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String ISO8601_DATE_FORMAT_WITHOUT_TZ = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String ISO8601_DATE_FORMAT_WITHOUT_TIME = "yyyy-MM-dd";
    private static ThreadLocal<Map<String, SimpleDateFormat>> formatMap = new ThreadLocal<Map<String, SimpleDateFormat>>(){

        @Override
        protected Map<String, SimpleDateFormat> initialValue() {
            return new HashMap<String, SimpleDateFormat>();
        }
    };

    private z_F4JInternalParseUtil() {
        throw new AssertionError();
    }

    public static String getUnescapedString(String str, JSONObject json) {
        return HTMLEntity.unescape(z_F4JInternalParseUtil.getRawString(str, json));
    }

    public static String getRawString(String name, JSONObject json) {
        try {
            if (json.isNull(name)) {
                return null;
            }
            return json.getString(name);
        }
        catch (JSONException jsone) {
            return null;
        }
    }

    public static String getURLDecodedString(String name, JSONObject json) {
        String returnValue = z_F4JInternalParseUtil.getRawString(name, json);
        if (returnValue != null) {
            try {
                returnValue = URLDecoder.decode(returnValue, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public static int getPrimitiveInt(String name, JSONObject json) {
        return z_F4JInternalParseUtil.getPrimitiveInt(z_F4JInternalParseUtil.getRawString(name, json));
    }

    public static int getPrimitiveInt(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return -1;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static Integer getInt(String name, JSONObject json) {
        return z_F4JInternalParseUtil.getInt(z_F4JInternalParseUtil.getRawString(name, json));
    }

    public static Integer getInt(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return null;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static long getPrimitiveLong(String name, JSONObject json) {
        return z_F4JInternalParseUtil.getPrimitiveLong(z_F4JInternalParseUtil.getRawString(name, json));
    }

    public static long getPrimitiveLong(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return -1L;
        }
        return Long.valueOf(str);
    }

    public static Long getLong(String name, JSONObject json) {
        return z_F4JInternalParseUtil.getLong(z_F4JInternalParseUtil.getRawString(name, json));
    }

    public static Long getLong(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return null;
        }
        return Long.valueOf(str);
    }

    public static double getDouble(String name, JSONObject json) {
        String str2 = z_F4JInternalParseUtil.getRawString(name, json);
        if (null == str2 || "".equals(str2) || "null".equals(str2)) {
            return -1.0;
        }
        return Double.valueOf(str2);
    }

    public static boolean getBoolean(String name, JSONObject json) {
        String str = z_F4JInternalParseUtil.getRawString(name, json);
        if (null == str || "null".equals(str)) {
            return false;
        }
        return Boolean.valueOf(str);
    }

    public static boolean getFlag(String name, JSONObject json) {
        int flag = z_F4JInternalParseUtil.getPrimitiveInt(name, json);
        return flag == 1;
    }

    public static Date getISO8601Datetime(String name, JSONObject json) throws FacebookException {
        String dateString = z_F4JInternalParseUtil.getRawString(name, json);
        if (dateString == null) {
            return null;
        }
        return z_F4JInternalParseUtil.parseISO8601Date(dateString);
    }

    private static Date parseISO8601Date(String dateString) {
        try {
            return new SimpleDateFormat(ISO8601_DATE_FORMAT).parse(dateString);
        }
        catch (ParseException e1) {
            try {
                return new SimpleDateFormat(ISO8601_DATE_FORMAT_WITHOUT_TZ).parse(dateString);
            }
            catch (ParseException e2) {
                try {
                    return new SimpleDateFormat(ISO8601_DATE_FORMAT_WITHOUT_TIME).parse(dateString);
                }
                catch (ParseException e3) {
                    return null;
                }
            }
        }
    }

    public static URL getURL(String name, JSONObject json) {
        if (json.isNull(name)) {
            return null;
        }
        try {
            return new URL(z_F4JInternalParseUtil.getRawString(name, json));
        }
        catch (MalformedURLException urle) {
            return null;
        }
    }

    public static Map<String, String> getStringMap(String name, JSONObject json) throws FacebookException {
        if (json.isNull(name)) {
            return null;
        }
        try {
            JSONObject jsonObject = json.getJSONObject(name);
            HashMap<String, String> result = new HashMap<String, String>();
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                result.put(key, jsonObject.getString(key));
            }
            return result;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    public static Map<String, Boolean> getBooleanMap(String name, JSONObject json) throws FacebookException {
        if (json.isNull(name)) {
            return null;
        }
        try {
            JSONObject jsonObject = json.getJSONObject(name);
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                result.put(key, jsonObject.getBoolean(key));
            }
            return result;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    public static List<String> getStringList(String name, JSONObject json) throws FacebookException {
        if (json.isNull(name)) {
            return null;
        }
        try {
            JSONArray jsonArray = json.getJSONArray(name);
            int size = jsonArray.length();
            ArrayList<String> result = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                result.add(jsonArray.getString(i));
            }
            return result;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }
}

