/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.util;

import facebook4j.FacebookException;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class z_F4JInternalParseUtil {
    private static final String ISO8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String ISO8601_DATE_FORMAT_WITHOUT_TZ = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String ISO8601_DATE_FORMAT_WITHOUT_TIME = "yyyy-MM-dd";

    private z_F4JInternalParseUtil() {
        throw new AssertionError();
    }

    public static String getRawString(String name, JSONObject json) {
        try {
            if (json.isNull(name)) {
                return null;
            }
            return json.getString(name);
        }
        catch (JSONException jsone) {
            return null;
        }
    }

    public static int getPrimitiveInt(String name, JSONObject json) {
        return z_F4JInternalParseUtil.getPrimitiveInt(z_F4JInternalParseUtil.getRawString(name, json));
    }

    public static int getPrimitiveInt(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return -1;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static Integer getInt(String name, JSONObject json) {
        return z_F4JInternalParseUtil.getInt(z_F4JInternalParseUtil.getRawString(name, json));
    }

    public static Integer getInt(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return null;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static long getPrimitiveLong(String name, JSONObject json) {
        return z_F4JInternalParseUtil.getPrimitiveLong(z_F4JInternalParseUtil.getRawString(name, json));
    }

    public static long getPrimitiveLong(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return -1L;
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public static Long getLong(String name, JSONObject json) {
        return z_F4JInternalParseUtil.getLong(z_F4JInternalParseUtil.getRawString(name, json));
    }

    public static Long getLong(String str) {
        if (null == str || "".equals(str) || "null".equals(str)) {
            return null;
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Double getDouble(String name, JSONObject json) {
        String str2 = z_F4JInternalParseUtil.getRawString(name, json);
        if (null == str2 || "".equals(str2) || "null".equals(str2)) {
            return null;
        }
        return Double.valueOf(str2);
    }

    public static Boolean getBoolean(String name, JSONObject json) {
        String str = z_F4JInternalParseUtil.getRawString(name, json);
        if (null == str || "null".equals(str)) {
            return null;
        }
        return Boolean.valueOf(str);
    }

    public static boolean getFlag(String name, JSONObject json) {
        int flag = z_F4JInternalParseUtil.getPrimitiveInt(name, json);
        return flag == 1;
    }

    public static Date getISO8601Datetime(String name, JSONObject json) throws FacebookException {
        String dateString = z_F4JInternalParseUtil.getRawString(name, json);
        if (dateString == null) {
            return null;
        }
        if (json.isNull("timezone")) {
            return z_F4JInternalParseUtil.parseISO8601Date(dateString);
        }
        TimeZone timezone = z_F4JInternalParseUtil.getTimeZone("timezone", json);
        return z_F4JInternalParseUtil.parseISO8601Date(dateString, timezone);
    }

    private static Date parseISO8601Date(String dateString) {
        return z_F4JInternalParseUtil.parseISO8601Date(dateString, TimeZone.getTimeZone("UTC"));
    }

    private static Date parseISO8601Date(String dateString, TimeZone timezone) {
        try {
            return new SimpleDateFormat(ISO8601_DATE_FORMAT).parse(dateString);
        }
        catch (ParseException e1) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(ISO8601_DATE_FORMAT_WITHOUT_TZ);
                sdf.setTimeZone(timezone);
                return sdf.parse(dateString);
            }
            catch (ParseException e2) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(ISO8601_DATE_FORMAT_WITHOUT_TIME);
                    sdf.setTimeZone(timezone);
                    return sdf.parse(dateString);
                }
                catch (ParseException e3) {
                    return null;
                }
            }
        }
    }

    public static URL getURL(String name, JSONObject json) {
        if (json.isNull(name)) {
            return null;
        }
        try {
            return new URL(z_F4JInternalParseUtil.getRawString(name, json));
        }
        catch (MalformedURLException urle) {
            return null;
        }
    }

    public static URI getURI(String name, JSONObject json) {
        if (json.isNull(name)) {
            return null;
        }
        try {
            return new URI(z_F4JInternalParseUtil.getRawString(name, json));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static TimeZone getTimeZone(String name, JSONObject json) {
        if (json.isNull(name)) {
            return null;
        }
        return TimeZone.getTimeZone(z_F4JInternalParseUtil.getRawString(name, json));
    }

    public static Map<String, String> getStringMap(String name, JSONObject json) throws FacebookException {
        if (json.isNull(name)) {
            return Collections.emptyMap();
        }
        try {
            JSONObject jsonObject = json.getJSONObject(name);
            HashMap<String, String> result = new HashMap<String, String>();
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                result.put(key, jsonObject.getString(key));
            }
            return result;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    public static Map<String, Long> getLongMap(String name, JSONObject json) throws FacebookException {
        if (json.isNull(name)) {
            return Collections.emptyMap();
        }
        try {
            JSONObject jsonObject = json.getJSONObject(name);
            HashMap<String, Long> result = new HashMap<String, Long>();
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                result.put(key, jsonObject.getLong(key));
            }
            return result;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    public static Map<String, Boolean> getBooleanMap(String name, JSONObject json) throws FacebookException {
        if (json.isNull(name)) {
            return Collections.emptyMap();
        }
        try {
            JSONObject jsonObject = json.getJSONObject(name);
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                result.put(key, jsonObject.getBoolean(key));
            }
            return result;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    public static List<String> getStringList(String name, JSONObject json) throws FacebookException {
        if (json.isNull(name)) {
            return Collections.emptyList();
        }
        try {
            JSONArray jsonArray = json.getJSONArray(name);
            int size = jsonArray.length();
            ArrayList<String> result = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                result.add(jsonArray.getString(i));
            }
            return result;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    public static boolean isJSONObject(String name, JSONObject json) {
        try {
            Object object = json.get(name);
            return object instanceof JSONObject;
        }
        catch (JSONException e) {
            return false;
        }
    }
}

