/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.Account;
import facebook4j.Achievement;
import facebook4j.Activity;
import facebook4j.Admin;
import facebook4j.Album;
import facebook4j.AlbumUpdate;
import facebook4j.BackdatingPostUpdate;
import facebook4j.BatchRequest;
import facebook4j.BatchRequests;
import facebook4j.BatchResponse;
import facebook4j.BatchResponseImpl;
import facebook4j.Book;
import facebook4j.Checkin;
import facebook4j.CheckinUpdate;
import facebook4j.Comment;
import facebook4j.Domain;
import facebook4j.Event;
import facebook4j.EventUpdate;
import facebook4j.Facebook;
import facebook4j.FacebookAPIMonitor;
import facebook4j.FacebookBaseImpl;
import facebook4j.FacebookException;
import facebook4j.Family;
import facebook4j.Friend;
import facebook4j.FriendRequest;
import facebook4j.Friendlist;
import facebook4j.Game;
import facebook4j.GeoLocation;
import facebook4j.Group;
import facebook4j.GroupDoc;
import facebook4j.GroupMember;
import facebook4j.InboxResponseList;
import facebook4j.Insight;
import facebook4j.Interest;
import facebook4j.Like;
import facebook4j.Link;
import facebook4j.Location;
import facebook4j.Media;
import facebook4j.Message;
import facebook4j.Milestone;
import facebook4j.MilestoneUpdate;
import facebook4j.Movie;
import facebook4j.Music;
import facebook4j.Note;
import facebook4j.Notification;
import facebook4j.Offer;
import facebook4j.OfferUpdate;
import facebook4j.Page;
import facebook4j.PageCoverUpdate;
import facebook4j.PagePhotoUpdate;
import facebook4j.PageSetting;
import facebook4j.PageSettingUpdate;
import facebook4j.PageUpdate;
import facebook4j.Paging;
import facebook4j.Permission;
import facebook4j.Photo;
import facebook4j.PhotoUpdate;
import facebook4j.PictureSize;
import facebook4j.Place;
import facebook4j.Poke;
import facebook4j.Post;
import facebook4j.PostUpdate;
import facebook4j.Question;
import facebook4j.QuestionUpdate;
import facebook4j.QuestionVotes;
import facebook4j.RSVPStatus;
import facebook4j.RawAPIResponse;
import facebook4j.RawAPIResponseImpl;
import facebook4j.Reading;
import facebook4j.ResponseList;
import facebook4j.Score;
import facebook4j.Subscribedto;
import facebook4j.Subscriber;
import facebook4j.Tab;
import facebook4j.TabUpdate;
import facebook4j.Tag;
import facebook4j.TagUpdate;
import facebook4j.Tagged;
import facebook4j.Television;
import facebook4j.TestUser;
import facebook4j.User;
import facebook4j.Video;
import facebook4j.VideoUpdate;
import facebook4j.api.AccountMethods;
import facebook4j.api.ActivityMethods;
import facebook4j.api.AlbumMethods;
import facebook4j.api.BatchRequestsMethods;
import facebook4j.api.CheckinMethods;
import facebook4j.api.CommentMethods;
import facebook4j.api.DomainMethods;
import facebook4j.api.EventMethods;
import facebook4j.api.FQLMethods;
import facebook4j.api.FamilyMethods;
import facebook4j.api.FavoriteMethods;
import facebook4j.api.FriendMethods;
import facebook4j.api.GameMethods;
import facebook4j.api.GroupMethods;
import facebook4j.api.InsightMethods;
import facebook4j.api.LikeMethods;
import facebook4j.api.LinkMethods;
import facebook4j.api.LocationMethods;
import facebook4j.api.MessageMethods;
import facebook4j.api.NoteMethods;
import facebook4j.api.NotificationMethods;
import facebook4j.api.PageMethods;
import facebook4j.api.PermissionMethods;
import facebook4j.api.PhotoMethods;
import facebook4j.api.PokeMethods;
import facebook4j.api.PostMethods;
import facebook4j.api.QuestionMethods;
import facebook4j.api.RawAPIMethods;
import facebook4j.api.SearchMethods;
import facebook4j.api.SubscribeMethods;
import facebook4j.api.TestUserMethods;
import facebook4j.api.UserMethods;
import facebook4j.api.VideoMethods;
import facebook4j.auth.Authorization;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpParameter;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import facebook4j.internal.util.z_F4JInternalStringUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FacebookImpl
extends FacebookBaseImpl
implements Facebook {
    private static final long serialVersionUID = 6277119018105563020L;

    FacebookImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
    }

    private String buildEndpoint(String id) {
        return this.buildEndpoint(id, null, null);
    }

    private String buildEndpoint(String id, Reading reading) {
        return this.buildEndpoint(id, null, reading);
    }

    private String buildEndpoint(String id, String connection) {
        return this.buildEndpoint(id, connection, null);
    }

    private String buildEndpoint(String id, String connection, Reading reading) {
        StringBuilder url = new StringBuilder().append(this.conf.getRestBaseURL() + id).append(connection == null ? "" : "/" + connection).append(reading == null ? "" : "?" + reading.getQuery());
        return url.toString();
    }

    private String buildEndpoint(String path, Map<String, String> parameters) {
        StringBuilder url = new StringBuilder();
        url.append(this.conf.getRestBaseURL() + path);
        if (parameters != null && parameters.size() > 0) {
            url.append("?");
            int i = 0;
            for (String k : parameters.keySet()) {
                if (i > 0) {
                    url.append("&");
                }
                try {
                    url.append(URLEncoder.encode(k, "UTF-8")).append("=").append(URLEncoder.encode(parameters.get(k), "UTF-8"));
                }
                catch (UnsupportedEncodingException ignore) {
                    // empty catch block
                }
                ++i;
            }
        }
        return url.toString();
    }

    private String buildVideoEndpoint(String id, String connection) {
        return this.buildVideoEndpoint(id, connection, null);
    }

    private String buildVideoEndpoint(String id, String connection, Reading reading) {
        StringBuilder url = new StringBuilder().append(this.conf.getVideoBaseURL() + id).append(connection == null ? "" : "/" + connection).append(reading == null ? "" : "?" + reading.getQuery());
        return url.toString();
    }

    private String buildSearchEndpoint(String query, String objectType, Reading reading) {
        String q = null;
        if (query != null) {
            q = HttpParameter.encode(query);
        }
        StringBuilder url = new StringBuilder().append(this.buildEndpoint("search")).append(objectType == null ? "" : "?type=" + objectType).append(q == null ? "" : (objectType == null ? "?q=" + q : "&q=" + q)).append(reading == null ? "" : "&" + reading.getQuery());
        return url.toString();
    }

    @Override
    public User getMe() throws FacebookException {
        return this.getMe(null);
    }

    @Override
    public User getMe(Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        User user = this.factory.createUser(this.get(this.buildEndpoint("me", reading)));
        return user;
    }

    @Override
    public User getUser(String userId) throws FacebookException {
        return this.getUser(userId, null);
    }

    @Override
    public User getUser(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        User user = this.factory.createUser(this.get(this.buildEndpoint(userId, reading)));
        return user;
    }

    @Override
    public URL getPictureURL() throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.getPictureURL("me");
    }

    @Override
    public URL getPictureURL(PictureSize size) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.getPictureURL("me", size);
    }

    @Override
    public URL getPictureURL(int width, int height) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.getPictureURL("me", width, height);
    }

    @Override
    public URL getPictureURL(String userId) throws FacebookException {
        return this.getPictureURL(userId, null);
    }

    @Override
    public URL getPictureURL(String userId, PictureSize size) throws FacebookException {
        return this._getPictureURL(userId, size);
    }

    @Override
    public URL getPictureURL(String userId, int width, int height) throws FacebookException {
        return this._getPictureURL(userId, width, height);
    }

    @Override
    public URL getSSLPictureURL() throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.getSSLPictureURL("me");
    }

    @Override
    public URL getSSLPictureURL(PictureSize size) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.getSSLPictureURL("me", size);
    }

    @Override
    public URL getSSLPictureURL(String userId) throws FacebookException {
        return this.getSSLPictureURL(userId, null);
    }

    @Override
    public URL getSSLPictureURL(String userId, PictureSize size) throws FacebookException {
        return this._getSSLPictureURL(userId, size);
    }

    @Override
    public List<User> getUsers(String ... ids) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createUserArray(this.get(this.conf.getRestBaseURL(), new HttpParameter[]{new HttpParameter("ids", z_F4JInternalStringUtil.join(ids))}));
    }

    @Override
    public ResponseList<Account> getAccounts() throws FacebookException {
        return this.getAccounts("me", null);
    }

    @Override
    public ResponseList<Account> getAccounts(Reading reading) throws FacebookException {
        return this.getAccounts("me", reading);
    }

    @Override
    public ResponseList<Account> getAccounts(String userId) throws FacebookException {
        return this.getAccounts(userId, null);
    }

    @Override
    public ResponseList<Account> getAccounts(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createAccountList(this.get(this.buildEndpoint(userId, "accounts", reading)));
    }

    @Override
    public ResponseList<Achievement> getAchievements() throws FacebookException {
        return this.getAchievements("me", null);
    }

    @Override
    public ResponseList<Achievement> getAchievements(Reading reading) throws FacebookException {
        return this.getAchievements("me", reading);
    }

    @Override
    public ResponseList<Achievement> getAchievements(String userId) throws FacebookException {
        return this.getAchievements(userId, null);
    }

    @Override
    public ResponseList<Achievement> getAchievements(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createAchievementList(this.get(this.buildEndpoint(userId, "achievements", reading)));
    }

    @Override
    public String postAchievement(URL achievementURL) throws FacebookException {
        return this.postAchievement("me", achievementURL);
    }

    @Override
    public String postAchievement(String userId, URL achievementURL) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(userId, "achievements"), new HttpParameter[]{new HttpParameter("achievement", achievementURL.toString())}).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public boolean deleteAchievement(URL achievementURL) throws FacebookException {
        return this.deleteAchievement("me", achievementURL);
    }

    @Override
    public boolean deleteAchievement(String userId, URL achievementURL) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(userId, "achievements"), new HttpParameter[]{new HttpParameter("achievement", achievementURL.toString())});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Activity> getActivities() throws FacebookException {
        return this.getActivities("me", null);
    }

    @Override
    public ResponseList<Activity> getActivities(Reading reading) throws FacebookException {
        return this.getActivities("me", reading);
    }

    @Override
    public ResponseList<Activity> getActivities(String userId) throws FacebookException {
        return this.getActivities(userId, null);
    }

    @Override
    public ResponseList<Activity> getActivities(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createActivityList(this.get(this.buildEndpoint(userId, "activities", reading)));
    }

    @Override
    public ResponseList<Album> getAlbums() throws FacebookException {
        return this.getAlbums("me", null);
    }

    @Override
    public ResponseList<Album> getAlbums(Reading reading) throws FacebookException {
        return this.getAlbums("me", reading);
    }

    @Override
    public ResponseList<Album> getAlbums(String id) throws FacebookException {
        return this.getAlbums(id, null);
    }

    @Override
    public ResponseList<Album> getAlbums(String id, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createAlbumList(this.get(this.buildEndpoint(id, "albums", reading)));
    }

    @Override
    public Album getAlbum(String albumId) throws FacebookException {
        return this.getAlbum(albumId, null);
    }

    @Override
    public Album getAlbum(String albumId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createAlbum(this.get(this.buildEndpoint(albumId, reading)));
    }

    @Override
    public String createAlbum(AlbumUpdate albumUpdate) throws FacebookException {
        return this.createAlbum("me", albumUpdate);
    }

    @Override
    public String createAlbum(String userId, AlbumUpdate albumUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(userId, "albums"), albumUpdate.asHttpParameterArray()).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public ResponseList<Photo> getAlbumPhotos(String albumId) throws FacebookException {
        return this.getAlbumPhotos(albumId, null);
    }

    @Override
    public ResponseList<Photo> getAlbumPhotos(String albumId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPhotoList(this.get(this.buildEndpoint(albumId, "photos", reading)));
    }

    @Override
    public String addAlbumPhoto(String albumId, Media source) throws FacebookException {
        return this.addAlbumPhoto(albumId, source, null);
    }

    @Override
    public String addAlbumPhoto(String albumId, Media source, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        httpParams.add(source.asHttpParameter("source"));
        if (message != null) {
            httpParams.add(new HttpParameter("message", message));
        }
        JSONObject json = this.post(this.buildEndpoint(albumId, "photos"), httpParams.toArray(new HttpParameter[httpParams.size()])).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public ResponseList<Comment> getAlbumComments(String albumId) throws FacebookException {
        return this.getAlbumComments(albumId, null);
    }

    @Override
    public ResponseList<Comment> getAlbumComments(String albumId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(albumId, reading);
    }

    @Override
    public String commentAlbum(String albumId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(albumId, message);
    }

    @Override
    public ResponseList<Like> getAlbumLikes(String albumId) throws FacebookException {
        return this.getAlbumLikes(albumId, null);
    }

    @Override
    public ResponseList<Like> getAlbumLikes(String albumId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLikeList(this.get(this.buildEndpoint(albumId, "likes", reading)));
    }

    @Override
    public boolean likeAlbum(String albumId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(albumId);
    }

    @Override
    public boolean unlikeAlbum(String albumId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(albumId);
    }

    @Override
    public URL getAlbumCoverPhoto(String albumId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.get(this.buildEndpoint(albumId, "picture"));
        try {
            return new URL(res.getResponseHeader("Location"));
        }
        catch (MalformedURLException urle) {
            throw new FacebookException(urle.getMessage(), urle);
        }
    }

    @Override
    public ResponseList<Book> getBooks() throws FacebookException {
        return this.getBooks("me", null);
    }

    @Override
    public ResponseList<Book> getBooks(Reading reading) throws FacebookException {
        return this.getBooks("me", reading);
    }

    @Override
    public ResponseList<Book> getBooks(String userId) throws FacebookException {
        return this.getBooks(userId, null);
    }

    @Override
    public ResponseList<Book> getBooks(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createBookList(this.get(this.buildEndpoint(userId, "books", reading)));
    }

    @Override
    public ResponseList<Checkin> getCheckins() throws FacebookException {
        return this.getCheckins("me", null);
    }

    @Override
    public ResponseList<Checkin> getCheckins(Reading reading) throws FacebookException {
        return this.getCheckins("me", reading);
    }

    @Override
    public ResponseList<Checkin> getCheckins(String id) throws FacebookException {
        return this.getCheckins(id, null);
    }

    @Override
    public ResponseList<Checkin> getCheckins(String id, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createCheckinList(this.get(this.buildEndpoint(id, "checkins", reading)));
    }

    @Override
    public String checkin(CheckinUpdate checkinUpdate) throws FacebookException {
        return this.checkin("me", checkinUpdate);
    }

    @Override
    public String checkin(String userId, CheckinUpdate checkinUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(userId, "checkins"), checkinUpdate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public Checkin getCheckin(String checkinId) throws FacebookException {
        return this.getCheckin(checkinId, null);
    }

    @Override
    public Checkin getCheckin(String checkinId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createCheckin(this.get(this.buildEndpoint(checkinId, reading)));
    }

    @Override
    public ResponseList<Comment> getCheckinComments(String checkinId) throws FacebookException {
        return this.getCheckinComments(checkinId, null);
    }

    @Override
    public ResponseList<Comment> getCheckinComments(String checkinId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(checkinId, reading);
    }

    @Override
    public String commentCheckin(String checkinId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(checkinId, message);
    }

    @Override
    public ResponseList<Like> getCheckinLikes(String checkinId) throws FacebookException {
        return this.getCheckinLikes(checkinId, null);
    }

    @Override
    public ResponseList<Like> getCheckinLikes(String checkinId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLikeList(this.get(this.buildEndpoint(checkinId, "likes", reading)));
    }

    @Override
    public boolean likeCheckin(String checkinId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(checkinId);
    }

    @Override
    public boolean unlikeCheckin(String checkinId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(checkinId);
    }

    @Override
    public Domain getDomain(String domainId) throws FacebookException {
        return this.factory.createDomain(this.get(this.buildEndpoint(domainId)));
    }

    @Override
    public Domain getDomainByName(String domainName) throws FacebookException {
        return this.factory.createDomain(this.get(this.conf.getRestBaseURL(), new HttpParameter[]{new HttpParameter("domain", domainName)}));
    }

    @Override
    public List<Domain> getDomainsByName(String ... domainName) throws FacebookException {
        String domainNames = z_F4JInternalStringUtil.join(domainName);
        return this.factory.createDomainArray(this.get(this.conf.getRestBaseURL(), new HttpParameter[]{new HttpParameter("domains", domainNames)}));
    }

    @Override
    public ResponseList<Event> getEvents() throws FacebookException {
        return this.getEvents("me", null);
    }

    @Override
    public ResponseList<Event> getEvents(Reading reading) throws FacebookException {
        return this.getEvents("me", reading);
    }

    @Override
    public ResponseList<Event> getEvents(String id) throws FacebookException {
        return this.getEvents(id, null);
    }

    @Override
    public ResponseList<Event> getEvents(String id, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createEventList(this.get(this.buildEndpoint(id, "events", reading)));
    }

    @Override
    public String createEvent(EventUpdate eventUpdate) throws FacebookException {
        return this.createEvent("me", eventUpdate);
    }

    @Override
    public String createEvent(String id, EventUpdate eventUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(id, "events"), eventUpdate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public Event getEvent(String eventId) throws FacebookException {
        return this.getEvent(eventId, null);
    }

    @Override
    public Event getEvent(String eventId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.get(this.buildEndpoint(eventId, reading));
        String resStr = res.asString().trim();
        if (resStr.equals("false")) {
            return null;
        }
        return this.factory.createEvent(res);
    }

    @Override
    public boolean editEvent(String eventId, EventUpdate eventUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(eventId), eventUpdate.asHttpParameterArray());
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean deleteEvent(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(eventId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public String postEventLink(String eventId, URL link) throws FacebookException {
        return this.postEventLink(eventId, link, null);
    }

    @Override
    public String postEventLink(String eventId, URL link, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postLink(eventId, link, message);
    }

    @Override
    public String postEventStatusMessage(String eventId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postStatusMessage(eventId, message);
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusAsNoreply(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildEndpoint(eventId, "noreply")));
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusAsNoreply(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildEndpoint(eventId, "noreply/" + userId)));
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusAsInvited(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildEndpoint(eventId, "invited")));
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusAsInvited(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildEndpoint(eventId, "invited/" + userId)));
    }

    @Override
    public boolean inviteToEvent(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(eventId, "invited/" + userId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean inviteToEvent(String eventId, String[] userIds) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(eventId, "invited"), new HttpParameter[]{new HttpParameter("users", z_F4JInternalStringUtil.join(userIds))});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean uninviteFromEvent(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(eventId, "invited/" + userId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusInAttending(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildEndpoint(eventId, "attending")));
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusInAttending(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildEndpoint(eventId, "attending/" + userId)));
    }

    @Override
    public boolean rsvpEventAsAttending(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(eventId, "attending"));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusInMaybe(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildEndpoint(eventId, "maybe")));
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusInMaybe(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildEndpoint(eventId, "maybe/" + userId)));
    }

    @Override
    public boolean rsvpEventAsMaybe(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(eventId, "maybe"));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusInDeclined(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildEndpoint(eventId, "declined")));
    }

    @Override
    public ResponseList<RSVPStatus> getRSVPStatusInDeclined(String eventId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createRSVPStatusList(this.get(this.buildEndpoint(eventId, "declined/" + userId)));
    }

    @Override
    public boolean rsvpEventAsDeclined(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(eventId, "declined"));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public URL getEventPictureURL(String eventId) throws FacebookException {
        return this.getEventPictureURL(eventId, null);
    }

    @Override
    public URL getEventPictureURL(String eventId, PictureSize size) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getPictureURL(eventId, size);
    }

    @Override
    public boolean updateEventPicture(String eventId, Media source) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(eventId, "picture"), new HttpParameter[]{source.asHttpParameter("source")});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean deleteEventPicture(String eventId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(eventId, "picture"));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Photo> getEventPhotos(String eventId) throws FacebookException {
        return this.getEventPhotos(eventId, null);
    }

    @Override
    public ResponseList<Photo> getEventPhotos(String eventId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPhotoList(this.get(this.buildEndpoint(eventId, "photos", reading)));
    }

    @Override
    public String postEventPhoto(String eventId, Media source) throws FacebookException {
        return this.postEventPhoto(eventId, source, null);
    }

    @Override
    public String postEventPhoto(String eventId, Media source, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpParameter[] httpParameters = new HttpParameter[]{source.asHttpParameter("source")};
        if (message != null) {
            httpParameters = HttpParameter.merge(httpParameters, new HttpParameter[]{new HttpParameter("message", message)});
        }
        JSONObject json = this.post(this.buildEndpoint(eventId, "photos"), httpParameters).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public ResponseList<Video> getEventVideos(String eventId) throws FacebookException {
        return this.getEventVideos(eventId, null);
    }

    @Override
    public ResponseList<Video> getEventVideos(String eventId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createVideoList(this.get(this.buildEndpoint(eventId, "videos", reading)));
    }

    @Override
    public String postEventVideo(String eventId, Media source) throws FacebookException {
        return this.postEventVideo(eventId, source, null, null);
    }

    @Override
    public String postEventVideo(String eventId, Media source, String title, String description) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpParameter[] httpParameters = new HttpParameter[]{source.asHttpParameter("source")};
        if (title != null) {
            httpParameters = HttpParameter.merge(httpParameters, new HttpParameter[]{new HttpParameter("title", title)});
        }
        if (description != null) {
            httpParameters = HttpParameter.merge(httpParameters, new HttpParameter[]{new HttpParameter("description", description)});
        }
        JSONObject json = this.post(this.buildVideoEndpoint(eventId, "videos"), httpParameters).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public ResponseList<Family> getFamily() throws FacebookException {
        return this.getFamily("me", null);
    }

    @Override
    public ResponseList<Family> getFamily(Reading reading) throws FacebookException {
        return this.getFamily("me", reading);
    }

    @Override
    public ResponseList<Family> getFamily(String userId) throws FacebookException {
        return this.getFamily(userId, null);
    }

    @Override
    public ResponseList<Family> getFamily(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFamilyList(this.get(this.buildEndpoint(userId, "family", reading)));
    }

    @Override
    public ResponseList<Post> getFeed() throws FacebookException {
        return this.getFeed("me", null);
    }

    @Override
    public ResponseList<Post> getFeed(Reading reading) throws FacebookException {
        return this.getFeed("me", reading);
    }

    @Override
    public ResponseList<Post> getFeed(String id) throws FacebookException {
        return this.getFeed(id, null);
    }

    @Override
    public ResponseList<Post> getFeed(String id, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildEndpoint(id, "feed", reading)));
    }

    @Override
    public ResponseList<Post> getHome() throws FacebookException {
        return this.getHome(null);
    }

    @Override
    public ResponseList<Post> getHome(Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildEndpoint("me", "home", reading)));
    }

    @Override
    public ResponseList<Post> getPosts() throws FacebookException {
        return this.getPosts("me", null);
    }

    @Override
    public ResponseList<Post> getPosts(Reading reading) throws FacebookException {
        return this.getPosts("me", reading);
    }

    @Override
    public ResponseList<Post> getPosts(String id) throws FacebookException {
        return this.getPosts(id, null);
    }

    @Override
    public ResponseList<Post> getPosts(String id, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildEndpoint(id, "posts", reading)));
    }

    @Override
    public ResponseList<Post> getStatuses() throws FacebookException {
        return this.getStatuses("me", null);
    }

    @Override
    public ResponseList<Post> getStatuses(Reading reading) throws FacebookException {
        return this.getStatuses("me", reading);
    }

    @Override
    public ResponseList<Post> getStatuses(String id) throws FacebookException {
        return this.getStatuses(id, null);
    }

    @Override
    public ResponseList<Post> getStatuses(String id, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildEndpoint(id, "statuses", reading)));
    }

    @Override
    public Post getPost(String postId) throws FacebookException {
        return this.getPost(postId, null);
    }

    @Override
    public Post getPost(String postId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPost(this.get(this.buildEndpoint(postId, reading)));
    }

    @Override
    public boolean deletePost(String postId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(postId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Comment> getPostComments(String postId) throws FacebookException {
        return this.getPostComments(postId, null);
    }

    @Override
    public ResponseList<Comment> getPostComments(String postId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(postId, reading);
    }

    @Override
    public String commentPost(String postId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(postId, message);
    }

    @Override
    public ResponseList<Like> getPostLikes(String postId) throws FacebookException {
        return this.getPostLikes(postId, null);
    }

    @Override
    public ResponseList<Like> getPostLikes(String postId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLikeList(this.get(this.buildEndpoint(postId, "likes", reading)));
    }

    @Override
    public boolean likePost(String postId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(postId);
    }

    @Override
    public boolean unlikePost(String postId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(postId);
    }

    public ResponseList<Insight> getPostInsights(String postId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createInsightList(this.get(this.buildEndpoint(postId, "insights")));
    }

    @Override
    public String postFeed(PostUpdate postUpdate) throws FacebookException {
        return this.postFeed("me", postUpdate);
    }

    @Override
    public String postFeed(String id, PostUpdate postUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(id, "feed"), postUpdate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public String postStatusMessage(String message) throws FacebookException {
        return this.postStatusMessage("me", message);
    }

    @Override
    public String postStatusMessage(String id, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postStatusMessage(id, message);
    }

    @Override
    public ResponseList<Post> getTagged() throws FacebookException {
        return this.getTagged("me", null);
    }

    @Override
    public ResponseList<Post> getTagged(Reading reading) throws FacebookException {
        return this.getTagged("me", reading);
    }

    @Override
    public ResponseList<Post> getTagged(String userId) throws FacebookException {
        return this.getTagged(userId, null);
    }

    @Override
    public ResponseList<Post> getTagged(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildEndpoint(userId, "tagged", reading)));
    }

    @Override
    public ResponseList<Friendlist> getFriendlists() throws FacebookException {
        return this.getFriendlists("me", null);
    }

    @Override
    public ResponseList<Friendlist> getFriendlists(Reading reading) throws FacebookException {
        return this.getFriendlists("me", reading);
    }

    @Override
    public ResponseList<Friendlist> getFriendlists(String userId) throws FacebookException {
        return this.getFriendlists(userId, null);
    }

    @Override
    public ResponseList<Friendlist> getFriendlists(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendlistList(this.get(this.buildEndpoint(userId, "friendlists", reading)));
    }

    @Override
    public ResponseList<FriendRequest> getFriendRequests() throws FacebookException {
        return this.getFriendRequests("me", null);
    }

    @Override
    public ResponseList<FriendRequest> getFriendRequests(Reading reading) throws FacebookException {
        return this.getFriendRequests("me", reading);
    }

    @Override
    public ResponseList<FriendRequest> getFriendRequests(String userId) throws FacebookException {
        return this.getFriendRequests(userId, null);
    }

    @Override
    public ResponseList<FriendRequest> getFriendRequests(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendRequestList(this.get(this.buildEndpoint(userId, "friendrequests", reading)));
    }

    @Override
    public ResponseList<Friend> getFriends() throws FacebookException {
        return this.getFriends("me", null);
    }

    @Override
    public ResponseList<Friend> getFriends(Reading reading) throws FacebookException {
        return this.getFriends("me", reading);
    }

    @Override
    public ResponseList<Friend> getFriends(String userId) throws FacebookException {
        return this.getFriends(userId, null);
    }

    @Override
    public ResponseList<Friend> getFriends(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendList(this.get(this.buildEndpoint(userId, "friends", reading)));
    }

    @Override
    public ResponseList<Friend> getMutualFriends(String friendUserId) throws FacebookException {
        return this.getMutualFriends("me", friendUserId, null);
    }

    @Override
    public ResponseList<Friend> getMutualFriends(String friendUserId, Reading reading) throws FacebookException {
        return this.getMutualFriends("me", friendUserId, reading);
    }

    @Override
    public ResponseList<Friend> getMutualFriends(String userId1, String userId2) throws FacebookException {
        return this.getMutualFriends(userId1, userId2, null);
    }

    @Override
    public ResponseList<Friend> getMutualFriends(String userId1, String userId2, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendList(this.get(this.buildEndpoint(userId1, "mutualfriends/" + userId2, reading)));
    }

    @Override
    public String createFriendlist(String friendlistName) throws FacebookException {
        return this.createFriendlist("me", friendlistName);
    }

    @Override
    public String createFriendlist(String userId, String friendlistName) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(userId, "friendlists"), new HttpParameter[]{new HttpParameter("name", friendlistName)}).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public boolean deleteFriendlist(String friendlistId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(friendlistId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean addFriendlistMember(String friendlistId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(friendlistId + "/members/" + userId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean removeFriendlistMember(String friendlistId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(friendlistId + "/members/" + userId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean deleteFriendlistMember(String friendlistId, String userId) throws FacebookException {
        return this.removeFriendlistMember(friendlistId, userId);
    }

    @Override
    public Friendlist getFriendlist(String friendlistId) throws FacebookException {
        return this.getFriendlist(friendlistId, null);
    }

    @Override
    public Friendlist getFriendlist(String friendlistId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendlist(this.get(this.buildEndpoint(friendlistId, reading)));
    }

    @Override
    public ResponseList<Friend> getFriendlistMembers(String friendlistId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendList(this.get(this.buildEndpoint(friendlistId + "/members")));
    }

    @Override
    public ResponseList<Friend> getBelongsFriend(String friendId) throws FacebookException {
        return this.getBelongsFriend("me", friendId);
    }

    @Override
    public ResponseList<Friend> getBelongsFriend(String friendId, Reading reading) throws FacebookException {
        return this.getBelongsFriend("me", friendId, reading);
    }

    @Override
    public ResponseList<Friend> getBelongsFriend(String userId, String friendId) throws FacebookException {
        return this.getBelongsFriend(userId, friendId, null);
    }

    @Override
    public ResponseList<Friend> getBelongsFriend(String userId, String friendId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createFriendList(this.get(this.buildEndpoint(userId, "friends/" + friendId, reading)));
    }

    @Override
    public ResponseList<Game> getGames() throws FacebookException {
        return this.getGames("me", null);
    }

    @Override
    public ResponseList<Game> getGames(Reading reading) throws FacebookException {
        return this.getGames("me", reading);
    }

    @Override
    public ResponseList<Game> getGames(String userId) throws FacebookException {
        return this.getGames(userId, null);
    }

    @Override
    public ResponseList<Game> getGames(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createGameList(this.get(this.buildEndpoint(userId, "games", reading)));
    }

    @Override
    public ResponseList<Movie> getMovies() throws FacebookException {
        return this.getMovies("me", null);
    }

    @Override
    public ResponseList<Movie> getMovies(Reading reading) throws FacebookException {
        return this.getMovies("me", reading);
    }

    @Override
    public ResponseList<Movie> getMovies(String userId) throws FacebookException {
        return this.getMovies(userId, null);
    }

    @Override
    public ResponseList<Movie> getMovies(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createMovieList(this.get(this.buildEndpoint(userId, "movies", reading)));
    }

    @Override
    public ResponseList<Music> getMusic() throws FacebookException {
        return this.getMusic("me", null);
    }

    @Override
    public ResponseList<Music> getMusic(Reading reading) throws FacebookException {
        return this.getMusic("me", reading);
    }

    @Override
    public ResponseList<Music> getMusic(String userId) throws FacebookException {
        return this.getMusic(userId, null);
    }

    @Override
    public ResponseList<Music> getMusic(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createMusicList(this.get(this.buildEndpoint(userId, "music", reading)));
    }

    @Override
    public ResponseList<Television> getTelevision() throws FacebookException {
        return this.getTelevision("me", null);
    }

    @Override
    public ResponseList<Television> getTelevision(Reading reading) throws FacebookException {
        return this.getTelevision("me", reading);
    }

    @Override
    public ResponseList<Television> getTelevision(String userId) throws FacebookException {
        return this.getTelevision(userId, null);
    }

    @Override
    public ResponseList<Television> getTelevision(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createTelevisionList(this.get(this.buildEndpoint(userId, "television", reading)));
    }

    @Override
    public ResponseList<Interest> getInterests() throws FacebookException {
        return this.getInterests("me", null);
    }

    @Override
    public ResponseList<Interest> getInterests(Reading reading) throws FacebookException {
        return this.getInterests("me", reading);
    }

    @Override
    public ResponseList<Interest> getInterests(String userId) throws FacebookException {
        return this.getInterests(userId, null);
    }

    @Override
    public ResponseList<Interest> getInterests(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createInterestList(this.get(this.buildEndpoint(userId, "interests", reading)));
    }

    @Override
    public ResponseList<Group> getGroups() throws FacebookException {
        return this.getGroups("me", null);
    }

    @Override
    public ResponseList<Group> getGroups(Reading reading) throws FacebookException {
        return this.getGroups("me", reading);
    }

    @Override
    public ResponseList<Group> getGroups(String userId) throws FacebookException {
        return this.getGroups(userId, null);
    }

    @Override
    public ResponseList<Group> getGroups(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createGroupList(this.get(this.buildEndpoint(userId, "groups", reading)));
    }

    @Override
    public Group getGroup(String groupId) throws FacebookException {
        return this.getGroup(groupId, null);
    }

    @Override
    public Group getGroup(String groupId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createGroup(this.get(this.buildEndpoint(groupId, reading)));
    }

    @Override
    public ResponseList<Post> getGroupFeed(String groupId) throws FacebookException {
        return this.getGroupFeed(groupId, null);
    }

    @Override
    public ResponseList<Post> getGroupFeed(String groupId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildEndpoint(groupId, "feed", reading)));
    }

    @Override
    public ResponseList<GroupMember> getGroupMembers(String groupId) throws FacebookException {
        return this.getGroupMembers(groupId, null);
    }

    @Override
    public ResponseList<GroupMember> getGroupMembers(String groupId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createGroupMemberList(this.get(this.buildEndpoint(groupId, "members", reading)));
    }

    @Override
    public URL getGroupPictureURL(String groupId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.get(this.buildEndpoint(groupId, "picture"));
        try {
            return new URL(res.getResponseHeader("Location"));
        }
        catch (MalformedURLException urle) {
            throw new FacebookException(urle.getMessage(), urle);
        }
    }

    @Override
    public ResponseList<GroupDoc> getGroupDocs(String groupId) throws FacebookException {
        return this.getGroupDocs(groupId, null);
    }

    @Override
    public ResponseList<GroupDoc> getGroupDocs(String groupId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createGroupDocList(this.get(this.buildEndpoint(groupId, "docs", reading)));
    }

    @Override
    public String postGroupLink(String groupId, URL linkURL) throws FacebookException {
        return this.postGroupLink(groupId, linkURL, null);
    }

    @Override
    public String postGroupLink(String groupId, URL linkURL, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpParameter[] httpParameters = new HttpParameter[]{new HttpParameter("link", linkURL.toString())};
        if (message != null) {
            httpParameters = HttpParameter.merge(httpParameters, new HttpParameter[]{new HttpParameter("message", message)});
        }
        JSONObject json = this.post(this.buildEndpoint(groupId, "feed"), httpParameters).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public String postGroupFeed(String groupId, PostUpdate postUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(groupId, "feed"), postUpdate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public String postGroupStatusMessage(String groupId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(groupId, "feed"), new HttpParameter[]{new HttpParameter("message", message)}).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public InboxResponseList<Message> getInbox() throws FacebookException {
        return this.getInbox("me", null);
    }

    @Override
    public InboxResponseList<Message> getInbox(Reading reading) throws FacebookException {
        return this.getInbox("me", reading);
    }

    @Override
    public InboxResponseList<Message> getInbox(String userId) throws FacebookException {
        return this.getInbox(userId, null);
    }

    @Override
    public InboxResponseList<Message> getInbox(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createInboxList(this.get(this.buildEndpoint(userId, "inbox", reading)));
    }

    @Override
    public ResponseList<Message> getOutbox() throws FacebookException {
        return this.getOutbox("me", null);
    }

    @Override
    public ResponseList<Message> getOutbox(Reading reading) throws FacebookException {
        return this.getOutbox("me", reading);
    }

    @Override
    public ResponseList<Message> getOutbox(String userId) throws FacebookException {
        return this.getOutbox(userId, null);
    }

    @Override
    public ResponseList<Message> getOutbox(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createMessageList(this.get(this.buildEndpoint(userId, "outbox", reading)));
    }

    @Override
    public ResponseList<Message> getUpdates() throws FacebookException {
        return this.getUpdates("me", null);
    }

    @Override
    public ResponseList<Message> getUpdates(Reading reading) throws FacebookException {
        return this.getUpdates("me", reading);
    }

    @Override
    public ResponseList<Message> getUpdates(String userId) throws FacebookException {
        return this.getUpdates(userId, null);
    }

    @Override
    public ResponseList<Message> getUpdates(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createMessageList(this.get(this.buildEndpoint(userId, "updates", reading)));
    }

    @Override
    public Message getMessage(String messageId) throws FacebookException {
        return this.getMessage(messageId, null);
    }

    @Override
    public Message getMessage(String messageId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createMessage(this.get(this.buildEndpoint(messageId, reading)));
    }

    @Override
    public ResponseList<Like> getUserLikes() throws FacebookException {
        return this._getLikes("me", null);
    }

    @Override
    public ResponseList<Like> getUserLikes(Reading reading) throws FacebookException {
        return this._getLikes("me", reading);
    }

    @Override
    public ResponseList<Like> getUserLikes(String userId) throws FacebookException {
        return this._getLikes(userId, null);
    }

    @Override
    public ResponseList<Like> getUserLikes(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLikeList(this.get(this.buildEndpoint(userId, "likes", reading)));
    }

    @Override
    public Comment getComment(String commentId) throws FacebookException {
        return this.factory.createComment(this.get(this.buildEndpoint(commentId)));
    }

    @Override
    public boolean deleteComment(String commentId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(commentId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Like> getCommentLikes(String commentId) throws FacebookException {
        return this.getCommentLikes(commentId, null);
    }

    @Override
    public ResponseList<Like> getCommentLikes(String commentId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLikeList(this.get(this.buildEndpoint(commentId, "likes", reading)));
    }

    @Override
    public boolean likeComment(String commentId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(commentId);
    }

    @Override
    public boolean unlikeComment(String commentId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(commentId);
    }

    @Override
    public ResponseList<Link> getLinks() throws FacebookException {
        return this.getLinks("me", null);
    }

    @Override
    public ResponseList<Link> getLinks(Reading reading) throws FacebookException {
        return this.getLinks("me", reading);
    }

    @Override
    public ResponseList<Link> getLinks(String id) throws FacebookException {
        return this.getLinks(id, null);
    }

    @Override
    public ResponseList<Link> getLinks(String id, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLinkList(this.get(this.buildEndpoint(id, "links", reading)));
    }

    @Override
    public Link getLink(String linkId) throws FacebookException {
        return this.getLink(linkId, null);
    }

    @Override
    public Link getLink(String linkId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLink(this.get(this.buildEndpoint(linkId, reading)));
    }

    @Override
    public ResponseList<Comment> getLinkComments(String linkId) throws FacebookException {
        return this.getLinkComments(linkId, null);
    }

    @Override
    public ResponseList<Comment> getLinkComments(String linkId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(linkId, reading);
    }

    @Override
    public String commentLink(String linkId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(linkId, message);
    }

    @Override
    public ResponseList<Like> getLinkLikes(String linkId) throws FacebookException {
        return this.getLinkLikes(linkId, null);
    }

    @Override
    public ResponseList<Like> getLinkLikes(String linkId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getLikes(linkId, reading);
    }

    @Override
    public boolean likeLink(String linkId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(linkId);
    }

    @Override
    public boolean unlikeLink(String linkId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(linkId);
    }

    @Override
    public String postLink(URL link) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postLink("me", link, null);
    }

    @Override
    public String postLink(URL link, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postLink("me", link, message);
    }

    @Override
    public String postLink(String userId, URL link) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postLink(userId, link, null);
    }

    @Override
    public String postLink(String userId, URL link, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._postLink(userId, link, message);
    }

    @Override
    public ResponseList<Location> getLocations() throws FacebookException {
        return this.getLocations("me", null);
    }

    @Override
    public ResponseList<Location> getLocations(Reading reading) throws FacebookException {
        return this.getLocations("me", reading);
    }

    @Override
    public ResponseList<Location> getLocations(String userId) throws FacebookException {
        return this.getLocations(userId, null);
    }

    @Override
    public ResponseList<Location> getLocations(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createLocationList(this.get(this.buildEndpoint(userId, "locations", reading)));
    }

    @Override
    public ResponseList<Note> getNotes() throws FacebookException {
        return this.getNotes("me", null);
    }

    @Override
    public ResponseList<Note> getNotes(Reading reading) throws FacebookException {
        return this.getNotes("me", reading);
    }

    @Override
    public ResponseList<Note> getNotes(String id) throws FacebookException {
        return this.getNotes(id, null);
    }

    @Override
    public ResponseList<Note> getNotes(String id, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createNoteList(this.get(this.buildEndpoint(id, "notes", reading)));
    }

    @Override
    public String createNote(String subject, String message) throws FacebookException {
        return this.createNote("me", subject, message);
    }

    @Override
    public String createNote(String id, String subject, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(id, "notes"), new HttpParameter[]{new HttpParameter("subject", subject), new HttpParameter("message", message)}).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public Note getNote(String noteId) throws FacebookException {
        return this.getNote(noteId, null);
    }

    @Override
    public Note getNote(String noteId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createNote(this.get(this.buildEndpoint(noteId, reading)));
    }

    @Override
    public ResponseList<Comment> getNoteComments(String noteId) throws FacebookException {
        return this.getNoteComments(noteId, null);
    }

    @Override
    public ResponseList<Comment> getNoteComments(String noteId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(noteId, reading);
    }

    @Override
    public String commentNote(String noteId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(noteId, message);
    }

    @Override
    public ResponseList<Like> getNoteLikes(String noteId) throws FacebookException {
        return this.getNoteLikes(noteId, null);
    }

    @Override
    public ResponseList<Like> getNoteLikes(String noteId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getLikes(noteId, reading);
    }

    @Override
    public boolean likeNote(String noteId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(noteId);
    }

    @Override
    public boolean unlikeNote(String noteId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(noteId);
    }

    @Override
    public ResponseList<Notification> getNotifications() throws FacebookException {
        return this.getNotifications("me", null);
    }

    @Override
    public ResponseList<Notification> getNotifications(boolean includeRead) throws FacebookException {
        return this.getNotifications("me", null, includeRead);
    }

    @Override
    public ResponseList<Notification> getNotifications(Reading reading) throws FacebookException {
        return this.getNotifications("me", reading);
    }

    @Override
    public ResponseList<Notification> getNotifications(Reading reading, boolean includeRead) throws FacebookException {
        return this.getNotifications("me", reading, includeRead);
    }

    @Override
    public ResponseList<Notification> getNotifications(String userId) throws FacebookException {
        return this.getNotifications(userId, null);
    }

    @Override
    public ResponseList<Notification> getNotifications(String userId, boolean includeRead) throws FacebookException {
        return this.getNotifications(userId, null, includeRead);
    }

    @Override
    public ResponseList<Notification> getNotifications(String userId, Reading reading) throws FacebookException {
        return this.getNotifications(userId, reading, false);
    }

    @Override
    public ResponseList<Notification> getNotifications(String userId, Reading reading, boolean includeRead) throws FacebookException {
        this.ensureAuthorizationEnabled();
        String url = this.buildEndpoint(userId, "notifications", reading);
        HttpResponse res = includeRead ? this.get(url, new HttpParameter[]{new HttpParameter("include_read", 1)}) : this.get(url);
        return this.factory.createNotificationList(res);
    }

    @Override
    public boolean markNotificationAsRead(String notificationId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(notificationId), new HttpParameter[]{new HttpParameter("unread", 0)});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public Page getPage() throws FacebookException {
        return this.getPage("me", null);
    }

    @Override
    public Page getPage(Reading reading) throws FacebookException {
        return this.getPage("me", reading);
    }

    @Override
    public Page getPage(String pageId) throws FacebookException {
        return this.getPage(pageId, null);
    }

    @Override
    public Page getPage(String pageId, Reading reading) throws FacebookException {
        HttpResponse res = this.get(this.buildEndpoint(pageId, reading));
        return this.factory.createPage(res);
    }

    @Override
    public URL getPagePictureURL() throws FacebookException {
        return this.getPagePictureURL("me", null);
    }

    @Override
    public URL getPagePictureURL(PictureSize size) throws FacebookException {
        return this.getPagePictureURL("me", size);
    }

    @Override
    public URL getPagePictureURL(String pageId) throws FacebookException {
        return this.getPagePictureURL(pageId, null);
    }

    @Override
    public URL getPagePictureURL(String pageId, PictureSize size) throws FacebookException {
        return this._getPictureURL(pageId, size);
    }

    @Override
    public ResponseList<Post> getPromotablePosts() throws FacebookException {
        return this.getPromotablePosts("me", null);
    }

    @Override
    public ResponseList<Post> getPromotablePosts(Reading reading) throws FacebookException {
        return this.getPromotablePosts("me", reading);
    }

    @Override
    public ResponseList<Post> getPromotablePosts(String pageId) throws FacebookException {
        return this.getPromotablePosts(pageId, null);
    }

    @Override
    public ResponseList<Post> getPromotablePosts(String pageId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPostList(this.get(this.buildEndpoint(pageId, "promotable_posts", reading)));
    }

    @Override
    public boolean updatePageBasicAttributes(PageUpdate pageUpdate) throws FacebookException {
        return this.updatePageBasicAttributes("me", pageUpdate);
    }

    @Override
    public boolean updatePageBasicAttributes(String pageId, PageUpdate pageUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(pageId), pageUpdate.asHttpParameterArray());
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean updatePageProfilePhoto(URL picture) throws FacebookException {
        return this.updatePageProfilePhoto("me", picture);
    }

    @Override
    public boolean updatePageProfilePhoto(String pageId, URL picture) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(pageId, "picture"), new HttpParameter[]{new HttpParameter("picture", picture.toString())});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean updatePageProfilePhoto(Media source) throws FacebookException {
        return this.updatePageProfilePhoto("me", source);
    }

    @Override
    public boolean updatePageProfilePhoto(String pageId, Media source) throws FacebookException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        httpParams.add(source.asHttpParameter("source"));
        HttpResponse res = this.post(this.buildEndpoint(pageId, "picture"), httpParams.toArray(new HttpParameter[httpParams.size()]));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean updatePageCoverPhoto(PageCoverUpdate pageCoverUpdate) throws FacebookException {
        return this.updatePageCoverPhoto("me", pageCoverUpdate);
    }

    @Override
    public boolean updatePageCoverPhoto(String pageId, PageCoverUpdate pageCoverUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(pageId), pageCoverUpdate.asHttpParameterArray());
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<PageSetting> getPageSettings() throws FacebookException {
        return this.getPageSettings("me");
    }

    @Override
    public ResponseList<PageSetting> getPageSettings(String pageId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.get(this.buildEndpoint(pageId, "settings"));
        return this.factory.createPageSettingList(res);
    }

    @Override
    public boolean updatePageSetting(PageSettingUpdate pageSettingUpdate) throws FacebookException {
        return this.updatePageSetting("me", pageSettingUpdate);
    }

    @Override
    public boolean updatePageSetting(String pageId, PageSettingUpdate pageSettingUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(pageId, "settings"), pageSettingUpdate.asHttpParameterArray());
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public String postBackdatingFeed(BackdatingPostUpdate backdatingPostUpdate) throws FacebookException {
        return this.postBackdatingFeed("me", backdatingPostUpdate);
    }

    @Override
    public String postBackdatingFeed(String pageId, BackdatingPostUpdate backdatingPostUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(pageId, "feed"), backdatingPostUpdate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public String postPagePhoto(PagePhotoUpdate pagePhotoUpdate) throws FacebookException {
        return this.postPagePhoto("me", pagePhotoUpdate);
    }

    @Override
    public String postPagePhoto(String pageId, PagePhotoUpdate pagePhotoUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(pageId, "photos"), pagePhotoUpdate.asHttpParameterArray()).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public ResponseList<Page> getGlobalBrandChildren(String pageId) throws FacebookException {
        return this.getGlobalBrandChildren(pageId, null);
    }

    @Override
    public ResponseList<Page> getGlobalBrandChildren(String pageId, Reading reading) throws FacebookException {
        HttpResponse res = this.get(this.buildEndpoint(pageId, "global_brand_children", reading));
        return this.factory.createPageList(res);
    }

    @Override
    public ResponseList<Insight> getPageInsights(String pageId) throws FacebookException {
        return this.getPageInsights(pageId, null);
    }

    @Override
    public ResponseList<Insight> getPageInsights(String pageId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createInsightList(this.get(this.buildEndpoint(pageId, "insights", reading)));
    }

    @Override
    public ResponseList<Tagged> getPageTagged(String pageId) throws FacebookException {
        return this.getPageTagged(pageId, null);
    }

    @Override
    public ResponseList<Tagged> getPageTagged(String pageId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createTaggedList(this.get(this.buildEndpoint(pageId, "tagged", reading)));
    }

    @Override
    public ResponseList<Milestone> getMilestones() throws FacebookException {
        return this.getMilestones("me", null);
    }

    @Override
    public ResponseList<Milestone> getMilestones(Reading reading) throws FacebookException {
        return this.getMilestones("me", reading);
    }

    @Override
    public ResponseList<Milestone> getMilestones(String pageId) throws FacebookException {
        return this.getMilestones(pageId, null);
    }

    @Override
    public ResponseList<Milestone> getMilestones(String pageId, Reading reading) throws FacebookException {
        return this.factory.createMilestoneList(this.get(this.buildEndpoint(pageId, "milestones", reading)));
    }

    @Override
    public String createMilestone(MilestoneUpdate milestoneUpdate) throws FacebookException {
        return this.createMilestone("me", milestoneUpdate);
    }

    @Override
    public String createMilestone(String pageId, MilestoneUpdate milestoneUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(pageId, "milestones"), milestoneUpdate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public boolean deleteMilestone(String milestoneId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(milestoneId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Admin> getPageAdmins() throws FacebookException {
        return this.getPageAdmins("me", null);
    }

    @Override
    public ResponseList<Admin> getPageAdmins(Reading reading) throws FacebookException {
        return this.getPageAdmins("me", reading);
    }

    @Override
    public ResponseList<Admin> getPageAdmins(String pageId) throws FacebookException {
        return this.getPageAdmins(pageId, null);
    }

    @Override
    public ResponseList<Admin> getPageAdmins(String pageId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createAdminList(this.get(this.buildEndpoint(pageId, "admins", reading)));
    }

    @Override
    public ResponseList<Tab> getTabs() throws FacebookException {
        return this.getTabs("me", null);
    }

    @Override
    public ResponseList<Tab> getTabs(Reading reading) throws FacebookException {
        return this.getTabs("me", reading);
    }

    @Override
    public ResponseList<Tab> getTabs(String pageId) throws FacebookException {
        return this.getTabs(pageId, null);
    }

    @Override
    public ResponseList<Tab> getTabs(String pageId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createTabList(this.get(this.buildEndpoint(pageId, "tabs", reading)));
    }

    @Override
    public ResponseList<Tab> getInstalledTabs(List<String> appIds) throws FacebookException {
        return this.getInstalledTabs("me", appIds, null);
    }

    @Override
    public ResponseList<Tab> getInstalledTabs(List<String> appIds, Reading reading) throws FacebookException {
        return this.getInstalledTabs("me", appIds, reading);
    }

    @Override
    public ResponseList<Tab> getInstalledTabs(String pageId, List<String> appIds) throws FacebookException {
        return this.getInstalledTabs(pageId, appIds, null);
    }

    @Override
    public ResponseList<Tab> getInstalledTabs(String pageId, List<String> appIds, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        String _appIds = z_F4JInternalStringUtil.join(appIds.toArray(new String[appIds.size()]), ",");
        return this.factory.createTabList(this.get(this.buildEndpoint(pageId, "tabs/" + _appIds, reading)));
    }

    @Override
    public boolean installTab(String appId) throws FacebookException {
        return this.installTab("me", appId);
    }

    @Override
    public boolean installTab(String pageId, String appId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(pageId, "tabs"), new HttpParameter[]{new HttpParameter("app_id", appId)});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean updateTab(String tabId, TabUpdate tabUpdate) throws FacebookException {
        return this.updateTab("me", tabId, tabUpdate);
    }

    @Override
    public boolean updateTab(String pageId, String tabId, TabUpdate tabUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(pageId, "tabs/" + tabId), tabUpdate.asHttpParameterArray());
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean deleteTab(String tabId) throws FacebookException {
        return this.deleteTab("me", tabId);
    }

    @Override
    public boolean deleteTab(String pageId, String tabId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(pageId, "tabs/" + tabId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean displayPagePost(String postId, boolean isHidden) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(postId), new HttpParameter[]{new HttpParameter("is_hidden", isHidden)});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<User> getBlocked() throws FacebookException {
        return this.getBlocked("me", null);
    }

    @Override
    public ResponseList<User> getBlocked(Reading reading) throws FacebookException {
        return this.getBlocked("me", reading);
    }

    @Override
    public ResponseList<User> getBlocked(String pageId) throws FacebookException {
        return this.getBlocked(pageId, null);
    }

    @Override
    public ResponseList<User> getBlocked(String pageId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createUserList(this.get(this.buildEndpoint(pageId, "blocked", reading)));
    }

    @Override
    public Map<String, Boolean> block(List<String> userIds) throws FacebookException {
        return this.block("me", userIds);
    }

    @Override
    public Map<String, Boolean> block(String pageId, List<String> userIds) throws FacebookException {
        this.ensureAuthorizationEnabled();
        String _userIds = z_F4JInternalStringUtil.join(userIds.toArray(new String[userIds.size()]), ",");
        HttpResponse res = this.post(this.buildEndpoint(pageId, "blocked"), new HttpParameter[]{new HttpParameter("uid", _userIds)});
        HashMap<String, Boolean> blocks = new HashMap<String, Boolean>();
        JSONObject jsonObject = res.asJSONObject();
        Iterator uids = jsonObject.keys();
        while (uids.hasNext()) {
            String uid = (String)uids.next();
            boolean result = z_F4JInternalParseUtil.getBoolean(uid, jsonObject);
            blocks.put(uid, result);
        }
        return blocks;
    }

    @Override
    public boolean unblock(String userId) throws FacebookException {
        return this.unblock("me", userId);
    }

    @Override
    public boolean unblock(String pageId, String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(pageId, "blocked"), new HttpParameter[]{new HttpParameter("uid", userId)});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Offer> getOffers() throws FacebookException {
        return this.getOffers("me", null);
    }

    @Override
    public ResponseList<Offer> getOffers(Reading reading) throws FacebookException {
        return this.getOffers("me", reading);
    }

    @Override
    public ResponseList<Offer> getOffers(String pageId) throws FacebookException {
        return this.getOffers(pageId, null);
    }

    @Override
    public ResponseList<Offer> getOffers(String pageId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createOfferList(this.get(this.buildEndpoint(pageId, "offers", reading)));
    }

    @Override
    public String createOffer(OfferUpdate offerUpdate) throws FacebookException {
        return this.createOffer("me", offerUpdate);
    }

    @Override
    public String createOffer(String pageId, OfferUpdate offerUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(pageId, "offers"), offerUpdate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public boolean deleteOffer(String offerId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(offerId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public Offer getOffer(String offerId) throws FacebookException {
        return this.factory.createOffer(this.get(this.buildEndpoint(offerId)));
    }

    @Override
    public Page getLikedPage(String pageId) throws FacebookException {
        return this.getLikedPage("me", pageId, null);
    }

    @Override
    public Page getLikedPage(String pageId, Reading reading) throws FacebookException {
        return this.getLikedPage("me", pageId, reading);
    }

    @Override
    public Page getLikedPage(String userId, String pageId) throws FacebookException {
        return this.getLikedPage(userId, pageId, null);
    }

    @Override
    public Page getLikedPage(String userId, String pageId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.get(this.buildEndpoint(userId, "likes/" + pageId, reading));
        ResponseList<Page> list = this.factory.createPageList(res);
        return list.size() == 0 ? null : (Page)list.get(0);
    }

    @Override
    public List<Permission> getPermissions() throws FacebookException {
        return this.getPermissions("me");
    }

    @Override
    public List<Permission> getPermissions(String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPermissions(this.get(this.buildEndpoint(userId, "permissions")));
    }

    @Override
    public boolean revokePermission(String permissionName) throws FacebookException {
        return this.revokePermission("me", permissionName);
    }

    @Override
    public boolean revokePermission(String userId, String permissionName) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(userId, "permissions/" + permissionName));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean deletePermission(String permissionName) throws FacebookException {
        return this.revokePermission(permissionName);
    }

    @Override
    public boolean deletePermission(String userId, String permissionName) throws FacebookException {
        return this.revokePermission(userId, permissionName);
    }

    @Override
    public ResponseList<Photo> getUploadedPhotos() throws FacebookException {
        return this.getUploadedPhotos("me", null);
    }

    @Override
    public ResponseList<Photo> getUploadedPhotos(Reading reading) throws FacebookException {
        return this.getUploadedPhotos("me", reading);
    }

    @Override
    public ResponseList<Photo> getUploadedPhotos(String id) throws FacebookException {
        return this.getUploadedPhotos(id, null);
    }

    @Override
    public ResponseList<Photo> getUploadedPhotos(String id, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPhotoList(this.get(this.buildEndpoint(id, "photos/uploaded", reading)));
    }

    @Override
    public ResponseList<Photo> getPhotos() throws FacebookException {
        return this.getPhotos("me", null);
    }

    @Override
    public ResponseList<Photo> getPhotos(Reading reading) throws FacebookException {
        return this.getPhotos("me", reading);
    }

    @Override
    public ResponseList<Photo> getPhotos(String id) throws FacebookException {
        return this.getPhotos(id, null);
    }

    @Override
    public ResponseList<Photo> getPhotos(String id, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPhotoList(this.get(this.buildEndpoint(id, "photos", reading)));
    }

    @Override
    public Photo getPhoto(String photoId) throws FacebookException {
        return this.getPhoto(photoId, null);
    }

    @Override
    public Photo getPhoto(String photoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPhoto(this.get(this.buildEndpoint(photoId, reading)));
    }

    @Override
    public ResponseList<Comment> getPhotoComments(String photoId) throws FacebookException {
        return this.getPhotoComments(photoId, null);
    }

    @Override
    public ResponseList<Comment> getPhotoComments(String photoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(photoId, reading);
    }

    @Override
    public String commentPhoto(String photoId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(photoId, message);
    }

    @Override
    public ResponseList<Like> getPhotoLikes(String photoId) throws FacebookException {
        return this.getPhotoLikes(photoId, null);
    }

    @Override
    public ResponseList<Like> getPhotoLikes(String photoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getLikes(photoId, reading);
    }

    @Override
    public boolean likePhoto(String photoId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(photoId);
    }

    @Override
    public boolean unlikePhoto(String photoId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(photoId);
    }

    @Override
    public URL getPhotoURL(String photoId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.get(this.buildEndpoint(photoId, "picture"));
        try {
            return new URL(res.getResponseHeader("Location"));
        }
        catch (MalformedURLException urle) {
            throw new FacebookException(urle.getMessage(), urle);
        }
    }

    @Override
    public ResponseList<Tag> getTagsOnPhoto(String photoId) throws FacebookException {
        return this.getTagsOnPhoto(photoId, null);
    }

    @Override
    public ResponseList<Tag> getTagsOnPhoto(String photoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createTagList(this.get(this.buildEndpoint(photoId, "tags", reading)));
    }

    @Override
    public boolean addTagToPhoto(String photoId, String toUserId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(photoId, "tags"), new HttpParameter[]{new HttpParameter("to", toUserId)});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean addTagToPhoto(String photoId, TagUpdate tagUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(photoId, "tags"), tagUpdate.asHttpParameterArray());
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean addTagToPhoto(String photoId, List<String> toUserIds) throws FacebookException {
        this.ensureAuthorizationEnabled();
        if (toUserIds.size() == 0) {
            throw new IllegalArgumentException("toUserIds size 0");
        }
        if (toUserIds.size() == 1) {
            return this.addTagToPhoto(photoId, toUserIds.get(0));
        }
        ArrayList tags = new ArrayList(toUserIds.size());
        for (String toUserId : toUserIds) {
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("tag_uid", toUserId);
            tags.add(map);
        }
        HttpResponse res = this.post(this.buildEndpoint(photoId, "tags"), new HttpParameter[]{new HttpParameter("tags", new JSONArray(tags).toString())});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean updateTagOnPhoto(String photoId, TagUpdate tagUpdate) throws FacebookException {
        return this.addTagToPhoto(photoId, tagUpdate);
    }

    @Override
    public boolean deleteTagOnPhoto(String photoId, String toUserId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(photoId, "tags"), new HttpParameter[]{new HttpParameter("to", toUserId)});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public String postPhoto(Media source) throws FacebookException {
        return this.postPhoto("me", source);
    }

    @Override
    public String postPhoto(PhotoUpdate photoUpdate) throws FacebookException {
        return this.postPhoto("me", photoUpdate);
    }

    @Override
    public String postPhoto(String userId, Media source) throws FacebookException {
        return this.postPhoto(userId, new PhotoUpdate(source));
    }

    @Override
    public String postPhoto(String userId, PhotoUpdate photoUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(userId, "photos"), photoUpdate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public boolean deletePhoto(String photoId) throws FacebookException {
        HttpResponse res = this.delete(this.buildEndpoint(photoId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Poke> getPokes() throws FacebookException {
        return this.getPokes("me", null);
    }

    @Override
    public ResponseList<Poke> getPokes(Reading reading) throws FacebookException {
        return this.getPokes("me", reading);
    }

    @Override
    public ResponseList<Poke> getPokes(String userId) throws FacebookException {
        return this.getPokes(userId, null);
    }

    @Override
    public ResponseList<Poke> getPokes(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createPokeList(this.get(this.buildEndpoint(userId, "pokes", reading)));
    }

    @Override
    public ResponseList<Question> getQuestions() throws FacebookException {
        return this.getQuestions("me", null);
    }

    @Override
    public ResponseList<Question> getQuestions(Reading reading) throws FacebookException {
        return this.getQuestions("me", reading);
    }

    @Override
    public ResponseList<Question> getQuestions(String id) throws FacebookException {
        return this.getQuestions(id, null);
    }

    @Override
    public ResponseList<Question> getQuestions(String id, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createQuestionList(this.get(this.buildEndpoint(id, "questions", reading)));
    }

    @Override
    public Question getQuestion(String questionId) throws FacebookException {
        return this.getQuestion(questionId, null);
    }

    @Override
    public Question getQuestion(String questionId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createQuestion(this.get(this.buildEndpoint(questionId, reading)));
    }

    @Override
    public String createQuestion(QuestionUpdate questionUpdate) throws FacebookException {
        return this.createQuestion("me", questionUpdate);
    }

    @Override
    public String createQuestion(String id, QuestionUpdate questionUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(id, "questions"), questionUpdate.asHttpParameterArray()).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public boolean deleteQuestion(String questionId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(questionId));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Question.Option> getQuestionOptions(String questionId) throws FacebookException {
        return this.getQuestionOptions(questionId, null);
    }

    @Override
    public ResponseList<Question.Option> getQuestionOptions(String questionId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createQuestionOptionList(this.get(this.buildEndpoint(questionId, "options", reading)));
    }

    @Override
    public String addQuestionOption(String questionId, String optionDescription) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(questionId, "options"), new HttpParameter[]{new HttpParameter("option", optionDescription)}).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public ResponseList<QuestionVotes> getQuestionOptionVotes(String questionId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        Reading reading = new Reading().fields("votes");
        return this.factory.createQuestionVotesList(this.get(this.buildEndpoint(questionId, "options", reading)));
    }

    @Override
    public ResponseList<Score> getScores() throws FacebookException {
        return this.getScores("me", null);
    }

    @Override
    public ResponseList<Score> getScores(Reading reading) throws FacebookException {
        return this.getScores("me", reading);
    }

    @Override
    public ResponseList<Score> getScores(String userId) throws FacebookException {
        return this.getScores(userId, null);
    }

    @Override
    public ResponseList<Score> getScores(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createScoreList(this.get(this.buildEndpoint(userId, "scores", reading)));
    }

    @Override
    public boolean postScore(int scoreValue) throws FacebookException {
        return this.postScore("me", scoreValue);
    }

    @Override
    public boolean postScore(String userId, int scoreValue) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(userId, "scores"), new HttpParameter[]{new HttpParameter("score", scoreValue)});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean deleteScore() throws FacebookException {
        return this.deleteScore("me");
    }

    @Override
    public boolean deleteScore(String userId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(userId, "scores"));
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public ResponseList<Subscribedto> getSubscribedto() throws FacebookException {
        return this.getSubscribedto("me", null);
    }

    @Override
    public ResponseList<Subscribedto> getSubscribedto(Reading reading) throws FacebookException {
        return this.getSubscribedto("me", reading);
    }

    @Override
    public ResponseList<Subscribedto> getSubscribedto(String userId) throws FacebookException {
        return this.getSubscribedto(userId, null);
    }

    @Override
    public ResponseList<Subscribedto> getSubscribedto(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createSubscribedtoList(this.get(this.buildEndpoint(userId, "subscribedto", reading)));
    }

    @Override
    public ResponseList<Subscriber> getSubscribers() throws FacebookException {
        return this.getSubscribers("me", null);
    }

    @Override
    public ResponseList<Subscriber> getSubscribers(Reading reading) throws FacebookException {
        return this.getSubscribers("me", reading);
    }

    @Override
    public ResponseList<Subscriber> getSubscribers(String userId) throws FacebookException {
        return this.getSubscribers(userId, null);
    }

    @Override
    public ResponseList<Subscriber> getSubscribers(String userId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createSubscriberList(this.get(this.buildEndpoint(userId, "subscribers", reading)));
    }

    @Override
    public ResponseList<Video> getVideos() throws FacebookException {
        return this.getVideos("me", null);
    }

    @Override
    public ResponseList<Video> getVideos(Reading reading) throws FacebookException {
        return this.getVideos("me", reading);
    }

    @Override
    public ResponseList<Video> getVideos(String id) throws FacebookException {
        return this.getVideos(id, null);
    }

    @Override
    public ResponseList<Video> getVideos(String id, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createVideoList(this.get(this.buildEndpoint(id, "videos", reading)));
    }

    @Override
    public String postVideo(VideoUpdate videoUpdate) throws FacebookException {
        return this.postVideo("me", videoUpdate);
    }

    @Override
    public String postVideo(String id, VideoUpdate videoUpdate) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildVideoEndpoint(id, "videos"), videoUpdate.asHttpParameterArray()).asJSONObject();
        return z_F4JInternalParseUtil.getRawString("id", json);
    }

    @Override
    public Video getVideo(String videoId) throws FacebookException {
        return this.getVideo(videoId, null);
    }

    @Override
    public Video getVideo(String videoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createVideo(this.get(this.buildEndpoint(videoId, reading)));
    }

    @Override
    public ResponseList<Like> getVideoLikes(String videoId) throws FacebookException {
        return this.getVideoLikes(videoId, null);
    }

    @Override
    public ResponseList<Like> getVideoLikes(String videoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getLikes(videoId, reading);
    }

    @Override
    public boolean likeVideo(String videoId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._like(videoId);
    }

    @Override
    public boolean unlikeVideo(String videoId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._unlike(videoId);
    }

    @Override
    public ResponseList<Comment> getVideoComments(String videoId) throws FacebookException {
        return this.getVideoComments(videoId, null);
    }

    @Override
    public ResponseList<Comment> getVideoComments(String videoId, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getComments(videoId, reading);
    }

    @Override
    public String commentVideo(String videoId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._comment(videoId, message);
    }

    @Override
    public URL getVideoCover(String videoId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this._getPictureURL(videoId, null);
    }

    @Override
    public ResponseList<Insight> getInsights(String objectId, String metric) throws FacebookException {
        return this.getInsights(objectId, metric, null);
    }

    @Override
    public ResponseList<Insight> getInsights(String objectId, String metric, Reading reading) throws FacebookException {
        this.ensureAuthorizationEnabled();
        return this.factory.createInsightList(this.get(this.buildEndpoint(objectId, "insights/" + metric, reading)));
    }

    @Override
    public ResponseList<Post> searchPosts(String query) throws FacebookException {
        return this.searchPosts(query, null);
    }

    @Override
    public ResponseList<Post> searchPosts(String query, Reading reading) throws FacebookException {
        return this.factory.createPostList(this.get(this.buildSearchEndpoint(query, "post", reading)));
    }

    @Override
    public ResponseList<User> searchUsers(String query) throws FacebookException {
        return this.searchUsers(query, null);
    }

    @Override
    public ResponseList<User> searchUsers(String query, Reading reading) throws FacebookException {
        return this.factory.createUserList(this.get(this.buildSearchEndpoint(query, "user", reading)));
    }

    @Override
    public ResponseList<Event> searchEvents(String query) throws FacebookException {
        return this.searchEvents(query, null);
    }

    @Override
    public ResponseList<Event> searchEvents(String query, Reading reading) throws FacebookException {
        return this.factory.createEventList(this.get(this.buildSearchEndpoint(query, "event", reading)));
    }

    @Override
    public ResponseList<Group> searchGroups(String query) throws FacebookException {
        return this.searchGroups(query, null);
    }

    @Override
    public ResponseList<Group> searchGroups(String query, Reading reading) throws FacebookException {
        return this.factory.createGroupList(this.get(this.buildSearchEndpoint(query, "group", reading)));
    }

    @Override
    public ResponseList<Place> searchPlaces(String query) throws FacebookException {
        return this.searchPlaces(query, null);
    }

    @Override
    public ResponseList<Place> searchPlaces(String query, Reading reading) throws FacebookException {
        return this.factory.createPlaceList(this.get(this.buildSearchEndpoint(query, "place", reading)));
    }

    @Override
    public ResponseList<Place> searchPlaces(String query, GeoLocation center, int distance) throws FacebookException {
        return this.searchPlaces(query, center, distance, null);
    }

    @Override
    public ResponseList<Place> searchPlaces(String query, GeoLocation center, int distance, Reading reading) throws FacebookException {
        String url = this.buildSearchEndpoint(query, "place", reading) + "&center=" + HttpParameter.encode(center.asParameterString()) + "&distance=" + distance;
        return this.factory.createPlaceList(this.get(url));
    }

    @Override
    public ResponseList<Checkin> searchCheckins() throws FacebookException {
        return this.searchCheckins(null);
    }

    @Override
    public ResponseList<Checkin> searchCheckins(Reading reading) throws FacebookException {
        return this.factory.createCheckinList(this.get(this.buildSearchEndpoint(null, "checkin", reading)));
    }

    @Override
    public ResponseList<Location> searchLocations(GeoLocation center, int distance) throws FacebookException {
        return this.searchLocations(center, distance, null);
    }

    @Override
    public ResponseList<Location> searchLocations(GeoLocation center, int distance, Reading reading) throws FacebookException {
        String url = this.buildSearchEndpoint(null, "location", reading) + "&center=" + HttpParameter.encode(center.asParameterString()) + "&distance=" + distance;
        return this.factory.createLocationList(this.get(url));
    }

    @Override
    public ResponseList<Location> searchLocations(String placeId) throws FacebookException {
        return this.searchLocations(placeId, null);
    }

    @Override
    public ResponseList<Location> searchLocations(String placeId, Reading reading) throws FacebookException {
        String url = this.buildSearchEndpoint(null, "location", reading) + "&place=" + placeId;
        return this.factory.createLocationList(this.get(url));
    }

    @Override
    public ResponseList<JSONObject> search(String query) throws FacebookException {
        return this.search(query, null);
    }

    @Override
    public ResponseList<JSONObject> search(String query, Reading reading) throws FacebookException {
        String url = this.buildSearchEndpoint(query, null, reading);
        return this.factory.createJSONObjectList(this.get(url));
    }

    @Override
    public ResponseList<Page> searchPages(String query) throws FacebookException {
        return this.searchPages(query, null);
    }

    @Override
    public ResponseList<Page> searchPages(String query, Reading reading) throws FacebookException {
        String url = this.buildSearchEndpoint(query, "page", reading);
        return this.factory.createPageList(this.get(url));
    }

    @Override
    public JSONArray executeFQL(String query) throws FacebookException {
        return this.executeFQL(query, null);
    }

    @Override
    public JSONArray executeFQL(String query, Locale locale) throws FacebookException {
        this.ensureAuthorizationEnabled();
        String url = "";
        try {
            url = this.conf.getRestBaseURL() + "fql?q=" + URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
        if (locale != null) {
            url = url + "&locale=" + HttpParameter.encode(locale.toString());
        }
        JSONObject json = this.get(url).asJSONObject();
        try {
            return json.getJSONArray("data");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public Map<String, JSONArray> executeMultiFQL(Map<String, String> queries) throws FacebookException {
        return this.executeMultiFQL(queries, null);
    }

    @Override
    public Map<String, JSONArray> executeMultiFQL(Map<String, String> queries, Locale locale) throws FacebookException {
        this.ensureAuthorizationEnabled();
        String url = this.conf.getRestBaseURL() + "fql?q=" + this.convertQueriesToJson(queries);
        if (locale != null) {
            url = url + "&locale=" + HttpParameter.encode(locale.toString());
        }
        JSONObject json = this.get(url).asJSONObject();
        HashMap<String, JSONArray> result = new HashMap<String, JSONArray>();
        try {
            JSONArray jsonArray = json.getJSONArray("data");
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String name = jsonObject.getString("name");
                JSONArray resultSets = jsonObject.getJSONArray("fql_result_set");
                result.put(name, resultSets);
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
        return result;
    }

    private String convertQueriesToJson(Map<String, String> queries) {
        ArrayList<String> jsons = new ArrayList<String>();
        for (String name : queries.keySet()) {
            String json = "";
            try {
                json = "%22" + URLEncoder.encode(name, "UTF-8") + "%22" + ":" + "%22" + URLEncoder.encode(queries.get(name), "UTF-8") + "%22";
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
            jsons.add(json);
        }
        return "{" + z_F4JInternalStringUtil.join(jsons.toArray(new String[jsons.size()])) + "}";
    }

    @Override
    public TestUser createTestUser(String appId) throws FacebookException {
        return this.createTestUser(appId, null, null, null);
    }

    @Override
    public TestUser createTestUser(String appId, String name, String locale, String permissions) throws FacebookException {
        this.ensureAuthorizationEnabled();
        String _locale = "en_US";
        if (locale != null) {
            _locale = locale;
        }
        return this.factory.createTestUser(this.post(this.conf.getRestBaseURL() + appId + "/accounts/test-users" + "?installed=true" + "&name=" + HttpParameter.encode(name) + "&locale=" + HttpParameter.encode(_locale) + "&permissions=" + HttpParameter.encode(permissions)));
    }

    @Override
    public List<TestUser> getTestUsers(String appId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.get(this.conf.getRestBaseURL() + appId + "/accounts/test-users");
        try {
            JSONArray data = res.asJSONObject().getJSONArray("data");
            ArrayList<TestUser> testUsers = new ArrayList<TestUser>();
            for (int i = 0; i < data.length(); ++i) {
                testUsers.add(this.factory.createTestUser(data.getJSONObject(i)));
            }
            return testUsers;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public boolean deleteTestUser(String testUserId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.conf.getRestBaseURL() + testUserId);
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public boolean makeFriendTestUser(TestUser testUser1, TestUser testUser2) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(testUser1.getId(), "friends/" + testUser2.getId()), new HttpParameter[]{new HttpParameter("access_token", testUser1.getAccessToken())});
        if (!Boolean.valueOf(res.asString().trim()).booleanValue()) {
            return false;
        }
        res = this.post(this.buildEndpoint(testUser2.getId(), "friends/" + testUser1.getId()), new HttpParameter[]{new HttpParameter("access_token", testUser2.getAccessToken())});
        return Boolean.valueOf(res.asString().trim());
    }

    @Override
    public <T> ResponseList<T> fetchNext(Paging<T> paging) throws FacebookException {
        this.ensureAuthorizationEnabled();
        URL url = paging.getNext();
        if (url == null) {
            return null;
        }
        return this.fetchPaging(url, paging.getJSONObjectType());
    }

    @Override
    public <T> ResponseList<T> fetchPrevious(Paging<T> paging) throws FacebookException {
        this.ensureAuthorizationEnabled();
        URL url = paging.getPrevious();
        if (url == null) {
            return null;
        }
        return this.fetchPaging(url, paging.getJSONObjectType());
    }

    private <T> ResponseList<T> fetchPaging(URL url, Class<T> jsonObjectType) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.getRaw(url.toString());
        return this.factory.createResponseList(res, jsonObjectType);
    }

    @Override
    public List<BatchResponse> executeBatch(BatchRequests<BatchRequest> requests) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONArray jsonArray = this.post(this.buildEndpoint(""), requests.asHttpParameterArray()).asJSONArray();
        int size = jsonArray.length();
        ArrayList<BatchResponse> result = new ArrayList<BatchResponse>(size);
        for (int i = 0; i < size; ++i) {
            try {
                if (jsonArray.isNull(i)) {
                    result.add(null);
                    continue;
                }
                JSONObject json = jsonArray.getJSONObject(i);
                result.add(new BatchResponseImpl(json));
                continue;
            }
            catch (JSONException e) {
                throw new FacebookException(e);
            }
        }
        return result;
    }

    @Override
    public RawAPIResponse callGetAPI(String relativeUrl) throws FacebookException {
        return this.callGetAPI(relativeUrl, null);
    }

    @Override
    public RawAPIResponse callGetAPI(String relativeUrl, Map<String, String> parameters) throws FacebookException {
        this.ensureAuthorizationEnabled();
        String path = relativeUrl;
        if (relativeUrl.startsWith("/")) {
            path = relativeUrl.substring(1);
        }
        HttpResponse res = this.get(this.buildEndpoint(path, parameters));
        return new RawAPIResponseImpl(res);
    }

    @Override
    public RawAPIResponse callPostAPI(String relativeUrl) throws FacebookException {
        return this.callPostAPI(relativeUrl, null);
    }

    @Override
    public RawAPIResponse callPostAPI(String relativeUrl, Map<String, String> parameters) throws FacebookException {
        HttpResponse res;
        this.ensureAuthorizationEnabled();
        String path = relativeUrl;
        if (relativeUrl.startsWith("/")) {
            path = relativeUrl.substring(1);
        }
        if (parameters != null && parameters.size() > 0) {
            HttpParameter[] httpParameters = new HttpParameter[parameters.size()];
            int i = 0;
            for (String p : parameters.keySet()) {
                httpParameters[i++] = new HttpParameter(p, parameters.get(p));
            }
            res = this.post(this.buildEndpoint(path), httpParameters);
        } else {
            res = this.post(this.buildEndpoint(path));
        }
        return new RawAPIResponseImpl(res);
    }

    @Override
    public RawAPIResponse callDeleteAPI(String relativeUrl) throws FacebookException {
        return this.callDeleteAPI(relativeUrl, null);
    }

    @Override
    public RawAPIResponse callDeleteAPI(String relativeUrl, Map<String, String> parameters) throws FacebookException {
        this.ensureAuthorizationEnabled();
        String path = relativeUrl;
        if (relativeUrl.startsWith("/")) {
            path = relativeUrl.substring(1);
        }
        HttpResponse res = this.delete(this.buildEndpoint(path, parameters));
        return new RawAPIResponseImpl(res);
    }

    private ResponseList<Comment> _getComments(String objectId, Reading reading) throws FacebookException {
        return this.factory.createCommentList(this.get(this.buildEndpoint(objectId, "comments", reading)));
    }

    private ResponseList<Like> _getLikes(String objectId, Reading reading) throws FacebookException {
        return this.factory.createLikeList(this.get(this.buildEndpoint(objectId, "likes", reading)));
    }

    private URL _getPictureURL(String objectId, PictureSize size) throws FacebookException {
        String url = this.buildEndpoint(objectId, "picture");
        HttpResponse res = size != null ? this.get(url, new HttpParameter[]{new HttpParameter("type", size.toString())}) : this.get(url);
        try {
            return new URL(res.getResponseHeader("Location"));
        }
        catch (MalformedURLException urle) {
            throw new FacebookException(urle.getMessage(), urle);
        }
    }

    private URL _getPictureURL(String objectId, int width, int height) throws FacebookException {
        String url = this.buildEndpoint(objectId, "picture");
        HttpResponse res = width > 0 && height > 0 ? this.get(url, new HttpParameter[]{new HttpParameter("width", Integer.toString(width)), new HttpParameter("height", Integer.toString(height))}) : this.get(url);
        try {
            return new URL(res.getResponseHeader("Location"));
        }
        catch (MalformedURLException urle) {
            throw new FacebookException(urle.getMessage(), urle);
        }
    }

    private URL _getSSLPictureURL(String objectId, PictureSize size) throws FacebookException {
        String url = this.buildEndpoint(objectId, "picture");
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("return_ssl_resources", "1")};
        if (size != null) {
            params = HttpParameter.merge(params, new HttpParameter("type", size.toString()));
        }
        HttpResponse res = this.get(url, params);
        try {
            return new URL(res.getResponseHeader("Location"));
        }
        catch (MalformedURLException urle) {
            throw new FacebookException(urle.getMessage(), urle);
        }
    }

    private String _comment(String objectId, String message) throws FacebookException {
        this.ensureAuthorizationEnabled();
        JSONObject json = this.post(this.buildEndpoint(objectId, "comments"), new HttpParameter[]{new HttpParameter("message", message)}).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    private boolean _like(String objectId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.post(this.buildEndpoint(objectId, "likes"));
        return Boolean.valueOf(res.asString().trim());
    }

    private boolean _unlike(String objectId) throws FacebookException {
        this.ensureAuthorizationEnabled();
        HttpResponse res = this.delete(this.buildEndpoint(objectId, "likes"));
        return Boolean.valueOf(res.asString().trim());
    }

    private String _postLink(String objectId, URL link, String message) throws FacebookException {
        HttpParameter[] httpParameters = new HttpParameter[]{new HttpParameter("link", link.toString())};
        if (message != null) {
            httpParameters = HttpParameter.merge(httpParameters, new HttpParameter[]{new HttpParameter("message", message)});
        }
        JSONObject json = this.post(this.buildEndpoint(objectId, "feed"), httpParameters).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    private String _postStatusMessage(String objectId, String message) throws FacebookException {
        JSONObject json = this.post(this.buildEndpoint(objectId, "feed"), new HttpParameter[]{new HttpParameter("message", message)}).asJSONObject();
        try {
            return json.getString("id");
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse get(String url) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse get(String url, HttpParameter[] parameters) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, parameters, this.containsAccessToken(parameters) ? null : this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, parameters, this.containsAccessToken(parameters) ? null : this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse getRaw(String url) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String url) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String url, HttpParameter[] parameters) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, parameters, this.containsAccessToken(parameters) ? null : this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, parameters, this.containsAccessToken(parameters) ? null : this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse delete(String url) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.delete(url, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.delete(url, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse delete(String url, HttpParameter[] parameters) throws FacebookException {
        if (!this.conf.isMBeanEnabled()) {
            return this.http.delete(url, parameters, this.containsAccessToken(parameters) ? null : this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.delete(url, parameters, this.containsAccessToken(parameters) ? null : this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            FacebookAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    private boolean isOk(HttpResponse response) {
        return response != null && response.getStatusCode() < 300;
    }

    private boolean containsAccessToken(HttpParameter[] parameters) throws FacebookException {
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].getName().equals("access_token")) continue;
            return true;
        }
        return false;
    }

    @Override
    public UserMethods users() {
        return this;
    }

    @Override
    public AccountMethods accounts() {
        return this;
    }

    @Override
    public ActivityMethods activities() {
        return this;
    }

    @Override
    public AlbumMethods albums() {
        return this;
    }

    @Override
    public CheckinMethods checkins() {
        return this;
    }

    @Override
    public CommentMethods comments() {
        return this;
    }

    @Override
    public DomainMethods domains() {
        return this;
    }

    @Override
    public EventMethods events() {
        return this;
    }

    @Override
    public FamilyMethods family() {
        return this;
    }

    @Override
    public FavoriteMethods favorites() {
        return this;
    }

    @Override
    public FriendMethods friends() {
        return this;
    }

    @Override
    public GameMethods games() {
        return this;
    }

    @Override
    public GroupMethods groups() {
        return this;
    }

    @Override
    public LikeMethods likes() {
        return this;
    }

    @Override
    public LinkMethods links() {
        return this;
    }

    @Override
    public LocationMethods locations() {
        return this;
    }

    @Override
    public MessageMethods messages() {
        return this;
    }

    @Override
    public NoteMethods notes() {
        return this;
    }

    @Override
    public NotificationMethods notifications() {
        return this;
    }

    @Override
    public PageMethods pages() {
        return this;
    }

    @Override
    public PermissionMethods permissions() {
        return this;
    }

    @Override
    public PhotoMethods photos() {
        return this;
    }

    @Override
    public PokeMethods pokes() {
        return this;
    }

    @Override
    public PostMethods posts() {
        return this;
    }

    @Override
    public QuestionMethods questions() {
        return this;
    }

    @Override
    public SubscribeMethods subscribes() {
        return this;
    }

    @Override
    public VideoMethods videos() {
        return this;
    }

    @Override
    public InsightMethods insights() {
        return this;
    }

    @Override
    public SearchMethods search() {
        return this;
    }

    @Override
    public TestUserMethods testUsers() {
        return this;
    }

    @Override
    public FQLMethods fql() {
        return this;
    }

    @Override
    public BatchRequestsMethods batch() {
        return this;
    }

    @Override
    public RawAPIMethods rawAPI() {
        return this;
    }
}

