/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.Family;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.json.UserJSONImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FamilyJSONImpl
extends UserJSONImpl
implements Family,
Serializable {
    private static final long serialVersionUID = 3676633893253219856L;
    private String relationship;

    FamilyJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res, conf);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    FamilyJSONImpl(JSONObject json) throws FacebookException {
        super(json);
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        this.relationship = z_F4JInternalParseUtil.getRawString("relationship", json);
    }

    @Override
    public String getRelationship() {
        return this.relationship;
    }

    static ResponseList<Family> createFamilyList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Family> familys = new ResponseListImpl<Family>(size, json, new Family[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject familyJSONObject = list.getJSONObject(i);
                FamilyJSONImpl family = new FamilyJSONImpl(familyJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(family, familyJSONObject);
                }
                familys.add(family);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(familys, list);
            }
            return familys;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    @Override
    public String toString() {
        return "FamilyJSONImpl{relationship='" + this.relationship + '\'' + '}' + " extends " + super.toString();
    }
}

