/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.conf;

import facebook4j.Version;
import facebook4j.conf.Configuration;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationBase
implements Configuration,
Serializable {
    private static final long serialVersionUID = -4618524490519309627L;
    private boolean debug;
    private String userAgent;
    private boolean useSSL;
    private boolean prettyDebug;
    private boolean gzipEnabled;
    private String httpProxyHost;
    private String httpProxyUser;
    private String httpProxyPassword;
    private int httpProxyPort;
    private int httpConnectionTimeout;
    private int httpReadTimeout;
    private int httpStreamingReadTimeout;
    private int httpRetryCount;
    private int httpRetryIntervalSeconds;
    private int maxTotalConnections;
    private int defaultMaxPerRoute;
    private String oAuthAppId;
    private String oAuthAppSecret;
    private String oAuthPermissions;
    private String oAuthAccessToken;
    private String oAuthCallbackURL;
    private boolean appSecretProofEnabled;
    private int appSecretProofCacheSize;
    private String oAuthAuthorizationURL;
    private String oAuthAccessTokenURL;
    private String oAuthAccessTokenInfoURL;
    private String oAuthDeviceTokenURL;
    private String restBaseURL;
    private String videoBaseURL;
    private boolean jsonStoreEnabled;
    private boolean mbeanEnabled;
    private String clientVersion;
    private String clientURL;
    public static final String DALVIK = "facebook4j.dalvik";
    public static final String GAE = "facebook4j.gae";
    private static final String DEFAULT_OAUTH_AUTHORIZATION_URL = "http://www.facebook.com/dialog/oauth";
    private static final String DEFAULT_OAUTH_ACCESS_TOKEN_URL = "http://graph.facebook.com/oauth/access_token";
    private static final String DEFAULT_OAUTH_ACCESS_TOKEN_INFO_URL = "http://graph.facebook.com/oauth/access_token_info";
    private static final String DEFAULT_OAUTH_DEVICE_TOKEN_URL = "http://graph.facebook.com/oauth/device";
    private static final String DEFAULT_REST_BASE_URL = "http://graph.facebook.com/";
    private static final String DEFAULT_VIDEO_BASE_URL = "http://graph-video.facebook.com/";
    private boolean IS_DALVIK;
    private boolean IS_GAE;
    static String dalvikDetected;
    static String gaeDetected;
    Map<String, String> requestHeaders;
    private static final List<ConfigurationBase> instances;

    protected ConfigurationBase() {
        String isGAE;
        String isDalvik;
        this.setDebug(false);
        this.setUseSSL(true);
        this.setPrettyDebugEnabled(false);
        this.setGZIPEnabled(true);
        this.setHttpProxyHost(null);
        this.setHttpProxyUser(null);
        this.setHttpProxyPassword(null);
        this.setHttpProxyPort(-1);
        this.setHttpConnectionTimeout(20000);
        this.setHttpReadTimeout(120000);
        this.setHttpStreamingReadTimeout(40000);
        this.setHttpRetryCount(0);
        this.setHttpRetryIntervalSeconds(5);
        this.setHttpMaxTotalConnections(20);
        this.setHttpDefaultMaxPerRoute(2);
        this.setOAuthAppId(null);
        this.setOAuthAppSecret(null);
        this.setOAuthAccessToken(null);
        this.setOAuthCallbackURL(null);
        this.setAppSecretProofEnabled(false);
        this.setAppSecretProofCacheSize(10);
        this.setClientVersion(Version.getVersion());
        this.setClientURL("http://facebook4j.org/en/facebook4j-" + Version.getVersion() + ".xml");
        this.setUserAgent("facebook4j http://facebook4j.org/ /" + Version.getVersion());
        this.setJSONStoreEnabled(false);
        this.setMBeanEnabled(false);
        this.setOAuthAuthorizationURL(DEFAULT_OAUTH_AUTHORIZATION_URL);
        this.setOAuthAccessTokenURL(DEFAULT_OAUTH_ACCESS_TOKEN_URL);
        this.setOAuthAccessTokenInfoURL(DEFAULT_OAUTH_ACCESS_TOKEN_INFO_URL);
        this.setOAuthDeviceTokenURL(DEFAULT_OAUTH_DEVICE_TOKEN_URL);
        this.setRestBaseURL(DEFAULT_REST_BASE_URL);
        this.setVideoBaseURL(DEFAULT_VIDEO_BASE_URL);
        try {
            isDalvik = System.getProperty(DALVIK, dalvikDetected);
        }
        catch (SecurityException ignore) {
            isDalvik = dalvikDetected;
        }
        this.IS_DALVIK = Boolean.valueOf(isDalvik);
        try {
            isGAE = System.getProperty(GAE, gaeDetected);
        }
        catch (SecurityException ignore) {
            isGAE = gaeDetected;
        }
        this.IS_GAE = Boolean.valueOf(isGAE);
    }

    @Override
    public final boolean isDalvik() {
        return this.IS_DALVIK;
    }

    @Override
    public boolean isGAE() {
        return this.IS_GAE;
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.debug;
    }

    protected final void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public final String getUserAgent() {
        return this.userAgent;
    }

    protected final void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.initRequestHeaders();
    }

    @Override
    public boolean isPrettyDebugEnabled() {
        return this.prettyDebug;
    }

    protected final void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
        this.fixRestBaseURL();
    }

    protected final void setPrettyDebugEnabled(boolean prettyDebug) {
        this.prettyDebug = prettyDebug;
    }

    protected final void setGZIPEnabled(boolean gzipEnabled) {
        this.gzipEnabled = gzipEnabled;
        this.initRequestHeaders();
    }

    @Override
    public boolean isGZIPEnabled() {
        return this.gzipEnabled;
    }

    private void initRequestHeaders() {
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("User-Agent", this.getUserAgent());
        if (this.gzipEnabled) {
            this.requestHeaders.put("Accept-Encoding", "gzip");
        }
        if (this.IS_DALVIK) {
            this.requestHeaders.put("Connection", "close");
        }
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public final String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    protected final void setHttpProxyHost(String proxyHost) {
        this.httpProxyHost = proxyHost;
    }

    @Override
    public final String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    protected final void setHttpProxyUser(String proxyUser) {
        this.httpProxyUser = proxyUser;
    }

    @Override
    public final String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    protected final void setHttpProxyPassword(String proxyPassword) {
        this.httpProxyPassword = proxyPassword;
    }

    @Override
    public final int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    protected final void setHttpProxyPort(int proxyPort) {
        this.httpProxyPort = proxyPort;
    }

    @Override
    public final int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    protected final void setHttpConnectionTimeout(int connectionTimeout) {
        this.httpConnectionTimeout = connectionTimeout;
    }

    @Override
    public final int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    protected final void setHttpReadTimeout(int readTimeout) {
        this.httpReadTimeout = readTimeout;
    }

    public int getHttpStreamingReadTimeout() {
        return this.httpStreamingReadTimeout;
    }

    protected final void setHttpStreamingReadTimeout(int httpStreamingReadTimeout) {
        this.httpStreamingReadTimeout = httpStreamingReadTimeout;
    }

    @Override
    public final int getHttpRetryCount() {
        return this.httpRetryCount;
    }

    protected final void setHttpRetryCount(int retryCount) {
        this.httpRetryCount = retryCount;
    }

    @Override
    public final int getHttpRetryIntervalSeconds() {
        return this.httpRetryIntervalSeconds;
    }

    protected final void setHttpRetryIntervalSeconds(int retryIntervalSeconds) {
        this.httpRetryIntervalSeconds = retryIntervalSeconds;
    }

    @Override
    public final int getHttpMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    protected final void setHttpMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    @Override
    public final int getHttpDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    protected final void setHttpDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    @Override
    public final String getOAuthAppId() {
        return this.oAuthAppId;
    }

    protected final void setOAuthAppId(String oAuthAppId) {
        this.oAuthAppId = oAuthAppId;
        this.fixRestBaseURL();
    }

    @Override
    public final String getOAuthAppSecret() {
        return this.oAuthAppSecret;
    }

    protected final void setOAuthAppSecret(String oAuthAppSecret) {
        this.oAuthAppSecret = oAuthAppSecret;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAccessToken() {
        return this.oAuthAccessToken;
    }

    protected final void setOAuthAccessToken(String oAuthAccessToken) {
        this.oAuthAccessToken = oAuthAccessToken;
    }

    @Override
    public final String getClientVersion() {
        return this.clientVersion;
    }

    protected final void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        this.initRequestHeaders();
    }

    @Override
    public final String getClientURL() {
        return this.clientURL;
    }

    protected final void setClientURL(String clientURL) {
        this.clientURL = clientURL;
        this.initRequestHeaders();
    }

    @Override
    public String getRestBaseURL() {
        return this.restBaseURL;
    }

    @Override
    public String getVideoBaseURL() {
        return this.videoBaseURL;
    }

    protected final void setRestBaseURL(String restBaseURL) {
        this.restBaseURL = restBaseURL;
        this.fixRestBaseURL();
    }

    private void fixRestBaseURL() {
        if (DEFAULT_REST_BASE_URL.equals(ConfigurationBase.fixURL(false, this.restBaseURL))) {
            this.restBaseURL = ConfigurationBase.fixURL(this.useSSL, this.restBaseURL);
        }
        if (DEFAULT_OAUTH_ACCESS_TOKEN_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAccessTokenURL))) {
            this.oAuthAccessTokenURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAccessTokenURL);
        }
        if (DEFAULT_OAUTH_ACCESS_TOKEN_INFO_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAccessTokenInfoURL))) {
            this.oAuthAccessTokenInfoURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAccessTokenInfoURL);
        }
        if (DEFAULT_OAUTH_DEVICE_TOKEN_URL.equals(ConfigurationBase.fixURL(false, this.oAuthDeviceTokenURL))) {
            this.oAuthDeviceTokenURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthDeviceTokenURL);
        }
        if (DEFAULT_OAUTH_AUTHORIZATION_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAuthorizationURL))) {
            this.oAuthAuthorizationURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAuthorizationURL);
        }
    }

    protected final void setVideoBaseURL(String videoBaseURL) {
        this.videoBaseURL = videoBaseURL;
        this.fixVideoBaseURL();
    }

    private void fixVideoBaseURL() {
        if (DEFAULT_VIDEO_BASE_URL.equals(ConfigurationBase.fixURL(false, this.videoBaseURL))) {
            this.videoBaseURL = ConfigurationBase.fixURL(this.useSSL, this.videoBaseURL);
        }
    }

    @Override
    public String getOAuthAuthorizationURL() {
        return this.oAuthAuthorizationURL;
    }

    protected final void setOAuthAuthorizationURL(String oAuthAuthorizationURL) {
        this.oAuthAuthorizationURL = oAuthAuthorizationURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAccessTokenURL() {
        return this.oAuthAccessTokenURL;
    }

    protected final void setOAuthAccessTokenURL(String oAuthAccessTokenURL) {
        this.oAuthAccessTokenURL = oAuthAccessTokenURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAccessTokenInfoURL() {
        return this.oAuthAccessTokenInfoURL;
    }

    protected final void setOAuthAccessTokenInfoURL(String oAuthAccessTokenInfoURL) {
        this.oAuthAccessTokenInfoURL = oAuthAccessTokenInfoURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthDeviceTokenURL() {
        return this.oAuthDeviceTokenURL;
    }

    protected final void setOAuthDeviceTokenURL(String oAuthDeviceTokenURL) {
        this.oAuthDeviceTokenURL = oAuthDeviceTokenURL;
        this.fixRestBaseURL();
    }

    @Override
    public boolean isJSONStoreEnabled() {
        return this.jsonStoreEnabled;
    }

    protected final void setJSONStoreEnabled(boolean enabled) {
        this.jsonStoreEnabled = enabled;
    }

    @Override
    public boolean isMBeanEnabled() {
        return this.mbeanEnabled;
    }

    protected final void setMBeanEnabled(boolean enabled) {
        this.mbeanEnabled = enabled;
    }

    @Override
    public String getOAuthPermissions() {
        return this.oAuthPermissions;
    }

    protected void setOAuthPermissions(String oAuthPermissions) {
        this.oAuthPermissions = oAuthPermissions;
    }

    @Override
    public String getOAuthCallbackURL() {
        return this.oAuthCallbackURL;
    }

    public void setOAuthCallbackURL(String oAuthCallbackURL) {
        this.oAuthCallbackURL = oAuthCallbackURL;
    }

    @Override
    public boolean isAppSecretProofEnabled() {
        return this.appSecretProofEnabled;
    }

    public void setAppSecretProofEnabled(boolean enabled) {
        this.appSecretProofEnabled = enabled;
    }

    @Override
    public int getAppSecretProofCacheSize() {
        return this.appSecretProofCacheSize;
    }

    public void setAppSecretProofCacheSize(int appSecretProofCacheSize) {
        this.appSecretProofCacheSize = appSecretProofCacheSize;
    }

    static String fixURL(boolean useSSL, String url) {
        if (null == url) {
            return null;
        }
        int index = url.indexOf("://");
        if (-1 == index) {
            throw new IllegalArgumentException("url should contain '://'");
        }
        String hostAndLater = url.substring(index + 3);
        if (useSSL) {
            return "https://" + hostAndLater;
        }
        return "http://" + hostAndLater;
    }

    public int hashCode() {
        int result = this.debug ? 1 : 0;
        result = 31 * result + (this.userAgent != null ? this.userAgent.hashCode() : 0);
        result = 31 * result + (this.useSSL ? 1 : 0);
        result = 31 * result + (this.prettyDebug ? 1 : 0);
        result = 31 * result + (this.gzipEnabled ? 1 : 0);
        result = 31 * result + (this.httpProxyHost != null ? this.httpProxyHost.hashCode() : 0);
        result = 31 * result + (this.httpProxyUser != null ? this.httpProxyUser.hashCode() : 0);
        result = 31 * result + (this.httpProxyPassword != null ? this.httpProxyPassword.hashCode() : 0);
        result = 31 * result + this.httpProxyPort;
        result = 31 * result + this.httpConnectionTimeout;
        result = 31 * result + this.httpReadTimeout;
        result = 31 * result + this.httpStreamingReadTimeout;
        result = 31 * result + this.httpRetryCount;
        result = 31 * result + this.httpRetryIntervalSeconds;
        result = 31 * result + this.maxTotalConnections;
        result = 31 * result + this.defaultMaxPerRoute;
        result = 31 * result + (this.oAuthAppId != null ? this.oAuthAppId.hashCode() : 0);
        result = 31 * result + (this.oAuthAppSecret != null ? this.oAuthAppSecret.hashCode() : 0);
        result = 31 * result + (this.oAuthPermissions != null ? this.oAuthPermissions.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessToken != null ? this.oAuthAccessToken.hashCode() : 0);
        result = 31 * result + (this.oAuthCallbackURL != null ? this.oAuthCallbackURL.hashCode() : 0);
        result = 31 * result + (this.appSecretProofEnabled ? 1 : 0);
        result = 31 * result + this.appSecretProofCacheSize;
        result = 31 * result + (this.oAuthAuthorizationURL != null ? this.oAuthAuthorizationURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessTokenURL != null ? this.oAuthAccessTokenURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessTokenInfoURL != null ? this.oAuthAccessTokenInfoURL.hashCode() : 0);
        result = 31 * result + (this.oAuthDeviceTokenURL != null ? this.oAuthDeviceTokenURL.hashCode() : 0);
        result = 31 * result + (this.restBaseURL != null ? this.restBaseURL.hashCode() : 0);
        result = 31 * result + (this.videoBaseURL != null ? this.videoBaseURL.hashCode() : 0);
        result = 31 * result + (this.jsonStoreEnabled ? 1 : 0);
        result = 31 * result + (this.mbeanEnabled ? 1 : 0);
        result = 31 * result + (this.clientVersion != null ? this.clientVersion.hashCode() : 0);
        result = 31 * result + (this.clientURL != null ? this.clientURL.hashCode() : 0);
        result = 31 * result + (this.IS_DALVIK ? 1 : 0);
        result = 31 * result + (this.IS_GAE ? 1 : 0);
        result = 31 * result + (this.requestHeaders != null ? ((Object)this.requestHeaders).hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationBase)) {
            return false;
        }
        ConfigurationBase that = (ConfigurationBase)o;
        if (this.IS_DALVIK != that.IS_DALVIK) {
            return false;
        }
        if (this.IS_GAE != that.IS_GAE) {
            return false;
        }
        if (this.debug != that.debug) {
            return false;
        }
        if (this.defaultMaxPerRoute != that.defaultMaxPerRoute) {
            return false;
        }
        if (this.gzipEnabled != that.gzipEnabled) {
            return false;
        }
        if (this.httpConnectionTimeout != that.httpConnectionTimeout) {
            return false;
        }
        if (this.httpProxyPort != that.httpProxyPort) {
            return false;
        }
        if (this.httpReadTimeout != that.httpReadTimeout) {
            return false;
        }
        if (this.httpRetryCount != that.httpRetryCount) {
            return false;
        }
        if (this.httpRetryIntervalSeconds != that.httpRetryIntervalSeconds) {
            return false;
        }
        if (this.httpStreamingReadTimeout != that.httpStreamingReadTimeout) {
            return false;
        }
        if (this.jsonStoreEnabled != that.jsonStoreEnabled) {
            return false;
        }
        if (this.maxTotalConnections != that.maxTotalConnections) {
            return false;
        }
        if (this.mbeanEnabled != that.mbeanEnabled) {
            return false;
        }
        if (this.prettyDebug != that.prettyDebug) {
            return false;
        }
        if (this.useSSL != that.useSSL) {
            return false;
        }
        if (this.clientURL != null ? !this.clientURL.equals(that.clientURL) : that.clientURL != null) {
            return false;
        }
        if (this.clientVersion != null ? !this.clientVersion.equals(that.clientVersion) : that.clientVersion != null) {
            return false;
        }
        if (this.httpProxyHost != null ? !this.httpProxyHost.equals(that.httpProxyHost) : that.httpProxyHost != null) {
            return false;
        }
        if (this.httpProxyPassword != null ? !this.httpProxyPassword.equals(that.httpProxyPassword) : that.httpProxyPassword != null) {
            return false;
        }
        if (this.httpProxyUser != null ? !this.httpProxyUser.equals(that.httpProxyUser) : that.httpProxyUser != null) {
            return false;
        }
        if (this.oAuthAccessToken != null ? !this.oAuthAccessToken.equals(that.oAuthAccessToken) : that.oAuthAccessToken != null) {
            return false;
        }
        if (this.oAuthAccessTokenURL != null ? !this.oAuthAccessTokenURL.equals(that.oAuthAccessTokenURL) : that.oAuthAccessTokenURL != null) {
            return false;
        }
        if (this.oAuthAccessTokenInfoURL != null ? !this.oAuthAccessTokenInfoURL.equals(that.oAuthAccessTokenInfoURL) : that.oAuthAccessTokenInfoURL != null) {
            return false;
        }
        if (this.oAuthDeviceTokenURL != null ? !this.oAuthDeviceTokenURL.equals(that.oAuthDeviceTokenURL) : that.oAuthDeviceTokenURL != null) {
            return false;
        }
        if (this.oAuthAppId != null ? !this.oAuthAppId.equals(that.oAuthAppId) : that.oAuthAppId != null) {
            return false;
        }
        if (this.oAuthAppSecret != null ? !this.oAuthAppSecret.equals(that.oAuthAppSecret) : that.oAuthAppSecret != null) {
            return false;
        }
        if (this.oAuthAuthorizationURL != null ? !this.oAuthAuthorizationURL.equals(that.oAuthAuthorizationURL) : that.oAuthAuthorizationURL != null) {
            return false;
        }
        if (this.oAuthCallbackURL != null ? !this.oAuthCallbackURL.equals(that.oAuthCallbackURL) : that.oAuthCallbackURL != null) {
            return false;
        }
        if (this.appSecretProofEnabled != that.appSecretProofEnabled) {
            return false;
        }
        if (this.appSecretProofCacheSize != that.appSecretProofCacheSize) {
            return false;
        }
        if (this.oAuthPermissions != null ? !this.oAuthPermissions.equals(that.oAuthPermissions) : that.oAuthPermissions != null) {
            return false;
        }
        if (this.requestHeaders != null ? !((Object)this.requestHeaders).equals(that.requestHeaders) : that.requestHeaders != null) {
            return false;
        }
        if (this.restBaseURL != null ? !this.restBaseURL.equals(that.restBaseURL) : that.restBaseURL != null) {
            return false;
        }
        if (this.userAgent != null ? !this.userAgent.equals(that.userAgent) : that.userAgent != null) {
            return false;
        }
        return !(this.videoBaseURL != null ? !this.videoBaseURL.equals(that.videoBaseURL) : that.videoBaseURL != null);
    }

    public String toString() {
        return "ConfigurationBase{debug=" + this.debug + ", userAgent='" + this.userAgent + '\'' + ", useSSL=" + this.useSSL + ", prettyDebug=" + this.prettyDebug + ", gzipEnabled=" + this.gzipEnabled + ", httpProxyHost='" + this.httpProxyHost + '\'' + ", httpProxyUser='" + this.httpProxyUser + '\'' + ", httpProxyPassword='" + this.httpProxyPassword + '\'' + ", httpProxyPort=" + this.httpProxyPort + ", httpConnectionTimeout=" + this.httpConnectionTimeout + ", httpReadTimeout=" + this.httpReadTimeout + ", httpStreamingReadTimeout=" + this.httpStreamingReadTimeout + ", httpRetryCount=" + this.httpRetryCount + ", httpRetryIntervalSeconds=" + this.httpRetryIntervalSeconds + ", maxTotalConnections=" + this.maxTotalConnections + ", defaultMaxPerRoute=" + this.defaultMaxPerRoute + ", oAuthAppId='" + this.oAuthAppId + '\'' + ", oAuthAppSecret='" + this.oAuthAppSecret + '\'' + ", oAuthPermissions='" + this.oAuthPermissions + '\'' + ", oAuthAccessToken='" + this.oAuthAccessToken + '\'' + ", oAuthCallbackURL='" + this.oAuthCallbackURL + '\'' + ", appSecretProofEnabled=" + this.appSecretProofEnabled + ", appSecretProofCacheSize=" + this.appSecretProofCacheSize + ", oAuthAuthorizationURL='" + this.oAuthAuthorizationURL + '\'' + ", oAuthAccessTokenURL='" + this.oAuthAccessTokenURL + '\'' + ", oAuthAccessTokenInfoURL='" + this.oAuthAccessTokenInfoURL + '\'' + ", oAuthDeviceTokenURL='" + this.oAuthDeviceTokenURL + '\'' + ", restBaseURL='" + this.restBaseURL + '\'' + ", videoBaseURL='" + this.videoBaseURL + '\'' + ", jsonStoreEnabled=" + this.jsonStoreEnabled + ", mbeanEnabled=" + this.mbeanEnabled + ", clientVersion='" + this.clientVersion + '\'' + ", clientURL='" + this.clientURL + '\'' + ", IS_DALVIK=" + this.IS_DALVIK + ", IS_GAE=" + this.IS_GAE + ", requestHeaders=" + this.requestHeaders + '}';
    }

    private static void cacheInstance(ConfigurationBase conf) {
        if (!instances.contains(conf)) {
            instances.add(conf);
        }
    }

    protected void cacheInstance() {
        ConfigurationBase.cacheInstance(this);
    }

    private static ConfigurationBase getInstance(ConfigurationBase configurationBase) {
        int index = instances.indexOf(configurationBase);
        if (index == -1) {
            instances.add(configurationBase);
            return configurationBase;
        }
        return instances.get(index);
    }

    protected Object readResolve() throws ObjectStreamException {
        return ConfigurationBase.getInstance(this);
    }

    static {
        try {
            Class.forName("dalvik.system.VMRuntime");
            dalvikDetected = "true";
        }
        catch (ClassNotFoundException cnfe) {
            dalvikDetected = "false";
        }
        try {
            Class.forName("com.google.appengine.api.urlfetch.URLFetchService");
            gaeDetected = "true";
        }
        catch (ClassNotFoundException cnfe) {
            gaeDetected = "false";
        }
        instances = new ArrayList<ConfigurationBase>();
    }
}

