/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.RSVPStatus;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RSVPStatusJSONImpl
extends FacebookResponseImpl
implements RSVPStatus,
Serializable {
    private static final long serialVersionUID = 716299001399262503L;
    private String id;
    private String name;
    private String rsvpStatus;

    RSVPStatusJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    RSVPStatusJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        this.id = z_F4JInternalParseUtil.getRawString("id", json);
        this.name = z_F4JInternalParseUtil.getRawString("name", json);
        this.rsvpStatus = z_F4JInternalParseUtil.getRawString("rsvp_status", json);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRsvpStatus() {
        return this.rsvpStatus;
    }

    static ResponseList<RSVPStatus> createRSVPStatusList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<RSVPStatus> rsvpStatuses = new ResponseListImpl<RSVPStatus>(size, json, new RSVPStatus[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject rsvpStatusJSONObject = list.getJSONObject(i);
                RSVPStatusJSONImpl rsvpStatus = new RSVPStatusJSONImpl(rsvpStatusJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(rsvpStatus, rsvpStatusJSONObject);
                }
                rsvpStatuses.add(rsvpStatus);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(rsvpStatuses, list);
            }
            return rsvpStatuses;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RSVPStatusJSONImpl other = (RSVPStatusJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "RSVPStatusJSONImpl [id=" + this.id + ", name=" + this.name + ", rsvpStatus=" + this.rsvpStatus + "]";
    }
}

