/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.FacebookResponse;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class MetadataJSONImpl
implements FacebookResponse.Metadata,
Serializable {
    private static final long serialVersionUID = 2544362523876092964L;
    private FacebookResponse.Metadata.Connections connections;

    MetadataJSONImpl(JSONObject json) throws FacebookException {
        try {
            JSONObject connectionsJSONObject = json.getJSONObject("connections");
            this.connections = new ConnectionsJSONImpl(connectionsJSONObject);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    public FacebookResponse.Metadata.Connections getConnections() {
        return this.connections;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConnectionsJSONImpl
    implements FacebookResponse.Metadata.Connections,
    Serializable {
        private static final long serialVersionUID = -826235388607408320L;
        private Map<String, URL> map = new HashMap<String, URL>();

        ConnectionsJSONImpl(JSONObject json) throws FacebookException {
            try {
                Iterator connectionNames = json.keys();
                while (connectionNames.hasNext()) {
                    String connectionName = (String)connectionNames.next();
                    try {
                        this.map.put(connectionName, new URL((String)json.get(connectionName)));
                    }
                    catch (MalformedURLException ignore) {}
                }
            }
            catch (JSONException jsone) {
                throw new FacebookException(jsone.getMessage(), jsone);
            }
        }

        @Override
        public URL getURL(String connectionName) {
            return this.map.get(connectionName);
        }

        @Override
        public List<String> getConnectionNames() {
            return Arrays.asList(this.map.keySet().toArray(new String[this.map.size()]));
        }
    }
}

