/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.BatchResponse;
import facebook4j.FacebookException;
import facebook4j.ResponseList;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.z_F4JInternalFactory;
import facebook4j.internal.json.z_F4JInternalJSONImplFactory;
import facebook4j.internal.logging.Logger;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchResponseImpl
extends HttpResponse
implements BatchResponse,
Serializable {
    private static final long serialVersionUID = -6354217417137066979L;
    private static final Logger logger = Logger.getLogger(BatchResponseImpl.class);
    private JSONObject json;
    private ConcurrentHashMap<String, List<String>> headers = new ConcurrentHashMap();
    private JSONObject bodyJson = null;
    private final z_F4JInternalFactory factory = new z_F4JInternalJSONImplFactory(null);
    private JSONArray bodyJsonArray = null;

    BatchResponseImpl(JSONObject json) {
        this.json = json;
        if (null != json) {
            this.statusCode = z_F4JInternalParseUtil.getInt("code", json);
        }
    }

    @Override
    public String getResponseHeader(String name) {
        if (this.json == null) {
            return null;
        }
        if (this.headers.isEmpty()) {
            this.cacheHeaders();
        }
        if (!this.headers.containsKey(name)) {
            return null;
        }
        List<String> values = this.headers.get(name);
        return values.get(values.size() - 1);
    }

    @Override
    public Map<String, List<String>> getResponseHeaderFields() {
        if (this.headers.isEmpty()) {
            this.cacheHeaders();
        }
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheHeaders() {
        try {
            JSONArray array = this.json.getJSONArray("headers");
            for (int i = 0; i < array.length(); ++i) {
                JSONObject headersJsonObject = array.getJSONObject(i);
                String n = z_F4JInternalParseUtil.getRawString("name", headersJsonObject);
                String v = z_F4JInternalParseUtil.getRawString("value", headersJsonObject);
                ConcurrentHashMap<String, List<String>> concurrentHashMap = this.headers;
                synchronized (concurrentHashMap) {
                    List<String> values = this.headers.get(n);
                    if (values == null) {
                        values = new ArrayList<String>();
                    }
                    values.add(v);
                    this.headers.put(n, values);
                    continue;
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public String asString() throws FacebookException {
        if (null == this.responseAsString && null != this.json) {
            this.responseAsString = z_F4JInternalParseUtil.getRawString("body", this.json);
        }
        return this.responseAsString;
    }

    @Override
    public JSONObject asJSONObject() throws FacebookException {
        if (this.bodyJson == null) {
            try {
                this.bodyJson = new JSONObject(this.asString());
                if (this.CONF.isPrettyDebugEnabled()) {
                    logger.debug(this.bodyJson.toString(1));
                } else {
                    logger.debug(this.responseAsString != null ? this.responseAsString : this.bodyJson.toString());
                }
            }
            catch (JSONException jsone) {
                if (this.responseAsString == null) {
                    throw new FacebookException(jsone.getMessage(), jsone);
                }
                throw new FacebookException(jsone.getMessage() + ":" + this.responseAsString, jsone);
            }
        }
        return this.bodyJson;
    }

    @Override
    public ResponseList<JSONObject> asResponseList() throws FacebookException {
        return this.factory.createJSONObjectList(this.asJSONObject());
    }

    @Override
    public JSONArray asJSONArray() throws FacebookException {
        if (this.bodyJsonArray == null) {
            try {
                this.bodyJsonArray = new JSONArray(this.asString());
                if (this.CONF.isPrettyDebugEnabled()) {
                    logger.debug(this.bodyJsonArray.toString(1));
                } else {
                    logger.debug(this.responseAsString != null ? this.responseAsString : this.bodyJsonArray.toString());
                }
            }
            catch (JSONException jsone) {
                if (this.responseAsString == null) {
                    throw new FacebookException(jsone.getMessage(), jsone);
                }
                throw new FacebookException(jsone.getMessage() + ":" + this.responseAsString, jsone);
            }
        }
        return this.bodyJsonArray;
    }

    @Override
    public void disconnect() throws IOException {
    }

    @Override
    public InputStream asStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader asReader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "BatchResponse{statusCode=" + this.statusCode + ", responseAsString=" + this.responseAsString + ", json=" + this.json + '}';
    }
}

