/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.parser;

import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.firebirdsql.jdbc.parser.BooleanLiteralToken;
import org.firebirdsql.jdbc.parser.ColonToken;
import org.firebirdsql.jdbc.parser.CommaToken;
import org.firebirdsql.jdbc.parser.CommentToken;
import org.firebirdsql.jdbc.parser.CurlyBraceClose;
import org.firebirdsql.jdbc.parser.CurlyBraceOpen;
import org.firebirdsql.jdbc.parser.GenericToken;
import org.firebirdsql.jdbc.parser.NullLiteralToken;
import org.firebirdsql.jdbc.parser.NumericLiteralToken;
import org.firebirdsql.jdbc.parser.OperatorToken;
import org.firebirdsql.jdbc.parser.ParenthesisClose;
import org.firebirdsql.jdbc.parser.ParenthesisOpen;
import org.firebirdsql.jdbc.parser.PeriodToken;
import org.firebirdsql.jdbc.parser.PositionalParameterToken;
import org.firebirdsql.jdbc.parser.QuotedIdentifierToken;
import org.firebirdsql.jdbc.parser.ReservedToken;
import org.firebirdsql.jdbc.parser.ReservedWords;
import org.firebirdsql.jdbc.parser.SemicolonToken;
import org.firebirdsql.jdbc.parser.SquareBracketClose;
import org.firebirdsql.jdbc.parser.SquareBracketOpen;
import org.firebirdsql.jdbc.parser.StringLiteralToken;
import org.firebirdsql.jdbc.parser.Token;
import org.firebirdsql.jdbc.parser.UnexpectedEndOfInputException;
import org.firebirdsql.jdbc.parser.WhitespaceToken;

public final class SqlTokenizer
implements Iterator<Token>,
AutoCloseable {
    private final String src;
    private final ReservedWords reservedWords;
    private int pos = 0;
    private Token next;
    private static final TokenConstructor<OperatorToken> OPERATOR_TOKEN_CONSTRUCTOR = new TokenConstructor<OperatorToken>(){

        @Override
        public OperatorToken construct(int pos, CharSequence src, int start, int end) {
            return new OperatorToken(pos, src, start, end);
        }
    };
    private static final TokenConstructor<BooleanLiteralToken> FALSE_TOKEN_CONSTRUCTOR = new TokenConstructor<BooleanLiteralToken>(){

        @Override
        public BooleanLiteralToken construct(int pos, CharSequence src, int start, int end) {
            return BooleanLiteralToken.falseToken(pos, src, start, end);
        }
    };
    private static final TokenConstructor<BooleanLiteralToken> TRUE_TOKEN_CONSTRUCTOR = new TokenConstructor<BooleanLiteralToken>(){

        @Override
        public BooleanLiteralToken construct(int pos, CharSequence src, int start, int end) {
            return BooleanLiteralToken.trueToken(pos, src, start, end);
        }
    };
    private static final TokenConstructor<BooleanLiteralToken> BOOLEAN_UNKNOWN_TOKEN_CONSTRUCTOR = new TokenConstructor<BooleanLiteralToken>(){

        @Override
        public BooleanLiteralToken construct(int pos, CharSequence src, int start, int end) {
            return BooleanLiteralToken.unknownToken(pos, src, start, end);
        }
    };
    private static final TokenConstructor<NullLiteralToken> NULL_LITERAL_TOKEN_CONSTRUCTOR = new TokenConstructor<NullLiteralToken>(){

        @Override
        public NullLiteralToken construct(int pos, CharSequence src, int start, int end) {
            return new NullLiteralToken(pos, src, start, end);
        }
    };
    private static final char[][] UNKNOWN_SUFFIX = new char[][]{{'n', 'N'}, {'k', 'K'}, {'n', 'N'}, {'o', 'O'}, {'w', 'W'}, {'n', 'N'}};
    private static final char[][] TRUE_SUFFIX = new char[][]{{'r', 'R'}, {'u', 'U'}, {'e', 'E'}};
    private static final char[][] OR_SUFFIX = new char[][]{{'r', 'R'}};
    private static final char[][] NOT_SUFFIX = new char[][]{{'o', 'O'}, {'t', 'T'}};
    private static final char[][] NULL_SUFFIX = new char[][]{{'u', 'U'}, {'l', 'L'}, {'l', 'L'}};
    private static final char[][] LIKE_SUFFIX = new char[][]{{'i', 'I'}, {'k', 'K'}, {'e', 'E'}};
    private static final char[][] IS_SUFFIX = new char[][]{{'s', 'S'}};
    private static final char[][] FALSE_SUFFIX = new char[][]{{'a', 'A'}, {'l', 'L'}, {'s', 'S'}, {'e', 'E'}};
    private static final char[][] AND_SUFFIX = new char[][]{{'n', 'N'}, {'d', 'D'}};

    private SqlTokenizer(String src, ReservedWords reservedWords) {
        this.src = src;
        this.reservedWords = reservedWords;
    }

    public static Builder withReservedWords(ReservedWords reservedWords) {
        return new Builder(reservedWords);
    }

    @Override
    public boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        if (this.next == null) {
            this.next = this.nextToken();
        }
        return this.next != null;
    }

    @Override
    public Token next() {
        Token nextToken = this.next;
        if (nextToken != null) {
            this.next = null;
        } else {
            nextToken = this.nextToken();
        }
        if (nextToken != null) {
            return nextToken;
        }
        throw new NoSuchElementException("No more tokens");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void close() {
        this.pos = -1;
    }

    private boolean isClosed() {
        return this.pos == -1;
    }

    private int read() {
        int length = this.src.length();
        if (this.pos < length) {
            return this.src.charAt(this.pos++);
        }
        this.pos = length;
        return -1;
    }

    private char requireChar() {
        int c = this.read();
        if (c == -1) {
            int originalPosition = this.pos;
            this.close();
            throw new UnexpectedEndOfInputException(String.format("Reached end of input at position %d while character was read", originalPosition));
        }
        return (char)c;
    }

    private void skip() {
        if (this.pos < this.src.length()) {
            ++this.pos;
        } else {
            throw new UnexpectedEndOfInputException(String.format("Reached end of input at position %d while skipping", this.pos));
        }
    }

    private void skip(int amount) {
        int length = this.src.length();
        if (this.pos + amount <= length) {
            this.pos += amount;
        } else {
            this.pos = length;
            throw new UnexpectedEndOfInputException(String.format("Reached end of input after position %d while skipping", this.pos));
        }
    }

    private void unread(int c) {
        if (c != -1) {
            --this.pos;
        }
    }

    private void unread(int[] chars, int lastIndex) {
        while (lastIndex >= 0) {
            this.unread(chars[lastIndex--]);
        }
    }

    private int peek() {
        return this.pos < this.src.length() ? (int)this.src.charAt(this.pos) : -1;
    }

    private Token nextToken() {
        if (this.isClosed()) {
            return null;
        }
        int start = this.pos;
        int c = this.read();
        switch (c) {
            case -1: {
                this.close();
                return null;
            }
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return this.readWhitespaceToken(start);
            }
            case 40: {
                return new ParenthesisOpen(start);
            }
            case 41: {
                return new ParenthesisClose(start);
            }
            case 123: {
                return new CurlyBraceOpen(start);
            }
            case 125: {
                return new CurlyBraceClose(start);
            }
            case 91: {
                return new SquareBracketOpen(start);
            }
            case 93: {
                return new SquareBracketClose(start);
            }
            case 59: {
                return new SemicolonToken(start);
            }
            case 44: {
                return new CommaToken(start);
            }
            case 46: {
                if (SqlTokenizer.isDigit(this.peek())) {
                    return this.readNumericLiteral(start, '.');
                }
                return new PeriodToken(start);
            }
            case 42: 
            case 43: 
            case 61: {
                return new OperatorToken(start, this.src, start, this.pos);
            }
            case 45: {
                if (this.peek() == 45) {
                    return this.readLineComment(start);
                }
                return new OperatorToken(start, this.src, start, this.pos);
            }
            case 47: {
                if (this.peek() == 42) {
                    return this.readBlockComment(start);
                }
                return new OperatorToken(start, this.src, start, this.pos);
            }
            case 60: {
                int cNext = this.read();
                switch (cNext) {
                    case 61: 
                    case 62: {
                        return new OperatorToken(start, this.src, start, this.pos);
                    }
                }
                this.unread(cNext);
                return new OperatorToken(start, this.src, start, this.pos);
            }
            case 62: {
                int cNext = this.read();
                if (cNext == 61) {
                    return new OperatorToken(start, this.src, start, this.pos);
                }
                this.unread(cNext);
                return new OperatorToken(start, this.src, start, this.pos);
            }
            case 33: 
            case 94: 
            case 126: {
                int cNext = this.read();
                switch (cNext) {
                    case 60: 
                    case 61: 
                    case 62: {
                        return new OperatorToken(start, this.src, start, this.pos);
                    }
                }
                this.unread(cNext);
                return new OperatorToken(start, this.src, start, this.pos);
            }
            case 124: {
                int cNext = this.read();
                if (cNext == 124) {
                    return new OperatorToken(start, this.src, start, this.pos);
                }
                this.unread(cNext);
                return new OperatorToken(start, this.src, start, this.pos);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.readNumericLiteral(start, (char)c);
            }
            case 39: {
                return this.readStringLiteral(start);
            }
            case 65: 
            case 97: {
                if (this.detectAnd()) {
                    return this.readTokenByLength(start, 2, OPERATOR_TOKEN_CONSTRUCTOR);
                }
                return this.readOtherToken(start);
            }
            case 70: 
            case 102: {
                if (this.detectFalse()) {
                    return this.readTokenByLength(start, 4, FALSE_TOKEN_CONSTRUCTOR);
                }
                return this.readOtherToken(start);
            }
            case 73: 
            case 105: {
                if (this.detectIs()) {
                    return this.readTokenByLength(start, 1, OPERATOR_TOKEN_CONSTRUCTOR);
                }
                return this.readOtherToken(start);
            }
            case 76: 
            case 108: {
                if (this.detectLike()) {
                    return this.readTokenByLength(start, 3, OPERATOR_TOKEN_CONSTRUCTOR);
                }
                return this.readOtherToken(start);
            }
            case 78: 
            case 110: {
                if (this.detectNull()) {
                    return this.readTokenByLength(start, 3, NULL_LITERAL_TOKEN_CONSTRUCTOR);
                }
                if (this.detectNot()) {
                    return this.readTokenByLength(start, 2, OPERATOR_TOKEN_CONSTRUCTOR);
                }
                return this.readOtherToken(start);
            }
            case 79: 
            case 111: {
                if (this.detectOr()) {
                    return this.readTokenByLength(start, 1, OPERATOR_TOKEN_CONSTRUCTOR);
                }
                return this.readOtherToken(start);
            }
            case 81: 
            case 113: {
                if (this.peek() == 39) {
                    return this.readQStringLiteral(start);
                }
                return this.readOtherToken(start);
            }
            case 84: 
            case 116: {
                if (this.detectTrue()) {
                    return this.readTokenByLength(start, 3, TRUE_TOKEN_CONSTRUCTOR);
                }
                return this.readOtherToken(start);
            }
            case 85: 
            case 117: {
                if (this.detectUnknown()) {
                    return this.readTokenByLength(start, 6, BOOLEAN_UNKNOWN_TOKEN_CONSTRUCTOR);
                }
                return this.readOtherToken(start);
            }
            case 88: 
            case 120: {
                int cNext = this.read();
                if (cNext == 39) {
                    return this.readHexStringLiteral(start);
                }
                this.unread(cNext);
                return this.readOtherToken(start);
            }
            case 63: {
                return new PositionalParameterToken(start);
            }
            case 58: {
                return new ColonToken(start);
            }
            case 34: {
                return this.readQuotedIdentifier(start);
            }
        }
        return this.readOtherToken(start);
    }

    private boolean detectUnknown() {
        return this.detectToken(UNKNOWN_SUFFIX);
    }

    private boolean detectTrue() {
        return this.detectToken(TRUE_SUFFIX);
    }

    private boolean detectOr() {
        return this.detectToken(OR_SUFFIX);
    }

    private boolean detectNot() {
        return this.detectToken(NOT_SUFFIX);
    }

    private boolean detectNull() {
        return this.detectToken(NULL_SUFFIX);
    }

    private boolean detectLike() {
        return this.detectToken(LIKE_SUFFIX);
    }

    private boolean detectIs() {
        return this.detectToken(IS_SUFFIX);
    }

    private boolean detectFalse() {
        return this.detectToken(FALSE_SUFFIX);
    }

    private boolean detectAnd() {
        return this.detectToken(AND_SUFFIX);
    }

    private WhitespaceToken readWhitespaceToken(int start) {
        int c;
        while (SqlTokenizer.isWhitespace(c = this.read())) {
        }
        this.unread(c);
        return new WhitespaceToken(start, this.src, start, this.pos);
    }

    private CommentToken readLineComment(int start) {
        int c;
        this.skip();
        while (!SqlTokenizer.isEndOfLine(c = this.read())) {
        }
        this.unread(c);
        return new CommentToken(start, this.src, start, this.pos);
    }

    private CommentToken readBlockComment(int start) {
        this.skip();
        char c = this.requireChar();
        while (true) {
            if (c == '*' && this.peek() == 47) break;
            c = this.requireChar();
        }
        this.skip();
        return new CommentToken(start, this.src, start, this.pos);
    }

    private NumericLiteralToken readNumericLiteral(int start, char firstChar) {
        int c;
        boolean beforeDecimalSeparator;
        if (firstChar == '0' && this.peek() == 120) {
            return this.continueBinaryNumericLiteral(start);
        }
        boolean bl = beforeDecimalSeparator = firstChar != '.';
        while (SqlTokenizer.isDigit(c = this.read()) || c == 46 && beforeDecimalSeparator) {
            if (c != 46) continue;
            beforeDecimalSeparator = false;
        }
        if (c == 101 || c == 69) {
            c = this.read();
            if (c != 43 && c != 45 && !SqlTokenizer.isDigit(c)) {
                this.unread(c);
            }
            while (SqlTokenizer.isDigit(c = this.read())) {
            }
        }
        this.unread(c);
        return new NumericLiteralToken(start, this.src, start, this.pos);
    }

    private NumericLiteralToken continueBinaryNumericLiteral(int start) {
        int c;
        this.skip();
        while (SqlTokenizer.isHexDigit(c = this.read())) {
        }
        this.unread(c);
        return new NumericLiteralToken(start, this.src, start, this.pos);
    }

    private StringLiteralToken readHexStringLiteral(int start) {
        return this.readStringLiteral(start);
    }

    private StringLiteralToken readStringLiteral(int start) {
        char c;
        while ((c = this.requireChar()) != '\'' || this.peek() == 39) {
            if (c != '\'') continue;
            this.skip();
        }
        return new StringLiteralToken(start, this.src, start, this.pos);
    }

    private StringLiteralToken readQStringLiteral(int start) {
        this.skip();
        char startToken = this.requireChar();
        char endToken = this.computeCloseQuote(startToken);
        char c = this.requireChar();
        while (true) {
            if (c == endToken && this.peek() == 39) break;
            c = this.requireChar();
        }
        this.skip();
        return new StringLiteralToken(start, this.src, start, this.pos);
    }

    private char computeCloseQuote(char specialChar) {
        switch (specialChar) {
            case '[': {
                return ']';
            }
            case '(': {
                return ')';
            }
            case '{': {
                return '}';
            }
            case '<': {
                return '>';
            }
        }
        return specialChar;
    }

    private QuotedIdentifierToken readQuotedIdentifier(int start) {
        char c;
        while ((c = this.requireChar()) != '\"' || this.peek() == 34) {
            if (c != '\"') continue;
            this.skip();
        }
        return new QuotedIdentifierToken(start, this.src, start, this.pos);
    }

    private Token readOtherToken(int start) {
        int c;
        while (!SqlTokenizer.isNormalTokenBoundary(c = this.read())) {
        }
        this.unread(c);
        int end = this.pos;
        CharBuffer tokenText = CharBuffer.wrap(this.src, start, end);
        if (this.reservedWords.isReservedWord(tokenText)) {
            return new ReservedToken(start, tokenText);
        }
        return new GenericToken(start, tokenText);
    }

    private <T extends Token> T readTokenByLength(int start, int remainingChars, TokenConstructor<T> tokenConstructor) {
        this.skip(remainingChars);
        return tokenConstructor.construct(start, this.src, start, this.pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detectToken(char[][] expectedChars) {
        int maxChars = expectedChars.length;
        int[] readChars = new int[maxChars + 1];
        int idx = -1;
        try {
            block4: while (++idx < maxChars) {
                int currentChar = readChars[idx] = this.read();
                for (char expectedChar : expectedChars[idx]) {
                    if (currentChar == expectedChar) continue block4;
                }
                boolean bl = false;
                return bl;
            }
            readChars[idx] = this.read();
            boolean bl = SqlTokenizer.isNormalTokenBoundary(readChars[idx]);
            return bl;
        }
        finally {
            this.unread(readChars, idx);
        }
    }

    private static boolean isNormalTokenBoundary(int c) {
        switch (c) {
            case -1: 
            case 9: 
            case 10: 
            case 13: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 91: 
            case 93: 
            case 94: 
            case 123: 
            case 125: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    private static boolean isWhitespace(int c) {
        switch (c) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static boolean isEndOfLine(int c) {
        switch (c) {
            case -1: 
            case 10: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    private static boolean isHexDigit(int c) {
        return SqlTokenizer.isDigit(c) || 65 <= c && c <= 70 || 97 <= c && c <= 102;
    }

    public static final class Builder {
        private final ReservedWords reservedWords;

        private Builder(ReservedWords reservedWords) {
            this.reservedWords = reservedWords;
        }

        public SqlTokenizer of(String statementText) {
            return new SqlTokenizer(statementText, this.reservedWords);
        }
    }

    private static interface TokenConstructor<T extends Token> {
        public T construct(int var1, CharSequence var2, int var3, int var4);
    }
}

